/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.compat.thermalexpansion;

import cofh.thermalexpansion.util.managers.machine.CrucibleManager;
import com.blamejared.ModTweaker;
import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.utils.BaseUndoable;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.thermalexpansion.Crucible")
@ModOnly(value="thermalexpansion")
@ZenRegister
public class Crucible {
    @ZenMethod
    public static void addRecipe(ILiquidStack output, IItemStack input, int energy) {
        ModTweaker.LATE_ADDITIONS.add((IAction)new Add(InputHelper.toFluid((ILiquidStack)output), InputHelper.toStack((IItemStack)input), energy));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack input) {
        ModTweaker.LATE_REMOVALS.add((IAction)new Remove(InputHelper.toStack((IItemStack)input)));
    }

    private static class Remove
    extends BaseUndoable {
        private ItemStack input;

        public Remove(ItemStack input) {
            super("Crucible");
            this.input = input;
        }

        public void apply() {
            if (!CrucibleManager.recipeExists((ItemStack)this.input)) {
                CraftTweakerAPI.logError((String)("No Crucible recipe exists for: " + this.input));
                return;
            }
            CrucibleManager.removeRecipe((ItemStack)this.input);
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((Object)this.input);
        }
    }

    private static class Add
    extends BaseUndoable {
        private FluidStack output;
        private ItemStack input;
        private int energy;

        public Add(FluidStack output, ItemStack input, int energy) {
            super("Crucible");
            this.output = output;
            this.input = input;
            this.energy = energy;
        }

        public void apply() {
            CrucibleManager.addRecipe((int)this.energy, (ItemStack)this.input, (FluidStack)this.output);
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((FluidStack)this.output);
        }
    }
}

