/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.compat.thermalexpansion;

import cofh.thermalexpansion.util.managers.machine.EnchanterManager;
import com.blamejared.ModTweaker;
import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.utils.BaseUndoable;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.thermalexpansion.Enchanter")
@ModOnly(value="thermalexpansion")
@ZenRegister
public class Enchanter {
    @ZenMethod
    public static void addRecipe(IItemStack output, IItemStack input, IItemStack secondInput, int energy, int experience, boolean empowered) {
        ModTweaker.LATE_ADDITIONS.add((IAction)new Add(InputHelper.toStack((IItemStack)output), InputHelper.toStack((IItemStack)input), InputHelper.toStack((IItemStack)secondInput), energy, experience, empowered ? EnchanterManager.Type.EMPOWERED : EnchanterManager.Type.STANDARD));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack input, IItemStack secondInput) {
        ModTweaker.LATE_REMOVALS.add((IAction)new Remove(InputHelper.toStack((IItemStack)input), InputHelper.toStack((IItemStack)secondInput)));
    }

    private static class Remove
    extends BaseUndoable {
        private ItemStack input;
        private ItemStack inputSecondary;

        public Remove(ItemStack input, ItemStack inputSecondary) {
            super("Enchanter");
            this.input = input;
            this.inputSecondary = inputSecondary;
        }

        public void apply() {
            if (!EnchanterManager.recipeExists((ItemStack)this.input, (ItemStack)this.inputSecondary)) {
                CraftTweakerAPI.logError((String)("No Enchanter recipe exists for: " + this.input + " and " + this.inputSecondary));
                return;
            }
            EnchanterManager.removeRecipe((ItemStack)this.input, (ItemStack)this.inputSecondary);
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((Object)this.input) + " and " + LogHelper.getStackDescription((Object)this.inputSecondary);
        }
    }

    private static class Add
    extends BaseUndoable {
        private ItemStack output;
        private ItemStack input;
        private ItemStack inputSecondary;
        private int energy;
        private int experience;
        private EnchanterManager.Type type;

        public Add(ItemStack output, ItemStack input, ItemStack inputSecondary, int energy, int experience, EnchanterManager.Type type) {
            super("Enchanter");
            this.output = output;
            this.input = input;
            this.inputSecondary = inputSecondary;
            this.energy = energy;
            this.experience = experience;
            this.type = type;
        }

        public void apply() {
            EnchanterManager.addRecipe((int)this.energy, (ItemStack)this.input, (ItemStack)this.inputSecondary, (ItemStack)this.output, (int)this.experience, (EnchanterManager.Type)this.type);
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((Object)this.input) + " and " + LogHelper.getStackDescription((Object)this.inputSecondary);
        }
    }
}

