/*
 * Decompiled with CFR 0.152.
 */
package amerifrance.guideapi;

import amerifrance.guideapi.ConfigHandler;
import amerifrance.guideapi.api.GuideAPI;
import amerifrance.guideapi.api.IGuideBook;
import amerifrance.guideapi.api.impl.Book;
import amerifrance.guideapi.network.PacketHandler;
import amerifrance.guideapi.proxy.CommonProxy;
import amerifrance.guideapi.util.AnnotationHandler;
import amerifrance.guideapi.util.EventHandler;
import java.io.File;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import org.apache.commons.lang3.tuple.Pair;

@Mod(modid="guideapi", name="Guide-API", version="1.12-2.1.4-56", acceptedMinecraftVersions="[1.12]")
public class GuideMod {
    public static final String NAME = "Guide-API";
    public static final String ID = "guideapi";
    public static final String CHANNEL = "GuideAPI";
    public static final String VERSION = "1.12-2.1.4-56";
    @Mod.Instance(value="guideapi")
    public static GuideMod INSTANCE;
    @SidedProxy(clientSide="amerifrance.guideapi.proxy.ClientProxy", serverSide="amerifrance.guideapi.proxy.CommonProxy")
    public static CommonProxy proxy;
    private static File configDir;
    private static boolean isDev;
    private static ASMDataTable dataTable;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        configDir = new File(event.getModConfigurationDirectory(), NAME);
        configDir.mkdirs();
        ConfigHandler.init(new File(configDir, "Guide-API.cfg"));
        GuideAPI.initialize();
        dataTable = event.getAsmData();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)proxy);
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
        PacketHandler.registerPackets();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.initColors();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ConfigHandler.handleBookConfigs();
        for (Pair<Book, IGuideBook> guide : AnnotationHandler.BOOK_CLASSES) {
            ((IGuideBook)guide.getRight()).handlePost(GuideAPI.getStackFromBook((Book)guide.getLeft()));
        }
    }

    public static File getConfigDir() {
        return configDir;
    }

    public static boolean isDev() {
        return isDev;
    }

    public static ASMDataTable getDataTable() {
        return dataTable;
    }

    static {
        isDev = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
    }
}

