/*
 * Decompiled with CFR 0.152.
 */
package amerifrance.guideapi.item;

import amerifrance.guideapi.GuideMod;
import amerifrance.guideapi.api.GuideAPI;
import amerifrance.guideapi.api.IGuideItem;
import amerifrance.guideapi.api.IGuideLinked;
import amerifrance.guideapi.api.impl.Book;
import amerifrance.guideapi.api.impl.abstraction.CategoryAbstract;
import amerifrance.guideapi.api.util.TextHelper;
import com.google.common.base.Strings;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemGuideBook
extends Item
implements IGuideItem {
    @Nonnull
    private final Book book;

    public ItemGuideBook(@Nonnull Book book) {
        this.book = book;
        this.func_77625_d(1);
        this.func_77637_a(book.getCreativeTab());
        this.func_77655_b("guideapi.book." + book.getRegistryName().func_110624_b() + "." + book.getRegistryName().func_110623_a());
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        player.openGui((Object)GuideMod.INSTANCE, GuideAPI.getIndexedBooks().indexOf(this.book), world, hand.ordinal(), 0, 0);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K || !player.func_70093_af()) {
            return EnumActionResult.PASS;
        }
        ItemStack stack = player.func_184586_b(hand);
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof IGuideLinked) {
            IGuideLinked guideLinked = (IGuideLinked)state.func_177230_c();
            ResourceLocation entryKey = guideLinked.getLinkedEntry(world, pos, player, stack);
            if (entryKey == null) {
                return EnumActionResult.FAIL;
            }
            for (CategoryAbstract category : this.book.getCategoryList()) {
                if (!category.entries.containsKey(entryKey)) continue;
                GuideMod.proxy.openEntry(this.book, category, category.entries.get(entryKey), player, stack);
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    public String func_77653_i(ItemStack stack) {
        return !Strings.isNullOrEmpty((String)this.book.getDisplayName()) ? this.getBook(stack).getLocalizedDisplayName() : super.func_77653_i(stack);
    }

    public void func_77624_a(ItemStack stack, World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        if (!Strings.isNullOrEmpty((String)this.book.getAuthor())) {
            tooltip.add(TextHelper.localizeEffect(this.book.getAuthor(), new Object[0]));
        }
        if (!Strings.isNullOrEmpty((String)this.book.getAuthor()) && advanced == ITooltipFlag.TooltipFlags.ADVANCED) {
            tooltip.add(this.book.getRegistryName().toString());
        }
    }

    @Override
    public Book getBook(ItemStack stack) {
        return this.book;
    }
}

