/*
 * Decompiled with CFR 0.152.
 */
package amerifrance.guideapi.page;

import amerifrance.guideapi.api.IRecipeRenderer;
import amerifrance.guideapi.api.impl.Book;
import amerifrance.guideapi.api.impl.Page;
import amerifrance.guideapi.api.impl.abstraction.CategoryAbstract;
import amerifrance.guideapi.api.impl.abstraction.EntryAbstract;
import amerifrance.guideapi.gui.GuiBase;
import amerifrance.guideapi.page.reciperenderer.ShapedOreRecipeRenderer;
import amerifrance.guideapi.page.reciperenderer.ShapedRecipesRenderer;
import amerifrance.guideapi.page.reciperenderer.ShapelessOreRecipeRenderer;
import amerifrance.guideapi.page.reciperenderer.ShapelessRecipesRenderer;
import amerifrance.guideapi.util.LogHelper;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class PageIRecipe
extends Page {
    public IRecipe recipe;
    public IRecipeRenderer iRecipeRenderer;

    public PageIRecipe(IRecipe recipe) {
        this(recipe, PageIRecipe.getRenderer(recipe));
    }

    public PageIRecipe(IRecipe recipe, IRecipeRenderer iRecipeRenderer) {
        this.recipe = recipe;
        this.iRecipeRenderer = iRecipeRenderer;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(Book book, CategoryAbstract category, EntryAbstract entry, int guiLeft, int guiTop, int mouseX, int mouseY, GuiBase guiBase, FontRenderer fontRendererObj) {
        super.draw(book, category, entry, guiLeft, guiTop, mouseX, mouseY, guiBase, fontRendererObj);
        this.iRecipeRenderer.draw(book, category, entry, guiLeft, guiTop, mouseX, mouseY, guiBase, fontRendererObj);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawExtras(Book book, CategoryAbstract category, EntryAbstract entry, int guiLeft, int guiTop, int mouseX, int mouseY, GuiBase guiBase, FontRenderer fontRendererObj) {
        super.drawExtras(book, category, entry, guiLeft, guiTop, mouseX, mouseY, guiBase, fontRendererObj);
        this.iRecipeRenderer.drawExtras(book, category, entry, guiLeft, guiTop, mouseX, mouseY, guiBase, fontRendererObj);
    }

    public static PageIRecipe newShaped(ItemStack output, Object ... input) {
        return new PageIRecipe((IRecipe)new ShapedOreRecipe(null, output, input));
    }

    public static PageIRecipe newShapeless(ItemStack output, Object ... input) {
        return new PageIRecipe((IRecipe)new ShapelessOreRecipe(null, output, input));
    }

    @Nullable
    public static PageIRecipe fromJson(ResourceLocation recipeResourceLocation) {
        IRecipe recipe = CraftingManager.func_193373_a((ResourceLocation)recipeResourceLocation);
        if (recipe == null) {
            LogHelper.error("Recipe for ResourceLocation " + recipeResourceLocation.toString() + " was null!");
            return null;
        }
        return new PageIRecipe(recipe, PageIRecipe.getRenderer(recipe));
    }

    private static IRecipeRenderer getRenderer(IRecipe recipe) {
        if (recipe == null) {
            return null;
        }
        if (recipe.getClass() == ShapedRecipes.class) {
            return new ShapedRecipesRenderer((ShapedRecipes)recipe);
        }
        if (recipe.getClass() == ShapelessRecipes.class) {
            return new ShapelessRecipesRenderer((ShapelessRecipes)recipe);
        }
        if (recipe.getClass() == ShapedOreRecipe.class) {
            return new ShapedOreRecipeRenderer((ShapedOreRecipe)recipe);
        }
        if (recipe.getClass() == ShapelessOreRecipe.class) {
            return new ShapelessOreRecipeRenderer((ShapelessOreRecipe)recipe);
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageIRecipe)) {
            return false;
        }
        PageIRecipe other = (PageIRecipe)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IRecipe this$recipe = this.recipe;
        IRecipe other$recipe = other.recipe;
        if (this$recipe == null ? other$recipe != null : !this$recipe.equals(other$recipe)) {
            return false;
        }
        IRecipeRenderer this$iRecipeRenderer = this.iRecipeRenderer;
        IRecipeRenderer other$iRecipeRenderer = other.iRecipeRenderer;
        return !(this$iRecipeRenderer == null ? other$iRecipeRenderer != null : !this$iRecipeRenderer.equals(other$iRecipeRenderer));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageIRecipe;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        IRecipe $recipe = this.recipe;
        result = result * 59 + ($recipe == null ? 43 : $recipe.hashCode());
        IRecipeRenderer $iRecipeRenderer = this.iRecipeRenderer;
        result = result * 59 + ($iRecipeRenderer == null ? 43 : $iRecipeRenderer.hashCode());
        return result;
    }
}

