/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.feature;

import cofh.cofhworld.CoFHWorld;
import cofh.cofhworld.biome.BiomeInfoSet;
import cofh.cofhworld.feature.IDistribution;
import cofh.cofhworld.feature.IGenerator;
import cofh.cofhworld.init.FeatureParser;
import cofh.cofhworld.util.numbers.INumberProvider;
import cofh.shade.com.typesafe.config.Config;
import cofh.shade.com.typesafe.config.ConfigList;
import cofh.shade.com.typesafe.config.ConfigValue;
import cofh.shade.com.typesafe.config.ConfigValueType;
import gnu.trove.set.hash.THashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class Feature {
    private String name;
    private boolean enabled = true;
    private GenRestriction biomeRestriction = GenRestriction.NONE;
    private GenRestriction dimensionRestriction = GenRestriction.NONE;
    private boolean retrogen = false;
    private boolean withVillage = true;
    private int rarity;
    private INumberProvider chunkCount;
    private final BiomeInfoSet biomes = new BiomeInfoSet(1);
    private final Set<Integer> dimensions = new THashSet();
    private IGenerator generator;
    private IDistribution distribution;

    public Feature(String name, Config config) {
        this.name = name;
        this.loadFromConfig(config);
    }

    public void setDistribution(IDistribution d) {
        this.distribution = d;
    }

    public void setGenerator(IGenerator g) {
        this.generator = g;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public INumberProvider getChunkCount() {
        return this.chunkCount;
    }

    public final String getName() {
        return this.name;
    }

    public boolean generate(Random random, int chunkX, int chunkZ, World world, boolean hasVillage, boolean newGen) {
        if (!newGen && !this.retrogen) {
            return false;
        }
        if (hasVillage && !this.withVillage) {
            return false;
        }
        if (this.dimensionRestriction != GenRestriction.NONE && this.dimensionRestriction == GenRestriction.BLACKLIST == this.dimensions.contains(world.field_73011_w.getDimension())) {
            return false;
        }
        if (this.rarity > 1 && random.nextInt(this.rarity) != 0) {
            return false;
        }
        return this.distribution.apply(this, random, chunkX * 16 + 8, chunkZ * 16 + 8, world);
    }

    public boolean canGenerateInBiome(World world, int x, int z, Random rand) {
        if (this.biomeRestriction != GenRestriction.NONE) {
            Biome biome = world.func_180494_b(new BlockPos(x, 0, z));
            return this.biomeRestriction == GenRestriction.BLACKLIST != this.biomes.contains(biome, rand);
        }
        return true;
    }

    public boolean applyGenerator(World world, Random rand, BlockPos p) {
        return this.generator.generate(this, world, rand, p);
    }

    private void loadFromConfig(Config config) {
        if (config.hasPath("enabled") && !config.getBoolean("enabled")) {
            this.enabled = false;
            return;
        }
        boolean bl = this.retrogen = config.hasPath("retrogen") && config.getBoolean("retrogen");
        if (config.hasPath("biome")) {
            ConfigValue data = config.getValue("biome");
            if (data.valueType() == ConfigValueType.OBJECT) {
                this.biomeRestriction = GenRestriction.get(config.getString("biome.restriction"));
                this.biomes.addAll(FeatureParser.parseBiomeRestrictions(config.getConfig("biome")));
            } else if (data.valueType() == ConfigValueType.STRING) {
                if (config.getString("biome").equals("all")) {
                    this.biomeRestriction = GenRestriction.NONE;
                } else {
                    CoFHWorld.log.error("Invalid biome restriction {} on feature {}", (Object)data, (Object)this.name);
                }
            } else {
                CoFHWorld.log.warn("Skipping biome restriction {} on feature {}; needs to be an object.", (Object)data, (Object)this.name);
            }
        }
        if (config.hasPath("dimension")) {
            String field = "dimension";
            ConfigValue data = config.getValue("dimension");
            switch (data.valueType()) {
                case OBJECT: {
                    this.dimensionRestriction = GenRestriction.get(config.getString("dimension.restriction"));
                    field = field + ".value";
                }
                case LIST: {
                    if (this.dimensionRestriction == GenRestriction.NONE) {
                        this.dimensionRestriction = GenRestriction.WHITELIST;
                    }
                    ConfigList restrictionList = config.getList(field);
                    for (int i = 0; i < restrictionList.size(); ++i) {
                        ConfigValue val = (ConfigValue)restrictionList.get(i);
                        if (val.valueType() != ConfigValueType.NUMBER) continue;
                        this.dimensions.add(((Number)val.unwrapped()).intValue());
                    }
                    break;
                }
                case NUMBER: {
                    this.dimensionRestriction = GenRestriction.WHITELIST;
                    this.dimensions.add(((Number)data.unwrapped()).intValue());
                    break;
                }
                case STRING: {
                    if (config.getString("dimension").equals("all")) {
                        this.dimensionRestriction = GenRestriction.NONE;
                        break;
                    }
                    CoFHWorld.log.error("Invalid dimension restriction {} on feature {}", (Object)data, (Object)this.name);
                    break;
                }
                default: {
                    CoFHWorld.log.warn("Skipping dimension restriction {} on feature {}; needs to be an object, list, number or string.", (Object)data, (Object)this.name);
                }
            }
        }
        this.chunkCount = FeatureParser.parseNumberValue(config.getValue("cluster-count"), 0L, Long.MAX_VALUE);
        if (config.hasPath("chunk-chance")) {
            this.rarity = MathHelper.func_76125_a((int)config.getInt("chunk-chance"), (int)1, (int)1000000000);
        }
        if (config.hasPath("in-village")) {
            this.withVillage = config.getBoolean("in-village");
        }
    }

    public static enum GenRestriction {
        NONE,
        BLACKLIST,
        WHITELIST;


        public static GenRestriction get(String restriction) {
            if (restriction.equalsIgnoreCase("blacklist")) {
                return BLACKLIST;
            }
            if (restriction.equalsIgnoreCase("whitelist")) {
                return WHITELIST;
            }
            return NONE;
        }
    }
}

