/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.feature.distribution;

import cofh.cofhworld.feature.Feature;
import cofh.cofhworld.feature.IDistribution;
import cofh.cofhworld.feature.IDistributionParser;
import cofh.cofhworld.util.WeightedRandomBlock;
import cofh.shade.com.typesafe.config.Config;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.logging.log4j.Logger;

public class CaveDist
implements IDistribution {
    final boolean ceiling;

    public CaveDist(boolean ceiling) {
        this.ceiling = ceiling;
    }

    @Override
    public boolean apply(Feature f, Random random, int blockX, int blockZ, World world) {
        int averageSeaLevel = world.field_73011_w.func_76557_i() + 1;
        BlockPos pos = new BlockPos(blockX, 64, blockZ);
        int count = f.getChunkCount().intValue(world, random, pos);
        boolean generated = false;
        for (int i = 0; i < count; ++i) {
            IBlockState state;
            int stopY;
            int z;
            int x = blockX + random.nextInt(16);
            if (!f.canGenerateInBiome(world, x, z = blockZ + random.nextInt(16), random)) continue;
            int seaLevel = averageSeaLevel;
            if (seaLevel < 20) {
                seaLevel = world.func_189649_b(x, z);
            }
            int y = stopY = random.nextInt(1 + seaLevel / 2);
            while (!(state = world.func_180495_p(new BlockPos(x, y, z))).func_177230_c().isAir(state, (IBlockAccess)world, new BlockPos(x, y, z)) && ++y < seaLevel) {
            }
            if (y == seaLevel) {
                y = 0;
                while (!(state = world.func_180495_p(new BlockPos(x, y, z))).func_177230_c().isAir(state, (IBlockAccess)world, new BlockPos(x, y, z)) && ++y < stopY) {
                }
                if (y == stopY) continue;
            }
            if (this.ceiling) {
                if (y < stopY) {
                    seaLevel = stopY + 1;
                }
                do {
                    state = world.func_180495_p(new BlockPos(x, ++y, z));
                } while (y < seaLevel && state.func_177230_c().isAir(state, (IBlockAccess)world, new BlockPos(x, y, z)));
                if (y == seaLevel) {
                    continue;
                }
            } else if (state.func_177230_c().isAir(state, (IBlockAccess)world, new BlockPos(x, y - 1, z))) {
                --y;
                while ((state = world.func_180495_p(new BlockPos(x, y, z))).func_177230_c().isAir(state, (IBlockAccess)world, new BlockPos(x, y, z)) && y-- > 0) {
                }
                if (y == -1) continue;
            }
            generated |= f.applyGenerator(world, random, new BlockPos(x, y, z));
        }
        return generated;
    }

    @Override
    public List<WeightedRandomBlock> defaultMaterials() {
        return Arrays.asList(new WeightedRandomBlock(Blocks.field_150348_b, -1));
    }

    @Override
    public String defaultGenerator() {
        return "cluster";
    }

    public static class Parser
    implements IDistributionParser {
        @Override
        public IDistribution parse(String name, Config config, Logger log) {
            boolean ceiling = config.hasPath("ceiling") && config.getBoolean("ceiling");
            return new CaveDist(ceiling);
        }
    }
}

