/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.feature.distribution;

import cofh.cofhworld.feature.IDistribution;
import cofh.cofhworld.feature.IDistributionParser;
import cofh.cofhworld.feature.distribution.SurfaceDist;
import cofh.cofhworld.init.FeatureParser;
import cofh.cofhworld.init.WorldProps;
import cofh.cofhworld.util.WeightedRandomBlock;
import cofh.shade.com.typesafe.config.Config;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import org.apache.logging.log4j.Logger;

public class DecorationDist
extends SurfaceDist {
    public DecorationDist(List<WeightedRandomBlock> matList, boolean useTopBlock) {
        super(matList, useTopBlock);
    }

    @Override
    public String defaultGenerator() {
        return "decoration";
    }

    public static class Parser
    implements IDistributionParser {
        @Override
        public IDistribution parse(String name, Config config, Logger log) {
            List<WeightedRandomBlock> defaultMats;
            List<WeightedRandomBlock> matList = defaultMats = Arrays.asList(new WeightedRandomBlock((Block)Blocks.field_150349_c, -1));
            if (config.hasPath("material")) {
                matList = new ArrayList<WeightedRandomBlock>();
                if (!FeatureParser.parseResList(config.root().get("material"), matList, false)) {
                    if (WorldProps.verboseLogging) {
                        log.warn("Parsing 'material' on {} failed; using default for DecorationDist: {}", (Object)name, defaultMats);
                    }
                    matList = defaultMats;
                }
            }
            boolean useTopBlock = config.hasPath("follow-terrain") && config.getBoolean("follow-terrain");
            return new DecorationDist(matList, useTopBlock);
        }
    }
}

