/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.feature.distribution;

import cofh.cofhworld.feature.Feature;
import cofh.cofhworld.feature.IDistribution;
import cofh.cofhworld.feature.IDistributionParser;
import cofh.cofhworld.init.FeatureParser;
import cofh.cofhworld.util.Utils;
import cofh.cofhworld.util.WeightedRandomBlock;
import cofh.cofhworld.util.numbers.ConstantProvider;
import cofh.cofhworld.util.numbers.INumberProvider;
import cofh.shade.com.typesafe.config.Config;
import cofh.shade.com.typesafe.config.ConfigObject;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.logging.log4j.Logger;

public class GaussianDist
implements IDistribution {
    final INumberProvider rolls;
    final INumberProvider meanY;
    final INumberProvider maxVar;

    public GaussianDist(INumberProvider smoothness, INumberProvider meanY, INumberProvider maxVar) {
        this.rolls = smoothness;
        this.meanY = meanY;
        this.maxVar = maxVar;
    }

    @Override
    public boolean apply(Feature f, Random random, int blockX, int blockZ, World world) {
        BlockPos pos = new BlockPos(blockX, 64, blockZ);
        int count = f.getChunkCount().intValue(world, random, pos);
        int meanY = this.meanY.intValue(world, random, pos);
        boolean generated = false;
        for (int i = 0; i < count; ++i) {
            int z;
            int x = blockX + random.nextInt(16);
            int y = meanY;
            int maxVar = this.maxVar.intValue(world, random, pos);
            if (maxVar > 1) {
                int rolls = this.rolls.intValue(world, random, pos);
                for (int v = 0; v < rolls; ++v) {
                    y += random.nextInt(maxVar);
                }
                y = Math.round((float)y - (float)maxVar * ((float)rolls * 0.5f));
            }
            if (!f.canGenerateInBiome(world, x, z = blockZ + random.nextInt(16), random)) continue;
            generated |= f.applyGenerator(world, random, new BlockPos(x, y, z));
        }
        return generated;
    }

    @Override
    public List<WeightedRandomBlock> defaultMaterials() {
        return Arrays.asList(new WeightedRandomBlock(Blocks.field_150348_b, -1));
    }

    @Override
    public String defaultGenerator() {
        return "cluster";
    }

    public static class Parser
    implements IDistributionParser {
        @Override
        public IDistribution parse(String name, Config genObject, Logger log) {
            if (Utils.missingAnySetting(genObject, name, log, "center-height", "spread")) {
                return null;
            }
            ConfigObject genData = genObject.root();
            INumberProvider centerHeight = FeatureParser.parseNumberValue(genData.get("center-height"));
            INumberProvider spread = FeatureParser.parseNumberValue(genData.get("spread"));
            INumberProvider rolls = genObject.hasPath("smoothness") ? FeatureParser.parseNumberValue(genData.get("smoothness")) : new ConstantProvider(2);
            return new GaussianDist(rolls, centerHeight, spread);
        }
    }
}

