/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.feature.distribution;

import cofh.cofhworld.feature.Feature;
import cofh.cofhworld.feature.IDistribution;
import cofh.cofhworld.feature.IDistributionParser;
import cofh.cofhworld.init.FeatureParser;
import cofh.cofhworld.util.Utils;
import cofh.cofhworld.util.WeightedRandomBlock;
import cofh.cofhworld.util.numbers.INumberProvider;
import cofh.shade.com.typesafe.config.Config;
import cofh.shade.com.typesafe.config.ConfigObject;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.logging.log4j.Logger;

public class LargeVeinDist
implements IDistribution {
    final INumberProvider minY;
    final INumberProvider veinHeight;
    final INumberProvider veinDiameter;
    final INumberProvider verticalDensity;
    final INumberProvider horizontalDensity;

    public LargeVeinDist(INumberProvider minY, INumberProvider height, INumberProvider diameter, INumberProvider vDensity, INumberProvider hDensity) {
        this.minY = minY;
        this.veinHeight = height;
        this.veinDiameter = diameter;
        this.verticalDensity = vDensity;
        this.horizontalDensity = hDensity;
    }

    public int getDensity(Random rand, int oreDistance, float oreDensity) {
        int i = (int)(oreDensity = oreDensity * 0.01f * (float)(oreDistance >> 1));
        if (i == 0) {
            ++i;
        }
        int rnd = oreDistance / i;
        int r = 0;
        while (i > 0) {
            r += rand.nextInt(rnd);
            --i;
        }
        return r;
    }

    @Override
    public boolean apply(Feature f, Random random, int blockX, int blockZ, World world) {
        BlockPos pos = new BlockPos(blockX, 64, blockZ);
        int count = f.getChunkCount().intValue(world, random, pos);
        int blockY = this.minY.intValue(world, random, pos);
        int veinDiameter = this.veinDiameter.intValue(world, random, pos);
        int horizontalDensity = this.horizontalDensity.intValue(world, random, pos);
        int veinHeight = this.veinHeight.intValue(world, random, pos);
        int verticalDensity = this.verticalDensity.intValue(world, random, pos);
        Random dRand = new Random(world.func_72905_C());
        long l = dRand.nextLong() / 2L * 2L + 1L;
        long l1 = dRand.nextLong() / 2L * 2L + 1L;
        dRand.setSeed((long)(blockX >> 4) * l + (long)(blockZ >> 4) * l1 ^ world.func_72905_C());
        boolean generated = false;
        int i = count;
        while (i-- > 0) {
            int x = blockX + this.getDensity(dRand, veinDiameter, horizontalDensity);
            int y = blockY + this.getDensity(dRand, veinHeight, verticalDensity);
            int z = blockZ + this.getDensity(dRand, veinDiameter, horizontalDensity);
            if (!f.canGenerateInBiome(world, x, z, random)) continue;
            generated |= f.applyGenerator(world, random, new BlockPos(x, y, z));
        }
        return generated;
    }

    @Override
    public List<WeightedRandomBlock> defaultMaterials() {
        return Arrays.asList(new WeightedRandomBlock(Blocks.field_150348_b, -1));
    }

    @Override
    public String defaultGenerator() {
        return "large-vein";
    }

    public static class Parser
    implements IDistributionParser {
        @Override
        public IDistribution parse(String name, Config genObject, Logger log) {
            if (Utils.missingAnySetting(genObject, name, log, "min-height", "vein-height", "vein-diameter", "vertical-density", "horizontal-density")) {
                return null;
            }
            ConfigObject genData = genObject.root();
            INumberProvider minY = FeatureParser.parseNumberValue(genData.get("min-height"));
            INumberProvider h = FeatureParser.parseNumberValue(genData.get("vein-height"));
            INumberProvider d = FeatureParser.parseNumberValue(genData.get("vein-diameter"));
            INumberProvider vD = FeatureParser.parseNumberValue(genData.get("vertical-density"), 0L, 100L);
            INumberProvider hD = FeatureParser.parseNumberValue(genData.get("horizontal-density"), 0L, 100L);
            return new LargeVeinDist(minY, h, d, vD, hD);
        }
    }
}

