/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.feature.distribution;

import cofh.cofhworld.feature.Feature;
import cofh.cofhworld.feature.IDistribution;
import cofh.cofhworld.feature.IDistributionParser;
import cofh.cofhworld.init.FeatureParser;
import cofh.cofhworld.init.WorldProps;
import cofh.cofhworld.util.Utils;
import cofh.cofhworld.util.WeightedRandomBlock;
import cofh.cofhworld.world.generator.ClusterGen;
import cofh.shade.com.typesafe.config.Config;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.logging.log4j.Logger;

public class SurfaceDist
implements IDistribution {
    final WeightedRandomBlock[] matList;
    final boolean useTopBlock;

    public SurfaceDist(List<WeightedRandomBlock> matList, boolean useTopBlock) {
        this.matList = matList.toArray(new WeightedRandomBlock[matList.size()]);
        this.useTopBlock = useTopBlock;
    }

    @Override
    public boolean apply(Feature f, Random random, int blockX, int blockZ, World world) {
        BlockPos pos = new BlockPos(blockX, 64, blockZ);
        int count = f.getChunkCount().intValue(world, random, pos);
        boolean generated = false;
        for (int i = 0; i < count; ++i) {
            int y;
            IBlockState state;
            int z;
            int x = blockX + random.nextInt(16);
            if (!f.canGenerateInBiome(world, x, z = blockZ + random.nextInt(16), random) || (state = world.func_180495_p(new BlockPos(x, y = this.useTopBlock ? Utils.getTopBlockY(world, x, z) : Utils.getSurfaceBlockY(world, x, z), z))).func_177230_c().isAir(state, (IBlockAccess)world, new BlockPos(x, y, z)) || !ClusterGen.canGenerateInBlock(world, x, y, z, this.matList)) continue;
            generated |= f.applyGenerator(world, random, new BlockPos(x, y + 1, z));
        }
        return generated;
    }

    @Override
    public List<WeightedRandomBlock> defaultMaterials() {
        return Arrays.asList(this.matList);
    }

    @Override
    public String defaultGenerator() {
        return "cluster";
    }

    public static class Parser
    implements IDistributionParser {
        @Override
        public IDistribution parse(String name, Config config, Logger log) {
            List<WeightedRandomBlock> defaultMats;
            List<WeightedRandomBlock> matList = defaultMats = Arrays.asList(new WeightedRandomBlock(Blocks.field_150348_b, -1), new WeightedRandomBlock(Blocks.field_150346_d, -1), new WeightedRandomBlock((Block)Blocks.field_150349_c, -1), new WeightedRandomBlock((Block)Blocks.field_150354_m, -1), new WeightedRandomBlock(Blocks.field_150351_n, -1), new WeightedRandomBlock(Blocks.field_150433_aE, -1), new WeightedRandomBlock(Blocks.field_150350_a, -1), new WeightedRandomBlock((Block)Blocks.field_150355_j, -1));
            if (config.hasPath("material")) {
                matList = new ArrayList<WeightedRandomBlock>();
                if (!FeatureParser.parseResList(config.root().get("material"), matList, false)) {
                    if (WorldProps.verboseLogging) {
                        log.warn("Parsing 'material' on {} failed; using default for SurfaceDist: {}", (Object)name, defaultMats);
                    }
                    matList = defaultMats;
                }
            }
            boolean useTopBlock = config.hasPath("follow-terrain") && config.getBoolean("follow-terrain");
            return new SurfaceDist(matList, useTopBlock);
        }
    }
}

