/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.feature.distribution;

import cofh.cofhworld.feature.Feature;
import cofh.cofhworld.feature.IDistribution;
import cofh.cofhworld.feature.IDistributionParser;
import cofh.cofhworld.init.FeatureParser;
import cofh.cofhworld.init.WorldProps;
import cofh.cofhworld.util.Utils;
import cofh.cofhworld.util.WeightedRandomBlock;
import cofh.shade.com.typesafe.config.Config;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.DungeonHooks;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import org.apache.logging.log4j.Logger;

public class UnderfluidDist
implements IDistribution {
    final boolean water;
    final List<WeightedRandomBlock> matList;
    final String[] fluidList;

    public UnderfluidDist(List<WeightedRandomBlock> matList, String[] fluidList) {
        this.matList = matList;
        this.water = fluidList.length == 0;
        this.fluidList = fluidList;
    }

    @Override
    public boolean apply(Feature f, Random random, int blockX, int blockZ, World world) {
        BlockPos pos = new BlockPos(blockX, 64, blockZ);
        int count = f.getChunkCount().intValue(world, random, pos);
        boolean generated = false;
        for (int i = 0; i < count; ++i) {
            int z;
            int x = blockX + random.nextInt(16);
            if (!f.canGenerateInBiome(world, x, z = blockZ + random.nextInt(16), random)) continue;
            int y = Utils.getSurfaceBlockY(world, x, z);
            block1: do {
                Fluid fluid;
                IBlockState state = world.func_180495_p(new BlockPos(x, y, z));
                if (this.water ? state.func_185904_a() == Material.field_151586_h || world.func_180495_p(new BlockPos(x, y + 1, z)).func_185904_a() != Material.field_151586_h : (fluid = Utils.lookupFluidForBlock(state.func_177230_c())) != null && Arrays.binarySearch(this.fluidList, fluid.getName()) >= 0 || (fluid = Utils.lookupFluidForBlock(world.func_180495_p(new BlockPos(x, y + 1, z)).func_177230_c())) == null || Arrays.binarySearch(this.fluidList, fluid.getName()) < 0) continue;
                for (WeightedRandomBlock mat : this.matList) {
                    if (!state.func_177230_c().isReplaceableOreGen(state, (IBlockAccess)world, new BlockPos(x, y, z), (Predicate)BlockMatcher.func_177642_a((Block)mat.block))) continue;
                    break block1;
                }
            } while (y-- > 1);
            if (y <= 0) continue;
            generated |= f.applyGenerator(world, random, new BlockPos(x, y, z));
        }
        return generated;
    }

    @Override
    public List<WeightedRandomBlock> defaultMaterials() {
        return Arrays.asList(new WeightedRandomBlock(Blocks.field_150346_d, -1), new WeightedRandomBlock((Block)Blocks.field_150349_c, -1));
    }

    @Override
    public String defaultGenerator() {
        return "cluster";
    }

    public static class Parser
    implements IDistributionParser {
        @Override
        public IDistribution parse(String name, Config genObject, Logger log) {
            List<WeightedRandomBlock> defaultMats;
            boolean water = true;
            HashSet<String> fluidList = new HashSet<String>();
            if (genObject.hasPath("fluid")) {
                ArrayList<DungeonHooks.DungeonMob> list = new ArrayList<DungeonHooks.DungeonMob>();
                if (FeatureParser.parseWeightedStringList(genObject.root().get("fluid"), list)) {
                    water = false;
                    for (DungeonHooks.DungeonMob str : list) {
                        Fluid fluid = FluidRegistry.getFluid((String)str.type.func_110623_a());
                        if (fluid == null) continue;
                        fluidList.add(fluid.getName());
                    }
                }
            }
            List<WeightedRandomBlock> matList = defaultMats = Arrays.asList(new WeightedRandomBlock(Blocks.field_150346_d, -1), new WeightedRandomBlock((Block)Blocks.field_150349_c, -1));
            if (genObject.hasPath("material")) {
                matList = new ArrayList<WeightedRandomBlock>();
                if (!FeatureParser.parseResList(genObject.root().get("material"), matList, false)) {
                    if (WorldProps.verboseLogging) {
                        log.warn("Parsing 'material' on {} failed; using default for UnderfluidDist: {}", (Object)name, defaultMats);
                    }
                    matList = defaultMats;
                }
            }
            return new UnderfluidDist(matList, fluidList.toArray(new String[0]));
        }
    }
}

