/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.util;

import cofh.shade.com.typesafe.config.Config;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.util.Loader;

public class Utils {
    public static final int[][] SIDE_COORD_MOD = new int[][]{{0, -1, 0}, {0, 1, 0}, {0, 0, -1}, {0, 0, 1}, {-1, 0, 0}, {1, 0, 0}};

    public static int getHighestY(World world, int x, int z) {
        return world.func_175726_f(new BlockPos(x, 0, z)).func_76625_h() + 16;
    }

    public static int getSurfaceBlockY(World world, int x, int z) {
        BlockPos pos;
        IBlockState state;
        Block block;
        int y = world.func_175726_f(new BlockPos(x, 0, z)).func_76625_h() + 16;
        while (--y >= 0 && ((block = (state = world.func_180495_p(pos = new BlockPos(x, y, z))).func_177230_c()).isAir(state, (IBlockAccess)world, pos) || block.func_176200_f((IBlockAccess)world, pos) || block.isLeaves(state, (IBlockAccess)world, pos) || block.isFoliage((IBlockAccess)world, pos) || block.canBeReplacedByLeaves(state, (IBlockAccess)world, pos))) {
        }
        return y;
    }

    public static int getTopBlockY(World world, int x, int z) {
        BlockPos pos;
        IBlockState state;
        Block block;
        int y = world.func_175726_f(new BlockPos(x, 0, z)).func_76625_h() + 16;
        while (--y >= 0 && (block = (state = world.func_180495_p(pos = new BlockPos(x, y, z))).func_177230_c()).isAir(state, (IBlockAccess)world, pos)) {
        }
        return y;
    }

    public static Fluid lookupFluidForBlock(Block block) {
        if (block == Blocks.field_150358_i) {
            return FluidRegistry.WATER;
        }
        if (block == Blocks.field_150356_k) {
            return FluidRegistry.LAVA;
        }
        return FluidRegistry.lookupFluidForBlock((Block)block);
    }

    public static ItemStack cloneStack(ItemStack stack, int stackSize) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack retStack = stack.func_77946_l();
        retStack.func_190920_e(stackSize);
        return retStack;
    }

    public static boolean oreNameExists(String oreName) {
        return OreDictionary.doesOreNameExist((String)oreName);
    }

    public static void copyFileUsingStream(String source, String dest) throws IOException {
        Utils.copyFileUsingStream(source, new File(dest));
    }

    public static void copyFileUsingStream(String source, File dest) throws IOException {
        int length;
        InputStream is = Loader.getResource((String)source, null).openStream();
        FileOutputStream os = new FileOutputStream(dest);
        byte[] buffer = new byte[1024];
        while ((length = is.read(buffer)) > 0) {
            ((OutputStream)os).write(buffer, 0, length);
        }
    }

    public static void copyFileUsingChannel(File source, File dest) throws IOException {
        FileInputStream sourceStream = new FileInputStream(source);
        FileChannel sourceChannel = sourceStream.getChannel();
        FileOutputStream outputStream = new FileOutputStream(dest);
        outputStream.getChannel().transferFrom(sourceChannel, 0L, sourceChannel.size());
    }

    public static boolean missingAnySetting(Config genObject, String featureName, Logger log, String ... settings) {
        for (String settingName : settings) {
            if (genObject.hasPath(settingName)) continue;
            log.error("Missing required setting {} on feature {}", (Object)settingName, (Object)featureName);
            return true;
        }
        return false;
    }
}

