/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.world.generator;

import cofh.cofhworld.feature.Feature;
import cofh.cofhworld.feature.IGenerator;
import cofh.cofhworld.feature.IGeneratorParser;
import cofh.cofhworld.util.WeightedRandomBlock;
import cofh.cofhworld.util.numbers.ConstantProvider;
import cofh.cofhworld.util.numbers.INumberProvider;
import cofh.shade.com.typesafe.config.Config;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.logging.log4j.Logger;

public class ClusterGen
implements IGenerator {
    private final List<WeightedRandomBlock> cluster;
    private final INumberProvider genClusterSize;
    private final WeightedRandomBlock[] genBlock;

    public static List<WeightedRandomBlock> fabricateList(WeightedRandomBlock resource) {
        ArrayList<WeightedRandomBlock> list = new ArrayList<WeightedRandomBlock>();
        list.add(resource);
        return list;
    }

    public static List<WeightedRandomBlock> fabricateList(Block resource) {
        ArrayList<WeightedRandomBlock> list = new ArrayList<WeightedRandomBlock>();
        list.add(new WeightedRandomBlock(new ItemStack(resource, 1, 0)));
        return list;
    }

    public ClusterGen(List<WeightedRandomBlock> resource, int clusterSize, List<WeightedRandomBlock> block) {
        this.cluster = resource;
        this.genClusterSize = new ConstantProvider(clusterSize);
        this.genBlock = block.toArray(new WeightedRandomBlock[block.size()]);
    }

    @Override
    public boolean generate(Feature feature, World world, Random rand, BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        int blocks = MathHelper.func_76125_a((int)this.genClusterSize.intValue(world, rand, pos), (int)1, (int)42);
        if (blocks < 4) {
            return this.generateTiny(world, rand, blocks, x, y, z);
        }
        float f = rand.nextFloat() * (float)Math.PI;
        float xMin = (float)x + MathHelper.func_76126_a((float)f) * (float)blocks / 8.0f;
        float xMax = (float)x - MathHelper.func_76126_a((float)f) * (float)blocks / 8.0f;
        float zMin = (float)z + MathHelper.func_76134_b((float)f) * (float)blocks / 8.0f;
        float zMax = (float)z - MathHelper.func_76134_b((float)f) * (float)blocks / 8.0f;
        float yMin = y + rand.nextInt(3) - 2;
        float yMax = y + rand.nextInt(3) - 2;
        xMax -= xMin;
        yMax -= yMin;
        zMax -= zMin;
        boolean r = false;
        for (int i = 0; i <= blocks; ++i) {
            float xCenter = xMin + xMax * (float)i / (float)blocks;
            float yCenter = yMin + yMax * (float)i / (float)blocks;
            float zCenter = zMin + zMax * (float)i / (float)blocks;
            float size = (float)rand.nextDouble() * (float)blocks / 16.0f;
            float hMod = ((MathHelper.func_76126_a((float)((float)i * (float)Math.PI / (float)blocks)) + 1.0f) * size + 1.0f) * 0.5f;
            float vMod = ((MathHelper.func_76126_a((float)((float)i * (float)Math.PI / (float)blocks)) + 1.0f) * size + 1.0f) * 0.5f;
            int xStart = MathHelper.func_76141_d((float)(xCenter - hMod));
            int yStart = MathHelper.func_76141_d((float)(yCenter - vMod));
            int zStart = MathHelper.func_76141_d((float)(zCenter - hMod));
            int xStop = MathHelper.func_76141_d((float)(xCenter + hMod));
            int yStop = MathHelper.func_76141_d((float)(yCenter + vMod));
            int zStop = MathHelper.func_76141_d((float)(zCenter + hMod));
            for (int blockX = xStart; blockX <= xStop; ++blockX) {
                float xDistSq = ((float)blockX + 0.5f - xCenter) / hMod;
                if ((xDistSq *= xDistSq) >= 1.0f) continue;
                for (int blockY = yStart; blockY <= yStop; ++blockY) {
                    float xyDistSq;
                    float yDistSq = ((float)blockY + 0.5f - yCenter) / vMod;
                    if ((xyDistSq = (yDistSq *= yDistSq) + xDistSq) >= 1.0f) continue;
                    for (int blockZ = zStart; blockZ <= zStop; ++blockZ) {
                        float zDistSq = ((float)blockZ + 0.5f - zCenter) / hMod;
                        if ((zDistSq *= zDistSq) + xyDistSq >= 1.0f) continue;
                        r |= ClusterGen.generateBlock(world, blockX, blockY, blockZ, this.genBlock, this.cluster);
                    }
                }
            }
        }
        return r;
    }

    public boolean generateTiny(World world, Random random, int clusterSize, int x, int y, int z) {
        boolean r = ClusterGen.generateBlock(world, x, y, z, this.genBlock, this.cluster);
        for (int i = 1; i < clusterSize; ++i) {
            int d0 = x + random.nextInt(2);
            int d1 = y + random.nextInt(2);
            int d2 = z + random.nextInt(2);
            r |= ClusterGen.generateBlock(world, d0, d1, d2, this.genBlock, this.cluster);
        }
        return r;
    }

    @Deprecated
    public static boolean canGenerateInBlock(World world, int x, int y, int z, WeightedRandomBlock[] mat) {
        return ClusterGen.canGenerateInBlock(world, new BlockPos(x, y, z), mat);
    }

    public static boolean canGenerateInBlock(World world, BlockPos pos, WeightedRandomBlock[] mat) {
        if (mat == null || mat.length == 0) {
            return true;
        }
        IBlockState state = world.func_180495_p(pos);
        for (WeightedRandomBlock genBlock : mat) {
            if (-1 != genBlock.metadata && genBlock.metadata != state.func_177230_c().func_176201_c(state) || !state.func_177230_c().isReplaceableOreGen(state, (IBlockAccess)world, pos, (Predicate)BlockMatcher.func_177642_a((Block)genBlock.block)) && !state.func_177230_c().func_149667_c(genBlock.block)) continue;
            return true;
        }
        return false;
    }

    public static boolean generateBlock(World world, int x, int y, int z, WeightedRandomBlock[] mat, List<WeightedRandomBlock> o) {
        if (mat == null || mat.length == 0) {
            return ClusterGen.generateBlock(world, x, y, z, o);
        }
        if (ClusterGen.canGenerateInBlock(world, x, y, z, mat)) {
            return ClusterGen.generateBlock(world, x, y, z, o);
        }
        return false;
    }

    public static boolean generateBlock(World world, int x, int y, int z, List<WeightedRandomBlock> o) {
        WeightedRandomBlock ore = ClusterGen.selectBlock(world, o);
        return ore != null && world.func_180501_a(new BlockPos(x, y, z), ore.getState(), 2);
    }

    public static WeightedRandomBlock selectBlock(World world, List<WeightedRandomBlock> o) {
        int size = o.size();
        if (size == 0) {
            return null;
        }
        if (size > 1) {
            return (WeightedRandomBlock)WeightedRandom.func_76271_a((Random)world.field_73012_v, o);
        }
        return o.get(0);
    }

    public static class Parser
    implements IGeneratorParser {
        @Override
        public IGenerator parseGenerator(String name, Config genObject, Logger log, List<WeightedRandomBlock> resList, List<WeightedRandomBlock> matList) {
            int clusterSize = genObject.getInt("cluster-size");
            if (clusterSize <= 0) {
                log.error("Invalid 'cluster-size' for ClusterGen on feature {}", (Object)name);
                return null;
            }
            return new ClusterGen(resList, clusterSize, matList);
        }
    }
}

