/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.world.generator;

import cofh.cofhworld.feature.Feature;
import cofh.cofhworld.feature.IGenerator;
import cofh.cofhworld.feature.IGeneratorParser;
import cofh.cofhworld.init.FeatureParser;
import cofh.cofhworld.init.WorldProps;
import cofh.cofhworld.util.WeightedRandomBlock;
import cofh.cofhworld.util.numbers.ConstantProvider;
import cofh.cofhworld.util.numbers.INumberProvider;
import cofh.cofhworld.util.numbers.SkellamRandomProvider;
import cofh.cofhworld.world.generator.ClusterGen;
import cofh.shade.com.typesafe.config.Config;
import cofh.shade.com.typesafe.config.ConfigObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.logging.log4j.Logger;

public class DecorationGen
implements IGenerator {
    private final List<WeightedRandomBlock> cluster;
    private final WeightedRandomBlock[] genBlock;
    private final WeightedRandomBlock[] onBlock;
    private final INumberProvider clusterSize;
    private boolean seeSky = true;
    private boolean checkStay = false;
    private INumberProvider stackHeight = new ConstantProvider(1);
    private INumberProvider xVar = new SkellamRandomProvider(8);
    private INumberProvider yVar = new SkellamRandomProvider(4);
    private INumberProvider zVar = new SkellamRandomProvider(8);

    public DecorationGen(List<WeightedRandomBlock> blocks, INumberProvider clusterSize, List<WeightedRandomBlock> material, List<WeightedRandomBlock> on) {
        this.cluster = blocks;
        this.clusterSize = clusterSize;
        this.genBlock = material == null ? null : material.toArray(new WeightedRandomBlock[material.size()]);
        this.onBlock = on == null ? null : on.toArray(new WeightedRandomBlock[on.size()]);
    }

    @Override
    public boolean generate(Feature feature, World world, Random rand, BlockPos pos) {
        int xStart = pos.func_177958_n();
        int yStart = pos.func_177956_o();
        int zStart = pos.func_177952_p();
        int clusterSize = this.clusterSize.intValue(world, rand, pos);
        boolean r = false;
        int l = clusterSize;
        block0: while (l-- > 0) {
            int z;
            int y;
            int x = xStart + this.xVar.intValue(world, rand, pos);
            if (!world.func_175667_e(new BlockPos(x, y = yStart + this.yVar.intValue(world, rand, pos), z = zStart + this.zVar.intValue(world, rand, pos)))) {
                ++l;
                continue;
            }
            if (this.seeSky && !world.func_175678_i(new BlockPos(x, y, z)) || !ClusterGen.canGenerateInBlock(world, x, y - 1, z, this.onBlock) || !ClusterGen.canGenerateInBlock(world, x, y, z, this.genBlock)) continue;
            WeightedRandomBlock block = ClusterGen.selectBlock(world, this.cluster);
            int stack = this.stackHeight.intValue(world, rand, pos);
            while (!this.checkStay) {
                r |= world.func_180501_a(new BlockPos(x, y, z), block.getState(), 2);
                if (ClusterGen.canGenerateInBlock(world, x, ++y, z, this.genBlock) && --stack > 0) continue;
                continue block0;
            }
        }
        return r;
    }

    public static class Parser
    implements IGeneratorParser {
        @Override
        public IGenerator parseGenerator(String name, Config genObject, Logger log, List<WeightedRandomBlock> resList, List<WeightedRandomBlock> matList) {
            int clusterSize = genObject.getInt("cluster-size");
            if (clusterSize <= 0) {
                log.error("Invalid 'cluster-size' for DecorationGen on feature {}", (Object)name);
                return null;
            }
            ArrayList<WeightedRandomBlock> list = new ArrayList<WeightedRandomBlock>();
            ConfigObject genData = genObject.root();
            if (!genObject.hasPath("surface")) {
                if (WorldProps.verboseLogging) {
                    log.warn("Using default 'surface' setting for DecorationGen on feature {}", (Object)name);
                }
                list.add(new WeightedRandomBlock((Block)Blocks.field_150349_c));
            } else if (!FeatureParser.parseResList(genData.get("surface"), list, false)) {
                log.warn("Parsing 'surface' setting for DecorationGen on feature {} failed; using default value", (Object)name);
                list.clear();
                list.add(new WeightedRandomBlock((Block)Blocks.field_150349_c));
            }
            DecorationGen r = new DecorationGen(resList, new ConstantProvider(clusterSize), matList, list);
            if (genObject.hasPath("see-sky")) {
                r.seeSky = genObject.getBoolean("see-sky");
            }
            if (genObject.hasPath("check-stay")) {
                r.checkStay = genObject.getBoolean("check-stay");
            }
            if (genObject.hasPath("stack-height")) {
                r.stackHeight = FeatureParser.parseNumberValue(genData.get("stack-height"));
            }
            if (genObject.hasPath("x-variance")) {
                r.xVar = FeatureParser.parseNumberValue(genData.get("x-variance"), 1L, 15L);
            }
            if (genObject.hasPath("y-variance")) {
                r.yVar = FeatureParser.parseNumberValue(genData.get("y-variance"), 0L, 15L);
            }
            if (genObject.hasPath("z-variance")) {
                r.zVar = FeatureParser.parseNumberValue(genData.get("z-variance"), 1L, 15L);
            }
            return r;
        }
    }
}

