/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.world.generator;

import cofh.cofhworld.feature.Feature;
import cofh.cofhworld.feature.IGenerator;
import cofh.cofhworld.feature.IGeneratorParser;
import cofh.cofhworld.util.WeightedRandomBlock;
import cofh.cofhworld.util.numbers.ConstantProvider;
import cofh.cofhworld.util.numbers.INumberProvider;
import cofh.cofhworld.world.generator.ClusterGen;
import cofh.shade.com.typesafe.config.Config;
import java.util.List;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.logging.log4j.Logger;

public class LargeVeinGen
implements IGenerator {
    private final List<WeightedRandomBlock> cluster;
    private final WeightedRandomBlock[] genBlock;
    private final INumberProvider genVeinSize;
    private final boolean sparse;

    public LargeVeinGen(List<WeightedRandomBlock> resource, int clusterSize, List<WeightedRandomBlock> block, boolean sparze) {
        this.cluster = resource;
        this.genVeinSize = new ConstantProvider(clusterSize);
        this.genBlock = block.toArray(new WeightedRandomBlock[block.size()]);
        this.sparse = sparze;
    }

    @Override
    public boolean generate(Feature feature, World world, Random rand, BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        int veinSize = this.genVeinSize.intValue(world, rand, pos);
        int branchSize = 1 + veinSize / 30;
        int subBranchSize = 1 + branchSize / 5;
        boolean r = false;
        for (int blocksVein = 0; blocksVein <= veinSize; ++blocksVein) {
            int posX = x;
            int posY = y;
            int posZ = z;
            int directionChange = rand.nextInt(6);
            int directionX1 = -rand.nextInt(2);
            int directionY1 = -rand.nextInt(2);
            int directionZ1 = -rand.nextInt(2);
            directionX1 += ~directionX1 >>> 31;
            directionY1 += ~directionY1 >>> 31;
            directionZ1 += ~directionZ1 >>> 31;
            for (int blocksBranch = 0; blocksBranch <= branchSize; ++blocksBranch) {
                if (directionChange != 1) {
                    posX += rand.nextInt(2) * directionX1;
                }
                if (directionChange != 2) {
                    posY += rand.nextInt(2) * directionY1;
                }
                if (directionChange != 3) {
                    posZ += rand.nextInt(2) * directionZ1;
                }
                if (rand.nextInt(3) == 0) {
                    int posX2 = posX;
                    int posY2 = posY;
                    int posZ2 = posZ;
                    int directionChange2 = rand.nextInt(6);
                    int directionX2 = -rand.nextInt(2);
                    int directionY2 = -rand.nextInt(2);
                    int directionZ2 = -rand.nextInt(2);
                    directionX2 += ~directionX2 >>> 31;
                    directionY2 += ~directionY2 >>> 31;
                    directionZ2 += ~directionZ2 >>> 31;
                    for (int blocksSubBranch = 0; blocksSubBranch <= subBranchSize; ++blocksSubBranch) {
                        if (directionChange2 != 0) {
                            posX2 += rand.nextInt(2) * directionX2;
                        }
                        if (directionChange2 != 1) {
                            posY2 += rand.nextInt(2) * directionY2;
                        }
                        if (directionChange2 != 2) {
                            posZ2 += rand.nextInt(2) * directionZ2;
                        }
                        r |= ClusterGen.generateBlock(world, posX2, posY2, posZ2, this.genBlock, this.cluster);
                        if (!this.sparse) continue;
                        ++blocksVein;
                        ++blocksBranch;
                    }
                }
                r |= ClusterGen.generateBlock(world, posX, posY, posZ, this.genBlock, this.cluster);
            }
            x += rand.nextInt(3) - 1;
            y += rand.nextInt(3) - 1;
            z += rand.nextInt(3) - 1;
        }
        return r;
    }

    public static class Parser
    implements IGeneratorParser {
        @Override
        public IGenerator parseGenerator(String name, Config genObject, Logger log, List<WeightedRandomBlock> resList, List<WeightedRandomBlock> matList) {
            int clusterSize = genObject.getInt("cluster-size");
            if (clusterSize <= 0) {
                log.error("Invalid 'cluster-size' setting for LargeVeinGen on feature {}", (Object)name);
                return null;
            }
            boolean sparse = genObject.hasPath("sparse") ? genObject.getBoolean("sparse") : true;
            return new LargeVeinGen(resList, clusterSize, matList, sparse);
        }
    }
}

