/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.world.generator;

import cofh.cofhworld.feature.Feature;
import cofh.cofhworld.feature.IGenerator;
import cofh.cofhworld.feature.IGeneratorParser;
import cofh.cofhworld.init.FeatureParser;
import cofh.cofhworld.util.WeightedRandomBlock;
import cofh.cofhworld.util.numbers.ConstantProvider;
import cofh.cofhworld.util.numbers.INumberProvider;
import cofh.cofhworld.util.numbers.UniformRandomProvider;
import cofh.cofhworld.world.generator.ClusterGen;
import cofh.shade.com.typesafe.config.Config;
import java.util.List;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import org.apache.logging.log4j.Logger;

public class PlateGen
implements IGenerator {
    private final List<WeightedRandomBlock> cluster;
    private final WeightedRandomBlock[] genBlock;
    private final INumberProvider radius;
    private INumberProvider height = new ConstantProvider(1);
    private boolean slim = false;

    public PlateGen(List<WeightedRandomBlock> resource, int clusterSize, List<WeightedRandomBlock> block) {
        this.cluster = resource;
        this.radius = new UniformRandomProvider(clusterSize, clusterSize + 2);
        this.genBlock = block.toArray(new WeightedRandomBlock[block.size()]);
    }

    @Override
    public boolean generate(Feature feature, World world, Random rand, BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        ++y;
        int size = this.radius.intValue(world, rand, pos);
        int dist = size * size;
        int height = this.height.intValue(world, rand, pos);
        boolean r = false;
        for (int posX = x - size; posX <= x + size; ++posX) {
            int xDist = posX - x;
            xDist *= xDist;
            for (int posZ = z - size; posZ <= z + size; ++posZ) {
                int zSize = posZ - z;
                if (zSize * zSize + xDist > dist) continue;
                int posY = y - height;
                while (this.slim ? posY < y + height : posY <= y + height) {
                    r |= ClusterGen.generateBlock(world, posX, posY, posZ, this.genBlock, this.cluster);
                    ++posY;
                }
            }
        }
        return r;
    }

    public static class Parser
    implements IGeneratorParser {
        @Override
        public IGenerator parseGenerator(String name, Config genObject, Logger log, List<WeightedRandomBlock> resList, List<WeightedRandomBlock> matList) {
            int clusterSize = genObject.getInt("radius");
            if (clusterSize <= 0) {
                log.warn("Invalid 'radius' setting for PlateGen on feature {}", (Object)name);
                return null;
            }
            PlateGen r = new PlateGen(resList, MathHelper.func_76125_a((int)clusterSize, (int)0, (int)32), matList);
            if (genObject.hasPath("height")) {
                r.height = FeatureParser.parseNumberValue(genObject.root().get("height"), 0L, 64L);
            }
            if (genObject.hasPath("slim")) {
                r.slim = genObject.getBoolean("slim");
            }
            return r;
        }
    }
}

