/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.world.generator;

import cofh.cofhworld.feature.Feature;
import cofh.cofhworld.feature.IGenerator;
import cofh.cofhworld.feature.IGeneratorParser;
import cofh.cofhworld.util.WeightedRandomBlock;
import cofh.cofhworld.world.generator.ClusterGen;
import cofh.shade.com.typesafe.config.Config;
import java.util.List;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import org.apache.logging.log4j.Logger;

public class SpikeGen
implements IGenerator {
    private final List<WeightedRandomBlock> cluster;
    private final WeightedRandomBlock[] genBlock;
    public boolean largeSpikes = true;
    public int largeSpikeChance = 60;
    public int minHeight = 7;
    public int heightVariance = 4;
    public int sizeVariance = 2;
    public int positionVariance = 3;
    public int minLargeSpikeHeightGain = 10;
    public int largeSpikeHeightVariance = 30;
    public int largeSpikeFillerSize = 1;

    public SpikeGen(List<WeightedRandomBlock> resource, List<WeightedRandomBlock> block) {
        this.cluster = resource;
        this.genBlock = block.toArray(new WeightedRandomBlock[block.size()]);
    }

    @Override
    public boolean generate(Feature feature, World world, Random rand, BlockPos pos) {
        int height;
        int yStart;
        int xStart = pos.func_177958_n();
        int zStart = pos.func_177952_p();
        for (yStart = pos.func_177956_o(); world.func_175623_d(new BlockPos(xStart, yStart, zStart)) && yStart > 2; --yStart) {
        }
        if (!ClusterGen.canGenerateInBlock(world, xStart, yStart, zStart, this.genBlock)) {
            return false;
        }
        int originalHeight = height = rand.nextInt(this.heightVariance) + this.minHeight;
        int size = height / (this.minHeight / 2) + rand.nextInt(this.sizeVariance);
        if (size > 1 && this.positionVariance > 0) {
            yStart += rand.nextInt(this.positionVariance + 1) - 1;
        }
        if (this.largeSpikes && size > 1 && (this.largeSpikeChance <= 0 || rand.nextInt(this.largeSpikeChance) == 0)) {
            height += this.minLargeSpikeHeightGain + rand.nextInt(this.largeSpikeHeightVariance);
        }
        int offsetHeight = height - originalHeight;
        for (int y = 0; y < height; ++y) {
            float layerSize = y >= offsetHeight ? (1.0f - (float)(y - offsetHeight) / (float)originalHeight) * (float)size : (float)this.largeSpikeFillerSize;
            int width = MathHelper.func_76123_f((float)layerSize);
            for (int x = -width; x <= width; ++x) {
                float xDist = (float)MathHelper.func_76130_a((int)x) - 0.25f;
                for (int z = -width; z <= width; ++z) {
                    float zDist = (float)MathHelper.func_76130_a((int)z) - 0.25f;
                    if ((x != 0 || z != 0) && !(xDist * xDist + zDist * zDist <= layerSize * layerSize) || (x == -width || x == width || z == -width || z == width) && !(rand.nextFloat() <= 0.75f)) continue;
                    ClusterGen.generateBlock(world, xStart + x, yStart + y, zStart + z, this.genBlock, this.cluster);
                    if (y == 0 || width <= 1) continue;
                    ClusterGen.generateBlock(world, xStart + x, yStart - y + offsetHeight, zStart + z, this.genBlock, this.cluster);
                }
            }
        }
        return true;
    }

    public static class Parser
    implements IGeneratorParser {
        @Override
        public IGenerator parseGenerator(String generatorName, Config genObject, Logger log, List<WeightedRandomBlock> resList, List<WeightedRandomBlock> matList) {
            SpikeGen r = new SpikeGen(resList, matList);
            if (genObject.hasPath("min-height")) {
                r.minHeight = genObject.getInt("min-height");
            }
            if (genObject.hasPath("height-variance")) {
                r.heightVariance = genObject.getInt("height-variance");
            }
            if (genObject.hasPath("size-variance")) {
                r.sizeVariance = genObject.getInt("size-variance");
            }
            if (genObject.hasPath("position-variance")) {
                r.positionVariance = genObject.getInt("position-variance");
            }
            if (genObject.hasPath("large-spikes")) {
                r.largeSpikes = genObject.getBoolean("large-spikes");
            }
            if (genObject.hasPath("large-spike-chance")) {
                r.largeSpikeChance = genObject.getInt("large-spike-chance");
            }
            if (genObject.hasPath("min-large-spike-height-gain")) {
                r.minLargeSpikeHeightGain = genObject.getInt("min-large-spike-height-gain");
            }
            if (genObject.hasPath("large-spike-height-variance")) {
                r.largeSpikeHeightVariance = genObject.getInt("large-spike-height-variance");
            }
            if (genObject.hasPath("large-spike-filler-size")) {
                r.largeSpikeFillerSize = genObject.getInt("large-spike-filler-size");
            }
            return r;
        }
    }
}

