/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.world.generator;

import cofh.cofhworld.feature.Feature;
import cofh.cofhworld.feature.IGenerator;
import cofh.cofhworld.util.WeightedRandomBlock;
import cofh.cofhworld.world.generator.ClusterGen;
import cofh.cofhworld.world.generator.StalagmiteGen;
import cofh.shade.com.typesafe.config.Config;
import java.util.List;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.logging.log4j.Logger;

public class StalactiteGen
extends StalagmiteGen {
    public StalactiteGen(List<WeightedRandomBlock> resource, List<WeightedRandomBlock> block) {
        super(resource, block);
    }

    @Override
    public boolean generate(Feature feature, World world, Random rand, BlockPos pos) {
        int yStart;
        int xStart = pos.func_177958_n();
        int zStart = pos.func_177952_p();
        int end = world.func_72940_L();
        for (yStart = pos.func_177956_o(); world.func_175623_d(new BlockPos(xStart, yStart, zStart)) && yStart < end; ++yStart) {
        }
        if (!ClusterGen.canGenerateInBlock(world, xStart, yStart--, zStart, this.baseBlock)) {
            return false;
        }
        int maxHeight = rand.nextInt(this.heightVariance) + this.minHeight;
        int size = this.genSize > 0 ? this.genSize : maxHeight / this.heightMod + rand.nextInt(this.sizeVariance);
        boolean r = false;
        for (int x = -size; x <= size; ++x) {
            for (int z = -size; z <= size; ++z) {
                if (!ClusterGen.canGenerateInBlock(world, xStart + x, yStart + 1, zStart + z, this.baseBlock)) continue;
                int height = this.getHeight(x, z, size, rand, maxHeight);
                for (int y = 0; y < height; ++y) {
                    r |= ClusterGen.generateBlock(world, xStart + x, yStart - y, zStart + z, this.genBlock, this.cluster);
                }
            }
        }
        return r;
    }

    public static class Parser
    extends StalagmiteGen.Parser {
        @Override
        public IGenerator parseGenerator(String generatorName, Config genObject, Logger log, List<WeightedRandomBlock> resList, List<WeightedRandomBlock> matList) {
            return this.commonParse(new StalactiteGen(resList, matList), generatorName, genObject, log);
        }
    }
}

