/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.world.generator;

import cofh.cofhworld.feature.Feature;
import cofh.cofhworld.feature.IGenerator;
import cofh.cofhworld.feature.IGeneratorParser;
import cofh.cofhworld.init.FeatureParser;
import cofh.cofhworld.init.WorldProps;
import cofh.cofhworld.util.WeightedRandomBlock;
import cofh.cofhworld.world.generator.ClusterGen;
import cofh.shade.com.typesafe.config.Config;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.logging.log4j.Logger;

public class StalagmiteGen
implements IGenerator {
    protected final List<WeightedRandomBlock> cluster;
    protected final WeightedRandomBlock[] baseBlock;
    protected WeightedRandomBlock[] genBlock;
    public int minHeight = 7;
    public int heightVariance = 4;
    public int sizeVariance = 2;
    public int heightMod = 5;
    public int genSize = 0;
    public boolean smooth = false;
    public boolean fat = true;
    public boolean altSinc = false;

    public StalagmiteGen(List<WeightedRandomBlock> resource, List<WeightedRandomBlock> block) {
        this.cluster = resource;
        this.baseBlock = block.toArray(new WeightedRandomBlock[block.size()]);
    }

    protected int getHeight(int x, int z, int size, Random rand, int height) {
        int dist;
        int absz;
        if (this.smooth) {
            if ((x * x + z * z) * 4 >= size * size * 5) {
                return 0;
            }
            double lim = (this.altSinc ? 600.0f : (this.fat ? 1.0f : 0.5f) * 400.0f) / (float)size;
            double pi = Math.PI;
            double r = (double)x * lim / Math.PI;
            double d = r * r;
            r = (double)z * lim / Math.PI;
            r = Math.sqrt(d + r * r) * Math.PI / 180.0;
            if (this.altSinc && r < 1.0) {
                r = Math.sqrt((double)(size * 2) * lim / Math.PI) * Math.PI / 180.0;
            }
            if (r == 0.0) {
                return height;
            }
            if (!this.altSinc) {
                return (int)Math.round((double)height * (this.fat ? Math.sin(r) / r : Math.sin(r *= Math.PI) / r));
            }
            double sinc = Math.sin(r) / r;
            return (int)Math.round((double)height * (sinc * 2.0 + Math.sin(r *= Math.PI * 4) / r) / 2.0 + rand.nextGaussian() * 0.75);
        }
        int absx = x < 0 ? -x : x;
        int n = absz = z < 0 ? -z : z;
        int n2 = this.fat ? (absx < absz ? absz + absx / 2 : absx + absz / 2) : (dist = absx + absz);
        if (dist == 0) {
            return height;
        }
        int v = 1 + height / dist;
        return v > 1 ? rand.nextInt(v) : 0;
    }

    @Override
    public boolean generate(Feature feature, World world, Random rand, BlockPos pos) {
        int size;
        int yStart;
        int xStart = pos.func_177958_n();
        int zStart = pos.func_177952_p();
        for (yStart = pos.func_177956_o(); world.func_175623_d(new BlockPos(xStart, yStart, zStart)) && yStart > 0; --yStart) {
        }
        if (!ClusterGen.canGenerateInBlock(world, xStart, yStart++, zStart, this.baseBlock)) {
            return false;
        }
        int maxHeight = (this.heightVariance > 0 ? rand.nextInt(this.heightVariance) : 0) + this.minHeight;
        int n = size = this.genSize > 0 ? this.genSize : maxHeight / this.heightMod;
        if (this.sizeVariance > 0) {
            size += rand.nextInt(this.sizeVariance);
        }
        boolean r = false;
        for (int x = -size; x <= size; ++x) {
            for (int z = -size; z <= size; ++z) {
                if (!ClusterGen.canGenerateInBlock(world, xStart + x, yStart - 1, zStart + z, this.baseBlock)) continue;
                int height = this.getHeight(x, z, size, rand, maxHeight);
                for (int y = 0; y < height; ++y) {
                    r |= ClusterGen.generateBlock(world, xStart + x, yStart + y, zStart + z, this.genBlock, this.cluster);
                }
            }
        }
        return r;
    }

    public static class Parser
    implements IGeneratorParser {
        @Override
        public IGenerator parseGenerator(String generatorName, Config genObject, Logger log, List<WeightedRandomBlock> resList, List<WeightedRandomBlock> matList) {
            return this.commonParse(new StalagmiteGen(resList, matList), generatorName, genObject, log);
        }

        protected IGenerator commonParse(StalagmiteGen r, String generatorName, Config genObject, Logger log) {
            ArrayList<WeightedRandomBlock> list = new ArrayList<WeightedRandomBlock>();
            if (!genObject.hasPath("gen-body")) {
                if (WorldProps.verboseLogging) {
                    log.warn("Using default 'gen-body' setting for StalagmiteGen on feature {}", (Object)generatorName);
                }
                list.add(new WeightedRandomBlock(Blocks.field_150350_a));
            } else if (!FeatureParser.parseResList(genObject.root().get("gen-body"), list, false)) {
                log.warn("Parsing 'gen-body' setting for StalagmiteGen on feature {} failed; using default", (Object)generatorName);
                list.clear();
                list.add(new WeightedRandomBlock(Blocks.field_150350_a));
            }
            r.genBlock = list.toArray(new WeightedRandomBlock[list.size()]);
            if (genObject.hasPath("min-height")) {
                r.minHeight = genObject.getInt("min-height");
            }
            if (genObject.hasPath("height-variance")) {
                r.heightVariance = genObject.getInt("height-variance");
            }
            if (genObject.hasPath("size-variance")) {
                r.sizeVariance = genObject.getInt("size-variance");
            }
            if (genObject.hasPath("height-mod")) {
                r.heightMod = genObject.getInt("height-mod");
            }
            if (genObject.hasPath("gen-size")) {
                r.genSize = genObject.getInt("gen-size");
            }
            if (genObject.hasPath("smooth")) {
                r.smooth = genObject.getBoolean("smooth");
            }
            if (genObject.hasPath("fat")) {
                r.fat = genObject.getBoolean("fat");
            }
            if (genObject.hasPath("alt-sinc")) {
                r.altSinc = genObject.getBoolean("alt-sinc");
            }
            return r;
        }
    }
}

