/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.base.f;

import doggytalents.api.registry.DogBedRegistry;
import doggytalents.base.other.BlockDogBathBridge;
import doggytalents.base.other.BlockDogBedBridge;
import doggytalents.base.other.BlockFoodBowlBridge;
import doggytalents.tileentity.TileEntityDogBed;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockWrapper {

    public static class BlockFoodBowlWrapper
    extends BlockFoodBowlBridge {
        @Override
        public boolean canBlockStay(World world, BlockPos pos) {
            IBlockState blockstate = world.func_180495_p(pos.func_177977_b());
            return blockstate.func_193401_d((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP) == BlockFaceShape.SOLID;
        }

        public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing facing) {
            return BlockFaceShape.UNDEFINED;
        }

        public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
            return this.onBlockActivatedGENERAL(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
        }
    }

    public static class BlockDogBedWrapper
    extends BlockDogBedBridge {
        @Override
        public boolean canBlockStay(World world, BlockPos pos) {
            IBlockState blockstate = world.func_180495_p(pos.func_177977_b());
            return blockstate.func_193401_d((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP) == BlockFaceShape.SOLID;
        }

        public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing facing) {
            return BlockFaceShape.UNDEFINED;
        }

        public void getDrops(NonNullList<ItemStack> drops, IBlockAccess worldIn, BlockPos pos, IBlockState state, int fortune) {
            ItemStack ret = (ItemStack)this.drops.get();
            this.drops.remove();
            if (ret != null) {
                drops.add((Object)ret);
            } else {
                TileEntity tileentity = worldIn.func_175625_s(pos);
                if (tileentity instanceof TileEntityDogBed) {
                    TileEntityDogBed dogBed = (TileEntityDogBed)tileentity;
                    drops.add((Object)DogBedRegistry.createItemStack(dogBed.getCasingId(), dogBed.getBeddingId()));
                }
            }
        }
    }

    public static class BlockDogBathWrapper
    extends BlockDogBathBridge {
        @Override
        public boolean canBlockStay(World world, BlockPos pos) {
            IBlockState blockstate = world.func_180495_p(pos.func_177977_b());
            return blockstate.func_193401_d((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP) == BlockFaceShape.SOLID;
        }

        public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing facing) {
            return BlockFaceShape.UNDEFINED;
        }
    }
}

