/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.base.f;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import doggytalents.api.registry.DogBedRegistry;
import doggytalents.base.f.DogBedItemOverride;
import doggytalents.block.BlockDogBed;
import doggytalents.client.model.block.IStateParticleModel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.vecmath.Matrix4f;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

@SideOnly(value=Side.CLIENT)
public class DogBedModel
implements IBakedModel,
IStateParticleModel {
    public static DogBedItemOverride ITEM_OVERIDE = new DogBedItemOverride();
    private IModel model;
    private IBakedModel bakedModel;
    private final Function<ResourceLocation, TextureAtlasSprite> textureGetter;
    private final VertexFormat format;
    private final Map<Map<String, EnumFacing>, IBakedModel> cache = Maps.newHashMap();

    public DogBedModel(IModel model, IBakedModel bakedModel, VertexFormat format) {
        this.model = model;
        this.bakedModel = bakedModel;
        this.textureGetter = location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
        this.format = format;
    }

    public IBakedModel getCustomModelFromState(IBlockState state) {
        String casing = "minecraft:blocks/planks_oak";
        String bedding = "minecraft:blocks/wool_colored_white";
        EnumFacing facing = EnumFacing.NORTH;
        if (state instanceof IExtendedBlockState) {
            IExtendedBlockState extendedState = (IExtendedBlockState)state;
            if (extendedState.getUnlistedNames().contains(BlockDogBed.CASING)) {
                casing = DogBedRegistry.CASINGS.getTexture((String)extendedState.getValue((IUnlistedProperty)BlockDogBed.CASING));
            }
            if (extendedState.getUnlistedNames().contains(BlockDogBed.BEDDING)) {
                bedding = DogBedRegistry.BEDDINGS.getTexture((String)extendedState.getValue((IUnlistedProperty)BlockDogBed.BEDDING));
            }
            facing = (EnumFacing)extendedState.func_177229_b((IProperty)BlockDogBed.FACING);
        }
        return this.getCustomModel(casing, bedding, facing);
    }

    public IBakedModel getCustomModel(String casingResource, String beddingResource, EnumFacing facing) {
        IBakedModel customModel = this.bakedModel;
        if (casingResource == null) {
            casingResource = "nomissing";
        }
        if (beddingResource == null) {
            beddingResource = "nomissing";
        }
        HashMap cacheKey = Maps.newHashMap();
        cacheKey.put(beddingResource + casingResource, facing);
        if (this.cache.containsKey(cacheKey)) {
            customModel = this.cache.get(cacheKey);
        } else if (this.model != null) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put((Object)"bedding", (Object)beddingResource);
            builder.put((Object)"casing", (Object)casingResource);
            builder.put((Object)"particle", (Object)casingResource);
            IModel retexturedModel = this.model.retexture(builder.build());
            if (facing == null) {
                facing = EnumFacing.NORTH;
            }
            customModel = retexturedModel.bake((IModelState)new TRSRTransformation(TRSRTransformation.getMatrix((EnumFacing)facing)), this.format, this.textureGetter::apply);
            this.cache.put(cacheKey, customModel);
        }
        return customModel;
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        return this.getCustomModelFromState(state).func_188616_a(state, side, rand);
    }

    public boolean func_177555_b() {
        return this.bakedModel.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.bakedModel.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.bakedModel.func_188618_c();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.bakedModel.func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return this.bakedModel.func_177552_f();
    }

    @Override
    public TextureAtlasSprite getParticleTexture(IBlockState state) {
        return this.getCustomModelFromState(state).func_177554_e();
    }

    public ItemOverrideList func_188617_f() {
        return ITEM_OVERIDE;
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        return Pair.of((Object)this, (Object)this.bakedModel.handlePerspective(cameraTransformType).getRight());
    }
}

