/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.attachments.retriever;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.uv.IconTransformation;
import cofh.core.util.helpers.ItemHelper;
import cofh.thermaldynamics.duct.Attachment;
import cofh.thermaldynamics.duct.attachments.servo.ServoItem;
import cofh.thermaldynamics.duct.item.DuctUnitItem;
import cofh.thermaldynamics.duct.item.TravelingItem;
import cofh.thermaldynamics.duct.tiles.TileGrid;
import cofh.thermaldynamics.init.TDItems;
import cofh.thermaldynamics.init.TDTextures;
import cofh.thermaldynamics.multiblock.Route;
import cofh.thermaldynamics.render.RenderDuct;
import java.util.Iterator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;

public class RetrieverItem
extends ServoItem {
    boolean baseTileHasOtherOutputs = false;

    public RetrieverItem(TileGrid tile, byte side) {
        super(tile, side);
    }

    public RetrieverItem(TileGrid tile, byte side, int type) {
        super(tile, side, type);
    }

    @Override
    public int getId() {
        return 6;
    }

    @Override
    public ItemStack getPickBlock() {
        return new ItemStack((Item)TDItems.itemRetriever, 1, this.type);
    }

    @Override
    public String getName() {
        return "item.thermaldynamics.retriever." + this.type + ".name";
    }

    @Override
    public boolean allowDuctConnection() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean render(IBlockAccess world, BlockRenderLayer layer, CCRenderState ccRenderState) {
        if (layer != BlockRenderLayer.SOLID) {
            return false;
        }
        Translation trans = Vector3.fromTileCenter((TileEntity)this.baseTile).translation();
        RenderDuct.modelConnection[this.isPowered ? 1 : 2][this.side].render(ccRenderState, new IVertexOperation[]{trans, new IconTransformation(TDTextures.RETRIEVER_BASE[this.stuffed ? 1 : 0][this.type])});
        return true;
    }

    @Override
    public void postNeighborChange() {
        this.baseTileHasOtherOutputs = false;
        for (int i = 0; i < 6; ++i) {
            if (!this.itemDuct.isOutput(this.side) && !this.itemDuct.isInput(this.side) || this.baseTile.getAttachment(this.side) != null && this.baseTile.getAttachment(this.side).getId() == 6) continue;
            this.baseTileHasOtherOutputs = true;
            break;
        }
        super.postNeighborChange();
    }

    @Override
    public void handleItemSending() {
        IItemHandler simulatedInv = this.getCachedInv();
        for (Route route : this.routesWithInsertSideList) {
            IItemHandler inv;
            DuctUnitItem.Cache cache;
            DuctUnitItem endPoint = (DuctUnitItem)route.endPoint;
            byte i = route.getLastSide();
            Attachment attachment = endPoint.parent.getAttachment(i);
            if (attachment != null && attachment.getId() == 6 || (cache = ((DuctUnitItem.Cache[])endPoint.tileCache)[i]) == null || !endPoint.isInput(i) && !endPoint.isOutput(i) || !endPoint.parent.getConnectionType((int)i).allowTransfer || (inv = cache.getItemHandler(i ^ 1)) == null) continue;
            for (int slot = 0; slot < inv.getSlots(); ++slot) {
                int maxStackSize;
                Route route1;
                ItemStack item = inv.getStackInSlot(slot);
                if (item.func_190926_b() || (item = this.limitOutput(ItemHelper.cloneStack((ItemStack)item, (int)(multiStack[this.type] ? item.func_77976_d() : item.func_190916_E())), simulatedInv, slot, this.side)).func_190926_b() || item.func_190916_E() == 0 || !this.filter.matchesFilter(item) || !cache.filter.matchesFilter(item)) continue;
                ItemStack remainder = DuctUnitItem.simulateInsertItemStackIntoInventory(simulatedInv, item.func_77946_l(), this.side ^ 1, this.filter.getMaxStock());
                if (!remainder.func_190926_b()) {
                    item.func_190918_g(remainder.func_190916_E());
                }
                if (item.func_190916_E() <= 0 || (route1 = endPoint.getRoute(this.itemDuct)) == null || (item = inv.extractItem(slot, maxStackSize = item.func_190916_E(), false)).func_190926_b() || item.func_190916_E() == 0) continue;
                route1 = route1.copy();
                route1.pathDirections.add(this.side);
                if (multiStack[this.type] && item.func_190916_E() < maxStackSize) {
                    while (item.func_190916_E() < maxStackSize && slot < inv.getSlots()) {
                        ItemStack extract;
                        if (ItemHelper.itemsEqualWithMetadata((ItemStack)inv.getStackInSlot(slot), (ItemStack)item, (boolean)true) && !(extract = inv.extractItem(slot, maxStackSize - item.func_190916_E(), false)).func_190926_b()) {
                            item.func_190917_f(extract.func_190916_E());
                        }
                        ++slot;
                    }
                }
                endPoint.insertNewItem(new TravelingItem(item, endPoint, route1, (byte)(i ^ 1), this.getSpeed()));
                this.routesWithInsertSideList.advanceCursor();
                return;
            }
        }
    }

    @Override
    public void handleStuffedItems() {
        Iterator iterator = this.stuffedItems.iterator();
        while (iterator.hasNext()) {
            ItemStack stuffedItem = (ItemStack)iterator.next();
            if (!this.filter.matchesFilter(stuffedItem)) continue;
            stuffedItem.func_190920_e(this.itemDuct.insertIntoInventory(stuffedItem, this.side));
            if (stuffedItem.func_190916_E() > 0) continue;
            iterator.remove();
        }
        super.handleStuffedItems();
    }

    @Override
    public void writePortableData(EntityPlayer player, NBTTagCompound tag) {
        super.writePortableData(player, tag);
        tag.func_74778_a("DisplayType", "item.thermaldynamics.retriever.0.name");
    }
}

