/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.item;

import cofh.core.util.helpers.StringHelper;
import cofh.thermaldynamics.ThermalDynamics;
import cofh.thermaldynamics.duct.Attachment;
import cofh.thermaldynamics.duct.attachments.cover.Cover;
import cofh.thermaldynamics.duct.attachments.cover.CoverHelper;
import cofh.thermaldynamics.duct.tiles.TileGrid;
import cofh.thermaldynamics.item.ItemAttachment;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ItemCover
extends ItemAttachment {
    private static List<ItemStack> coverList;

    public ItemCover() {
        this.func_77637_a(ThermalDynamics.tabCovers);
        this.func_77655_b("thermaldynamics.cover");
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.addAll(ItemCover.getCoverList());
        }
    }

    @Override
    public Attachment getAttachment(EnumFacing side, ItemStack stack, TileGrid tile) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null || !nbt.func_150297_b("Meta", 1) || !nbt.func_150297_b("Block", 8)) {
            return null;
        }
        byte meta = nbt.func_74771_c("Meta");
        Block block = Block.func_149684_b((String)nbt.func_74779_i("Block"));
        if (block == Blocks.field_150350_a || meta < 0 || meta >= 16 || !CoverHelper.isValid(block, meta)) {
            nbt.func_82580_o("Meta");
            nbt.func_82580_o("Block");
            if (nbt.func_82582_d()) {
                stack.func_77982_d(null);
            }
            return null;
        }
        return new Cover(tile, (byte)(side.ordinal() ^ 1), block.func_176203_a((int)meta));
    }

    public String func_77653_i(ItemStack item) {
        String name;
        ItemStack b = CoverHelper.getCoverItemStack(item, true);
        if (!b.func_190926_b()) {
            String unloc = this.func_77657_g(item) + ".";
            String unloc2 = b.func_77973_b().func_77657_g(b);
            if (StringHelper.canLocalize((String)(unloc + unloc2 + ".name"))) {
                return StringHelper.localize((String)(unloc + unloc2 + ".name"));
            }
            name = b.func_82833_r();
        } else {
            name = StringHelper.localize((String)"info.thermaldynamics.info.invalid");
        }
        return StringHelper.localizeFormat((String)(this.func_77657_g(item) + ".name"), (Object[])new Object[]{name});
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        ItemStack b = CoverHelper.getCoverItemStack(stack, false);
        if (b.func_190926_b()) {
            tooltip.add(StringHelper.getNoticeText((String)"info.thermaldynamics.info.invalidCover"));
        }
    }

    public boolean initialize() {
        ForgeRegistries.ITEMS.register(this.setRegistryName("cover"));
        return true;
    }

    public static List<ItemStack> getCoverList() {
        if (coverList == null || coverList.size() <= 0) {
            coverList = CoverHelper.getStateLookup().values().stream().map(CoverHelper::getCoverStack).collect(Collectors.toCollection(LinkedList::new));
        }
        return coverList;
    }
}

