/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.item;

import cofh.core.util.helpers.RecipeHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermaldynamics.ThermalDynamics;
import cofh.thermaldynamics.duct.Attachment;
import cofh.thermaldynamics.duct.Duct;
import cofh.thermaldynamics.duct.attachments.filter.FilterFluid;
import cofh.thermaldynamics.duct.attachments.filter.FilterItem;
import cofh.thermaldynamics.duct.attachments.filter.FilterLogic;
import cofh.thermaldynamics.duct.tiles.DuctToken;
import cofh.thermaldynamics.duct.tiles.TileGrid;
import cofh.thermaldynamics.item.ItemAttachment;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ItemFilter
extends ItemAttachment {
    public static EnumRarity[] rarity = new EnumRarity[]{EnumRarity.COMMON, EnumRarity.COMMON, EnumRarity.UNCOMMON, EnumRarity.UNCOMMON, EnumRarity.RARE};
    public static ItemStack filterBasic;
    public static ItemStack filterHardened;
    public static ItemStack filterReinforced;
    public static ItemStack filterSignalum;
    public static ItemStack filterResonant;

    public ItemFilter() {
        this.func_77655_b("thermaldynamics.filter");
    }

    public String func_77667_c(ItemStack item) {
        return super.func_77667_c(item) + "." + item.func_77952_i();
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (int i = 0; i < 5; ++i) {
                items.add((Object)new ItemStack((Item)this, 1, i));
            }
        }
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return rarity[stack.func_77952_i() % 5];
    }

    @Override
    public Attachment getAttachment(EnumFacing side, ItemStack stack, TileGrid tile) {
        int type = stack.func_77952_i() % 5;
        if (tile.getDuct(DuctToken.FLUID) != null) {
            return new FilterFluid(tile, (byte)(side.ordinal() ^ 1), type);
        }
        if (tile.getDuct(DuctToken.ITEMS) != null) {
            return new FilterItem(tile, (byte)(side.ordinal() ^ 1), type);
        }
        return null;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        int type = stack.func_77952_i() % 5;
        if (!StringHelper.isShiftKeyDown()) {
            tooltip.add(StringHelper.getInfoText((String)"item.thermaldynamics.filter.info"));
            if (StringHelper.displayShiftForDetail) {
                tooltip.add(StringHelper.shiftForDetails());
            }
            return;
        }
        tooltip.add("\u00a7e" + StringHelper.localize((String)"info.cofh.items") + "\u00a7r");
        ItemFilter.addFiltering(tooltip, type, Duct.Type.ITEM);
        tooltip.add("\u00a7e" + StringHelper.localize((String)"info.cofh.fluids") + "\u00a7r");
        ItemFilter.addFiltering(tooltip, type, Duct.Type.FLUID);
    }

    public static void addFiltering(List<String> list, int type, Duct.Type duct) {
        StringBuilder b = new StringBuilder();
        b.append(StringHelper.localize((String)"info.thermaldynamics.filter.options")).append(": ").append("\u00a7f");
        boolean flag = false;
        for (int i = 0; i < FilterLogic.flagTypes.length; ++i) {
            if (!FilterLogic.canAlterFlag(duct, type, i)) continue;
            if (flag) {
                b.append(", ");
            } else {
                flag = true;
            }
            b.append(StringHelper.localize((String)("info.thermaldynamics.filter." + FilterLogic.flagTypes[i])));
        }
        flag = false;
        for (String s : Minecraft.func_71410_x().field_71466_p.func_78271_c(b.toString(), 140)) {
            if (flag) {
                s = "  \u00a7f" + s;
            }
            flag = true;
            list.add("  " + s + "\u00a7r");
        }
    }

    public boolean initialize() {
        ForgeRegistries.ITEMS.register(this.setRegistryName("filter"));
        filterBasic = new ItemStack((Item)this, 1, 0);
        filterHardened = new ItemStack((Item)this, 1, 1);
        filterReinforced = new ItemStack((Item)this, 1, 2);
        filterSignalum = new ItemStack((Item)this, 1, 3);
        filterResonant = new ItemStack((Item)this, 1, 4);
        ThermalDynamics.proxy.addIModelRegister(this);
        return true;
    }

    @Override
    public boolean register() {
        RecipeHelper.addShapedRecipe((ItemStack)filterBasic, (Object[])new Object[]{"iGi", "IRI", Character.valueOf('i'), "nuggetIron", Character.valueOf('G'), "blockGlass", Character.valueOf('I'), "ingotIron", Character.valueOf('R'), Items.field_151121_aF});
        RecipeHelper.addShapedRecipe((ItemStack)filterHardened, (Object[])new Object[]{"iGi", "IRI", Character.valueOf('i'), "nuggetIron", Character.valueOf('G'), "blockGlass", Character.valueOf('I'), "ingotInvar", Character.valueOf('R'), Items.field_151121_aF});
        RecipeHelper.addShapelessRecipe((ItemStack)filterHardened, (Object[])new Object[]{filterBasic, "ingotInvar"});
        RecipeHelper.addShapedRecipe((ItemStack)filterReinforced, (Object[])new Object[]{"iGi", "IRI", Character.valueOf('i'), "nuggetIron", Character.valueOf('G'), "blockGlass", Character.valueOf('I'), "ingotElectrum", Character.valueOf('R'), Items.field_151121_aF});
        RecipeHelper.addShapelessRecipe((ItemStack)filterReinforced, (Object[])new Object[]{filterBasic, "ingotElectrum"});
        RecipeHelper.addShapelessRecipe((ItemStack)filterReinforced, (Object[])new Object[]{filterHardened, "ingotElectrum"});
        RecipeHelper.addShapedRecipe((ItemStack)filterSignalum, (Object[])new Object[]{"iGi", "IRI", Character.valueOf('i'), "nuggetIron", Character.valueOf('G'), "blockGlass", Character.valueOf('I'), "ingotSignalum", Character.valueOf('R'), Items.field_151121_aF});
        RecipeHelper.addShapelessRecipe((ItemStack)filterSignalum, (Object[])new Object[]{filterBasic, "ingotSignalum"});
        RecipeHelper.addShapelessRecipe((ItemStack)filterSignalum, (Object[])new Object[]{filterHardened, "ingotSignalum"});
        RecipeHelper.addShapelessRecipe((ItemStack)filterSignalum, (Object[])new Object[]{filterReinforced, "ingotSignalum"});
        RecipeHelper.addShapedRecipe((ItemStack)filterResonant, (Object[])new Object[]{"iGi", "IRI", Character.valueOf('i'), "nuggetIron", Character.valueOf('G'), "blockGlass", Character.valueOf('I'), "ingotEnderium", Character.valueOf('R'), Items.field_151121_aF});
        RecipeHelper.addShapelessRecipe((ItemStack)filterResonant, (Object[])new Object[]{filterBasic, "ingotEnderium"});
        RecipeHelper.addShapelessRecipe((ItemStack)filterResonant, (Object[])new Object[]{filterHardened, "ingotEnderium"});
        RecipeHelper.addShapelessRecipe((ItemStack)filterResonant, (Object[])new Object[]{filterReinforced, "ingotEnderium"});
        RecipeHelper.addShapelessRecipe((ItemStack)filterResonant, (Object[])new Object[]{filterSignalum, "ingotEnderium"});
        return true;
    }

    @Override
    public void registerModels() {
        String[] names = new String[]{"basic", "hardened", "reinforced", "signalum", "resonant"};
        for (int i = 0; i < names.length; ++i) {
            ModelResourceLocation location = new ModelResourceLocation("thermaldynamics:attachment", "type=" + this.getRegistryName().func_110623_a() + "_" + names[i]);
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)i, (ModelResourceLocation)location);
        }
    }
}

