/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix.common;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import pl.asie.foamfix.common.FoamyBlockState;
import pl.asie.foamfix.common.PropertyValueMapper;

public class FoamyExtendedBlockState
extends FoamyBlockState
implements IExtendedBlockState {
    private final ImmutableMap<IUnlistedProperty<?>, Optional<?>> unlistedProperties;

    public FoamyExtendedBlockState(PropertyValueMapper owner, Block block, ImmutableMap<IProperty<?>, Comparable<?>> properties, ImmutableMap<IUnlistedProperty<?>, Optional<?>> unlistedProperties) {
        super(owner, block, properties);
        this.unlistedProperties = unlistedProperties;
    }

    public FoamyExtendedBlockState(PropertyValueMapper owner, Block block, ImmutableMap<IProperty<?>, Comparable<?>> properties, ImmutableMap<IUnlistedProperty<?>, Optional<?>> unlistedProperties, int value) {
        super(owner, block, properties);
        this.unlistedProperties = unlistedProperties;
        this.value = value;
    }

    @Override
    public <T extends Comparable<T>, V extends T> IBlockState func_177226_a(IProperty<T> property, V propertyValue) {
        if (!this.func_177228_b().containsKey(property)) {
            throw new IllegalArgumentException("Cannot set property " + property + " as it does not exist in " + this.func_177230_c().func_176194_O());
        }
        if (!property.func_177700_c().contains(propertyValue)) {
            throw new IllegalArgumentException("Cannot set property " + property + " to " + this.value + " on block " + Block.field_149771_c.func_177774_c((Object)this.func_177230_c()) + ", it is not an allowed value");
        }
        if (this.func_177228_b().get(property) == propertyValue) {
            return this;
        }
        int newValue = this.owner.withPropertyValue(this.value, property, propertyValue);
        if (newValue == -1) {
            throw new IllegalArgumentException("Cannot set property " + property + " because FoamFix could not find a mapping for it! Please reproduce without FoamFix first!");
        }
        IBlockState state = this.owner.getPropertyByValue(newValue);
        if (Iterables.all((Iterable)this.unlistedProperties.values(), (Predicate)Predicates.equalTo(Optional.empty()))) {
            return state;
        }
        return new FoamyExtendedBlockState(this.owner, this.func_177230_c(), state.func_177228_b(), this.unlistedProperties, newValue);
    }

    public <V> IExtendedBlockState withProperty(IUnlistedProperty<V> property, V value) {
        if (!this.unlistedProperties.containsKey(property)) {
            throw new IllegalArgumentException("Cannot set unlisted property " + property + " as it does not exist in " + this.func_177230_c().func_176194_O());
        }
        if (!property.isValid(value)) {
            throw new IllegalArgumentException("Cannot set unlisted property " + property + " to " + value + " on block " + Block.field_149771_c.func_177774_c((Object)this.func_177230_c()) + ", it is not an allowed value");
        }
        HashMap newMap = new HashMap((Map<IUnlistedProperty<?>, Optional<?>>)this.unlistedProperties);
        newMap.put(property, Optional.ofNullable(value));
        if (Iterables.all(newMap.values(), (Predicate)Predicates.equalTo(Optional.empty()))) {
            return (IExtendedBlockState)this.owner.getPropertyByValue(this.value);
        }
        return new FoamyExtendedBlockState(this.owner, this.func_177230_c(), this.func_177228_b(), ImmutableMap.copyOf(newMap), this.value);
    }

    public Collection<IUnlistedProperty<?>> getUnlistedNames() {
        return Collections.unmodifiableCollection(this.unlistedProperties.keySet());
    }

    public <V> V getValue(IUnlistedProperty<V> property) {
        if (!this.unlistedProperties.containsKey(property)) {
            throw new IllegalArgumentException("Cannot get unlisted property " + property + " as it does not exist in " + this.func_177230_c().func_176194_O());
        }
        return (V)property.getType().cast(((Optional)this.unlistedProperties.get(property)).orElse(null));
    }

    public ImmutableMap<IUnlistedProperty<?>, Optional<?>> getUnlistedProperties() {
        return this.unlistedProperties;
    }

    public IBlockState getClean() {
        return this.owner.getPropertyByValue(this.value);
    }
}

