/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix.coremod;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraftforge.fml.common.asm.ASMTransformerWrapper;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import pl.asie.foamfix.coremod.FoamFixTransformer;
import pl.asie.foamfix.shared.FoamFixShared;

@IFMLLoadingPlugin.Name(value="Do not report to Forge! Remove FoamFixAPI (or replace with FoamFixAPI-Lawful) and try again.")
@IFMLLoadingPlugin.SortingIndex(value=1001)
@IFMLLoadingPlugin.TransformerExclusions(value={"pl.asie.foamfix"})
public class FoamFixCore
implements IFMLLoadingPlugin {
    public String[] getASMTransformerClass() {
        return new String[]{"pl.asie.foamfix.coremod.FoamFixTransformer"};
    }

    public String getModContainerClass() {
        return "pl.asie.foamfix.coremod.FoamFixCoreContainer";
    }

    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
        LaunchClassLoader classLoader;
        FoamFixShared.coremodEnabled = true;
        FoamFixShared.config.init(new File(new File("config"), "foamfix.cfg"), true);
        if (FoamFixShared.config.clInitOptions) {
            try {
                File forgeCfgFile;
                File optionsFile = new File("options.txt");
                if (!optionsFile.exists()) {
                    Files.write((CharSequence)"mipmapLevels:0\n", (File)optionsFile, (Charset)Charsets.UTF_8);
                }
                if (!(forgeCfgFile = new File(new File("config"), "forge.cfg")).exists()) {
                    Files.write((CharSequence)"client {\nB:alwaysSetupTerrainOffThread=true\n}\n", (File)forgeCfgFile, (Charset)Charsets.UTF_8);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (FoamFixShared.config.geBlacklistLibraryTransformers) {
            classLoader = (LaunchClassLoader)this.getClass().getClassLoader();
            classLoader.addTransformerExclusion("com.ibm.icu.");
            classLoader.addTransformerExclusion("com.sun.");
            classLoader.addTransformerExclusion("gnu.trove.");
            classLoader.addTransformerExclusion("io.netty.");
            classLoader.addTransformerExclusion("it.unimi.dsi.fastutil.");
            classLoader.addTransformerExclusion("joptsimple.");
            classLoader.addTransformerExclusion("org.apache.");
            classLoader.addTransformerExclusion("oshi.");
            classLoader.addTransformerExclusion("scala.");
        }
        classLoader = (LaunchClassLoader)this.getClass().getClassLoader();
        try {
            Field transformersField = ReflectionHelper.findField(LaunchClassLoader.class, (String[])new String[]{"transformers"});
            List transformerList = (List)transformersField.get(classLoader);
            for (int i = 0; i < transformerList.size(); ++i) {
                IClassTransformer transformer;
                IClassTransformer parentTransformer = transformer = (IClassTransformer)transformerList.get(i);
                if (!(transformer instanceof ASMTransformerWrapper.TransformerWrapper)) continue;
                Field parentTransformerField = ReflectionHelper.findField(ASMTransformerWrapper.TransformerWrapper.class, (String[])new String[]{"parent"});
                parentTransformer = (IClassTransformer)parentTransformerField.get(transformer);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        FoamFixTransformer.init();
    }

    public String getAccessTransformerClass() {
        return "pl.asie.foamfix.coremod.FoamFixAT";
    }
}

