/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix.coremod.injections.client;

import com.google.common.base.Objects;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.pipeline.BlockInfo;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.QuadGatheringTransformer;
import pl.asie.foamfix.client.FoamyConstants;
import pl.asie.foamfix.coremod.injections.client.IFoamFixBlockInfoDataProxy;

public class VertexLighterFlatInject
extends QuadGatheringTransformer {
    protected BlockInfo blockInfo;
    protected int posIndex;
    protected int normalIndex;
    protected int colorIndex;
    protected int lightmapIndex;

    public void setParent(IVertexConsumer parent) {
        super.setParent(parent);
        if (Objects.equal((Object)this.getVertexFormat(), (Object)parent.getVertexFormat())) {
            return;
        }
        VertexFormat targetFormat = VertexLighterFlatInject.getVertexFormatWithNormal(parent);
        if (Objects.equal((Object)this.getVertexFormat(), (Object)targetFormat)) {
            return;
        }
        this.setVertexFormat(targetFormat);
        for (int i = 0; i < this.getVertexFormat().func_177345_h(); ++i) {
            VertexFormatElement.EnumUsage usage = this.getVertexFormat().func_177348_c(i).func_177375_c();
            if (usage == VertexFormatElement.EnumUsage.POSITION) {
                this.posIndex = i;
                continue;
            }
            if (usage == VertexFormatElement.EnumUsage.NORMAL) {
                this.normalIndex = i;
                continue;
            }
            if (usage == VertexFormatElement.EnumUsage.COLOR) {
                this.colorIndex = i;
                continue;
            }
            if (usage != VertexFormatElement.EnumUsage.UV || this.getVertexFormat().func_177348_c(i).func_177369_e() != 1) continue;
            this.lightmapIndex = i;
        }
        if (this.posIndex == -1) {
            throw new IllegalArgumentException("vertex lighter needs format with position");
        }
        if (this.lightmapIndex == -1) {
            throw new IllegalArgumentException("vertex lighter needs format with lightmap");
        }
        if (this.colorIndex == -1) {
            throw new IllegalArgumentException("vertex lighter needs format with color");
        }
    }

    protected void processQuad() {
    }

    protected void updateLightmap(float[] normal, float[] lightmap, float x, float y, float z) {
        float e1 = 0.99f;
        float e2 = 0.95f;
        int posX = 1;
        int posY = 1;
        int posZ = 1;
        boolean full = this.blockInfo.getState().func_185917_h();
        if ((full || y < -e1) && normal[1] < -e2) {
            --posY;
        } else if ((full || y > e1) && normal[1] > e2) {
            ++posY;
        }
        if ((full || z < -e1) && normal[2] < -e2) {
            --posZ;
        } else if ((full || z > e1) && normal[2] > e2) {
            ++posZ;
        }
        if ((full || x < -e1) && normal[0] < -e2) {
            --posX;
        } else if ((full || x > e1) && normal[0] > e2) {
            ++posX;
        }
        lightmap[0] = (float)((IFoamFixBlockInfoDataProxy)this.blockInfo).getRawB()[posX][posY][posZ] * 32.0f / 65535.0f;
        lightmap[1] = (float)((IFoamFixBlockInfoDataProxy)this.blockInfo).getRawS()[posX][posY][posZ] * 32.0f / 65535.0f;
    }

    public static VertexFormat getVertexFormatWithNormal(IVertexConsumer parent) {
        VertexFormat format = parent.getVertexFormat();
        if (format.func_177350_b()) {
            return format;
        }
        format = new VertexFormat(format);
        format.func_181721_a(FoamyConstants.VLF_NORMAL);
        return format;
    }

    public void setQuadTint(int tint) {
    }

    public void setQuadOrientation(EnumFacing orientation) {
    }

    public void setApplyDiffuseLighting(boolean diffuse) {
    }

    public void setTexture(TextureAtlasSprite texture) {
    }

    public void updateBlockInfo_foamfix_old() {
    }

    public void updateBlockInfo() {
        this.updateBlockInfo_foamfix_old();
        ((IFoamFixBlockInfoDataProxy)this.blockInfo).updateRawBS();
    }
}

