/*
 * Decompiled with CFR 0.152.
 */
package tonius.simplyjetpacks.client.handler;

import java.lang.reflect.Field;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import tonius.simplyjetpacks.SimplyJetpacks;
import tonius.simplyjetpacks.client.audio.SoundJetpack;
import tonius.simplyjetpacks.config.Config;
import tonius.simplyjetpacks.handler.SyncHandler;
import tonius.simplyjetpacks.item.rewrite.ItemJetpack;
import tonius.simplyjetpacks.item.rewrite.Jetpack;
import tonius.simplyjetpacks.setup.ParticleType;

public class ClientTickHandler {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static ParticleType lastJetpackState = null;
    private static boolean wearingJetpack = false;
    private static boolean sprintKeyCheck = false;
    private static Field sprintToggleTimer = null;
    private static final int numItems = Jetpack.values().length;

    public ClientTickHandler() {
        try {
            sprintToggleTimer = ReflectionHelper.findField(EntityPlayerSP.class, (String[])new String[]{"sprintToggleTimer", "field_71156_d"});
        }
        catch (Exception e) {
            SimplyJetpacks.logger.error("Unable to find field \"sprintToggleTimer\"");
            e.printStackTrace();
        }
    }

    private static void tickStart() {
        if (ClientTickHandler.mc.field_71439_g == null) {
            return;
        }
        ParticleType jetpackState = null;
        ItemStack armor = ClientTickHandler.mc.field_71439_g.func_184582_a(EntityEquipmentSlot.CHEST);
        if (armor != null && armor.func_77973_b() instanceof ItemJetpack) {
            int i = MathHelper.func_76125_a((int)armor.func_77952_i(), (int)0, (int)(numItems - 1));
            Jetpack jetpack = Jetpack.getTypeFromMeta(i);
            if (jetpack != null) {
                jetpackState = jetpack.getDisplayParticleType(armor, (ItemJetpack)armor.func_77973_b(), (EntityLivingBase)ClientTickHandler.mc.field_71439_g);
            }
            wearingJetpack = true;
        } else {
            wearingJetpack = false;
        }
        if (jetpackState != lastJetpackState) {
            lastJetpackState = jetpackState;
            SyncHandler.processJetpackUpdate(ClientTickHandler.mc.field_71439_g.func_145782_y(), jetpackState);
        }
    }

    private static void tickEnd() {
        if (ClientTickHandler.mc.field_71439_g == null || ClientTickHandler.mc.field_71441_e == null) {
            return;
        }
        if (!mc.func_147113_T()) {
            Iterator<Integer> itr = SyncHandler.getJetpackStates().keySet().iterator();
            while (itr.hasNext()) {
                int currentEntity = itr.next();
                Entity entity = ClientTickHandler.mc.field_71441_e.func_73045_a(currentEntity);
                if (entity == null || !(entity instanceof EntityLivingBase) || entity.field_71093_bK != ClientTickHandler.mc.field_71439_g.field_71093_bK) {
                    itr.remove();
                    continue;
                }
                ParticleType particle = SyncHandler.getJetpackStates().get(currentEntity);
                if (particle != null) {
                    if (entity.func_70090_H() && particle != ParticleType.NONE) {
                        particle = ParticleType.BUBBLE;
                    }
                    SimplyJetpacks.proxy.showJetpackParticles((World)ClientTickHandler.mc.field_71441_e, (EntityLivingBase)entity, particle);
                    if (!Config.jetpackSounds || SoundJetpack.isPlayingFor(entity.func_145782_y())) continue;
                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new SoundJetpack((EntityLivingBase)entity));
                    continue;
                }
                itr.remove();
            }
        }
        if (sprintKeyCheck && ClientTickHandler.mc.field_71439_g.field_71158_b.field_192832_b < 1.0f) {
            sprintKeyCheck = false;
        }
        if (!Config.doubleTapSprintInAir || !wearingJetpack || ClientTickHandler.mc.field_71439_g.field_70122_E || ClientTickHandler.mc.field_71439_g.func_70051_ag() || ClientTickHandler.mc.field_71439_g.func_184587_cr() || ClientTickHandler.mc.field_71439_g.func_70644_a(MobEffects.field_76436_u)) {
            return;
        }
        if (!sprintKeyCheck && sprintToggleTimer != null && ClientTickHandler.mc.field_71439_g.field_71158_b.field_192832_b >= 1.0f && !ClientTickHandler.mc.field_71439_g.field_70123_F && ((float)ClientTickHandler.mc.field_71439_g.func_71024_bL().func_75116_a() > 6.0f || ClientTickHandler.mc.field_71439_g.field_71075_bZ.field_75101_c)) {
            try {
                if (sprintToggleTimer.getInt(ClientTickHandler.mc.field_71439_g) <= 0 && !ClientTickHandler.mc.field_71474_y.field_151444_V.func_151470_d()) {
                    sprintToggleTimer.setInt(ClientTickHandler.mc.field_71439_g, 7);
                    sprintKeyCheck = true;
                } else {
                    ClientTickHandler.mc.field_71439_g.func_70031_b(true);
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent evt) {
        if (evt.phase == TickEvent.Phase.START) {
            ClientTickHandler.tickStart();
        } else {
            ClientTickHandler.tickEnd();
        }
    }
}

