/*
 * Decompiled with CFR 0.152.
 */
package tonius.simplyjetpacks.item.rewrite;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IStringSerializable;
import net.minecraftforge.common.config.Configuration;
import tonius.simplyjetpacks.client.model.PackModelType;
import tonius.simplyjetpacks.config.PackDefaults;
import tonius.simplyjetpacks.handler.SyncHandler;
import tonius.simplyjetpacks.item.rewrite.ItemJetpack;
import tonius.simplyjetpacks.item.rewrite.MetaItemsMods;
import tonius.simplyjetpacks.setup.ModItems;
import tonius.simplyjetpacks.setup.ParticleType;
import tonius.simplyjetpacks.util.NBTHelper;

public enum Jetpack implements IStringSerializable
{
    CREATIVE_JETPACK("jetpack_Creative", 6, "jetpackCreative", EnumRarity.EPIC, ParticleType.RAINBOW_SMOKE, false),
    JETPACK_EIO_1("jetpack_EIO1", 1, "jetpackEIO1", EnumRarity.COMMON),
    JETPACK_EIO_2("jetpack_EIO2", 2, "jetpackEIO2", EnumRarity.COMMON),
    JETPACK_EIO_3("jetpack_EIO3", 3, "jetpackEIO3", EnumRarity.UNCOMMON),
    JETPACK_EIO_4("jetpack_EIO4", 4, "jetpackEIO4", EnumRarity.RARE),
    JETPACK_EIO_1_ARMORED("jetpack_EIO1_Armored", 1, "jetpackEIO1", EnumRarity.COMMON, true, MetaItemsMods.ARMOR_PLATING_EIO_1.ordinal()),
    JETPACK_EIO_2_ARMORED("jetpack_EIO2_Armored", 2, "jetpackEIO2", EnumRarity.COMMON, true, MetaItemsMods.ARMOR_PLATING_EIO_2.ordinal()),
    JETPACK_EIO_3_ARMORED("jetpack_EIO3_Armored", 3, "jetpackEIO3", EnumRarity.UNCOMMON, true, MetaItemsMods.ARMOR_PLATING_EIO_3.ordinal()),
    JETPACK_EIO_4_ARMORED("jetpack_EIO4_Armored", 4, "jetpackEIO4", EnumRarity.RARE, true, MetaItemsMods.ARMOR_PLATING_EIO_4.ordinal()),
    JETPLATE_EIO_5("jetpack_EIO5", 5, "jetpackEIO5", EnumRarity.EPIC, true),
    JETPACK_TE_1("jetpack_TE1", 1, "jetpackTE1", EnumRarity.COMMON),
    JETPACK_TE_2("jetpack_TE2", 2, "jetpackTE2", EnumRarity.COMMON),
    JETPACK_TE_3("jetpack_TE3", 3, "jetpackTE3", EnumRarity.UNCOMMON),
    JETPACK_TE_4("jetpack_TE4", 4, "jetpackTE4", EnumRarity.RARE),
    JETPACK_TE_1_ARMORED("jetpack_TE1_Armored", 1, "jetpackTE1", EnumRarity.COMMON, true, MetaItemsMods.ARMOR_PLATING_TE_1.ordinal()),
    JETPACK_TE_2_ARMORED("jetpack_TE2_Armored", 2, "jetpackTE2", EnumRarity.COMMON, true, MetaItemsMods.ARMOR_PLATING_TE_2.ordinal()),
    JETPACK_TE_3_ARMORED("jetpack_TE3_Armored", 3, "jetpackTE3", EnumRarity.UNCOMMON, true, MetaItemsMods.ARMOR_PLATING_TE_3.ordinal()),
    JETPACK_TE_4_ARMORED("jetpack_TE4_Armored", 4, "jetpackTE4", EnumRarity.RARE, true, MetaItemsMods.ARMOR_PLATING_TE_4.ordinal()),
    JETPLATE_TE_5("jetpack_TE5", 5, "jetpackTE5", EnumRarity.EPIC, true),
    JETPACK_VANILLA_1("jetpack_Vanilla1", 1, "jetpackVanilla1", EnumRarity.COMMON),
    JETPACK_VANILLA_2("jetpack_Vanilla2", 2, "jetpackVanilla2", EnumRarity.UNCOMMON),
    JETPACK_VANILLA_3("jetpack_Vanilla3", 3, "jetpackVanilla3", EnumRarity.RARE);

    protected final PackDefaults defaults;
    protected static final EnumSet<Jetpack> ALL_PACKS;
    protected static final EnumSet<Jetpack> PACKS_SJ;
    public static final EnumSet<Jetpack> PACKS_EIO;
    public static final EnumSet<Jetpack> PACKS_TE;
    public static final EnumSet<Jetpack> PACKS_VANILLA;
    protected static final String TAG_PARTICLE = "JetpackParticleType";
    public ParticleType defaultParticleType = ParticleType.DEFAULT;
    public PackModelType armorModel = PackModelType.FLAT;
    @Nonnull
    public final String baseName;
    @Nonnull
    public final String unlocalisedName;
    public final int tier;
    public int fuelCapacity;
    public int fuelPerTickIn;
    public int fuelPerTickOut;
    public int armorFuelPerHit;
    public int armorReduction;
    public int fuelUsage;
    public boolean isArmored;
    public int platingMeta;
    public boolean usesFuel;
    public EnumRarity rarity;
    public double speedVertical;
    public double accelVertical;
    public double speedVerticalHover;
    public double speedVerticalHoverSlow;
    public double speedSideways;
    public double sprintSpeedModifier;
    public double sprintFuelModifier;
    public boolean emergencyHoverMode;
    @Nonnull
    private final List<String> jetpacks = new ArrayList<String>();

    private Jetpack(String baseName, int tier, String defaultConfigKey, EnumRarity rarity, ParticleType defaultParticleType, boolean usesFuel) {
        this(baseName, tier, defaultConfigKey, rarity);
        this.defaultParticleType = defaultParticleType;
        this.usesFuel = usesFuel;
    }

    private Jetpack(String baseName, int tier, String defaultConfigKey, EnumRarity rarity, boolean isArmored) {
        this(baseName, tier, defaultConfigKey, rarity);
        this.isArmored = isArmored;
    }

    private Jetpack(String baseName, int tier, String defaultConfigKey, EnumRarity rarity, boolean isArmored, int platingMeta) {
        this(baseName, tier, defaultConfigKey, rarity);
        this.isArmored = isArmored;
        this.platingMeta = platingMeta;
    }

    private Jetpack(String baseName, int tier, String defaultConfigKey, EnumRarity rarity) {
        this.baseName = baseName;
        this.tier = tier;
        this.defaults = PackDefaults.get(defaultConfigKey);
        this.defaultParticleType = ParticleType.DEFAULT;
        this.unlocalisedName = "item.simplyjetpacks." + baseName;
        this.jetpacks.add(baseName);
        this.usesFuel = true;
        this.isArmored = false;
        this.rarity = rarity;
        this.setArmorModel(PackModelType.JETPACK);
    }

    @Nonnull
    public String getBaseName() {
        return this.baseName;
    }

    public int getFuelCapacity() {
        return this.fuelCapacity;
    }

    public int getTier() {
        return this.tier;
    }

    public int getFuelPerTickIn() {
        return this.fuelPerTickIn;
    }

    public int getFuelPerTickOut() {
        return this.fuelPerTickOut;
    }

    public int getArmorFuelPerHit() {
        return this.armorFuelPerHit;
    }

    public int getArmorReduction() {
        return this.armorReduction;
    }

    public int getFuelUsage() {
        return this.fuelUsage;
    }

    @Nonnull
    public ItemStack getStackJetpack() {
        return this.getStackJetpack(1);
    }

    @Nonnull
    public ItemStack getStackJetpack(int size) {
        return new ItemStack((Item)ModItems.itemJetpack, size, this.ordinal());
    }

    @Nonnull
    public List<String> getJetpacks() {
        return this.jetpacks;
    }

    public String func_176610_l() {
        return this.baseName.toLowerCase(Locale.ENGLISH);
    }

    public EnumRarity getRarity() {
        return this.rarity;
    }

    public boolean getIsArmored() {
        return this.isArmored;
    }

    public int getPlatingMeta() {
        return this.platingMeta;
    }

    @Nonnull
    public static Jetpack getTypeFromMeta(int meta) {
        return Jetpack.values()[meta >= 0 && meta < Jetpack.values().length ? meta : 0];
    }

    public static int getMetaFromType(Jetpack value) {
        return value.ordinal();
    }

    public ParticleType getParticleType(ItemStack stack) {
        if (stack.func_77978_p() != null && NBTHelper.hasData(stack, TAG_PARTICLE)) {
            int particle = NBTHelper.getInt(stack, TAG_PARTICLE);
            ParticleType particleType = ParticleType.values()[particle];
            if (particleType != null) {
                return particleType;
            }
        }
        NBTHelper.setInt(stack, TAG_PARTICLE, this.defaultParticleType.ordinal());
        return this.defaultParticleType;
    }

    public Jetpack setArmorModel(PackModelType armorModel) {
        this.armorModel = armorModel;
        return this;
    }

    public ParticleType getDisplayParticleType(ItemStack stack, ItemJetpack item, EntityLivingBase user) {
        boolean flyKeyDown = SyncHandler.isFlyKeyDown(user);
        if (item.isOn(stack) && item.getFuelStored(stack) > 0 && (flyKeyDown || item.isHoverModeOn(stack) && !user.field_70122_E && user.field_70181_x < 0.0)) {
            return this.getParticleType(stack);
        }
        return null;
    }

    public static void loadAllConfigs(Configuration config) {
        if (ModItems.integrateEIO) {
            for (Jetpack pack : PACKS_EIO) {
                pack.loadConfig(config);
            }
        }
        if (ModItems.integrateTE) {
            for (Jetpack pack : PACKS_TE) {
                pack.loadConfig(config);
            }
        }
        if (ModItems.integrateVanilla) {
            for (Jetpack pack : PACKS_VANILLA) {
                pack.loadConfig(config);
            }
        }
        for (Jetpack pack : PACKS_SJ) {
            pack.loadConfig(config);
        }
    }

    public static void writeAllConfigsToNBT(NBTTagCompound tag) {
        NBTTagCompound packTag;
        if (ModItems.integrateEIO) {
            for (Jetpack pack : PACKS_EIO) {
                packTag = new NBTTagCompound();
                pack.writeConfigToNBT(packTag);
                tag.func_74782_a(pack.defaults.section.id, (NBTBase)packTag);
            }
        }
        if (ModItems.integrateTE) {
            for (Jetpack pack : PACKS_TE) {
                packTag = new NBTTagCompound();
                pack.writeConfigToNBT(packTag);
                tag.func_74782_a(pack.defaults.section.id, (NBTBase)packTag);
            }
        }
        if (ModItems.integrateVanilla) {
            for (Jetpack pack : PACKS_VANILLA) {
                packTag = new NBTTagCompound();
                pack.writeConfigToNBT(packTag);
                tag.func_74782_a(pack.defaults.section.id, (NBTBase)packTag);
            }
        }
        for (Jetpack pack : PACKS_SJ) {
            packTag = new NBTTagCompound();
            pack.writeConfigToNBT(packTag);
            tag.func_74782_a(pack.defaults.section.id, (NBTBase)packTag);
        }
    }

    public static void readAllConfigsFromNBT(NBTTagCompound tag) {
        NBTTagCompound packTag;
        if (ModItems.integrateEIO) {
            for (Jetpack pack : PACKS_EIO) {
                packTag = tag.func_74775_l(pack.defaults.section.id);
                pack.readConfigFromNBT(packTag);
            }
        }
        if (ModItems.integrateTE) {
            for (Jetpack pack : PACKS_TE) {
                packTag = tag.func_74775_l(pack.defaults.section.id);
                pack.readConfigFromNBT(packTag);
            }
        }
        if (ModItems.integrateVanilla) {
            for (Jetpack pack : PACKS_VANILLA) {
                packTag = tag.func_74775_l(pack.defaults.section.id);
                pack.readConfigFromNBT(packTag);
            }
        }
        for (Jetpack pack : PACKS_SJ) {
            packTag = tag.func_74775_l(pack.defaults.section.id);
            pack.readConfigFromNBT(packTag);
        }
    }

    protected void loadConfig(Configuration config) {
        if (this.defaults.fuelCapacity != null) {
            this.fuelCapacity = config.get(this.defaults.section.name, "Fuel Capacity", this.defaults.fuelCapacity.intValue(), "The maximum amount of fuel that this pack can hold.").setMinValue(1).getInt(this.defaults.fuelCapacity.intValue());
        }
        if (this.defaults.fuelUsage != null) {
            this.fuelUsage = config.get(this.defaults.section.name, "Fuel Usage", this.defaults.fuelUsage.intValue(), "The amount of fuel that this pack uses every tick when used.").setMinValue(0).getInt(this.defaults.fuelUsage.intValue());
        }
        if (this.defaults.fuelPerTickIn != null) {
            this.fuelPerTickIn = config.get(this.defaults.section.name, "Fuel Per Tick In", this.defaults.fuelPerTickIn.intValue(), "The amount of fuel that can be inserted into this pack per tick from external sources.").setMinValue(0).getInt(this.defaults.fuelPerTickIn.intValue());
        }
        if (this.defaults.fuelPerTickOut != null) {
            this.fuelPerTickOut = config.get(this.defaults.section.name, "Fuel Per Tick Out", this.defaults.fuelPerTickOut.intValue(), "The amount of fuel that can be extracted from this pack per tick by external sources. Also determines how quickly Flux Packs can charge other items.").setMinValue(0).getInt(this.defaults.fuelPerTickOut.intValue());
        }
        if (this.defaults.armorReduction != null) {
            this.armorReduction = config.get(this.defaults.section.name, "Armor Reduction", this.defaults.armorReduction.intValue(), "How well this pack can protect the user from damage, if armored. The higher the value, the stronger the armor will be.").setMinValue(0).setMaxValue(20).getInt(this.defaults.armorReduction.intValue());
        }
        if (this.defaults.armorFuelPerHit != null) {
            this.armorFuelPerHit = config.get(this.defaults.section.name, "Armor Fuel Per Hit", this.defaults.armorFuelPerHit.intValue(), "How much fuel is lost from this pack when the user is hit, if armored.").setMinValue(0).getInt(this.defaults.armorFuelPerHit.intValue());
        }
        if (this.defaults.speedVertical != null) {
            this.speedVertical = config.get(this.defaults.section.name, "Vertical Speed", this.defaults.speedVertical.doubleValue(), "The maximum vertical speed of this jetpack when flying.").setMinValue(0.0).getDouble(this.defaults.speedVertical.doubleValue());
        }
        if (this.defaults.accelVertical != null) {
            this.accelVertical = config.get(this.defaults.section.name, "Vertical Acceleration", this.defaults.accelVertical.doubleValue(), "The vertical acceleration of this jetpack when flying; every tick, this amount of vertical speed will be added until maximum speed is reached.").setMinValue(0.0).getDouble(this.defaults.accelVertical.doubleValue());
        }
        if (this.defaults.speedVerticalHover != null) {
            this.speedVerticalHover = config.get(this.defaults.section.name, "Vertical Speed (Hover Mode)", this.defaults.speedVerticalHover.doubleValue(), "The maximum vertical speed of this jetpack when flying in hover mode.").setMinValue(0.0).getDouble(this.defaults.speedVerticalHover.doubleValue());
        }
        if (this.defaults.speedVerticalHoverSlow != null) {
            this.speedVerticalHoverSlow = config.get(this.defaults.section.name, "Vertical Speed (Hover Mode / Slow Descent)", this.defaults.speedVerticalHoverSlow.doubleValue(), "The maximum vertical speed of this jetpack when slowly descending in hover mode.").setMinValue(0.0).getDouble(this.defaults.speedVerticalHoverSlow.doubleValue());
        }
        if (this.defaults.speedSideways != null) {
            this.speedSideways = config.get(this.defaults.section.name, "Sideways Speed", this.defaults.speedSideways.doubleValue(), "The speed of this jetpack when flying sideways. This is mostly noticeable in hover mode.").setMinValue(0.0).getDouble(this.defaults.speedSideways.doubleValue());
        }
        if (this.defaults.sprintSpeedModifier != null) {
            this.sprintSpeedModifier = config.get(this.defaults.section.name, "Sprint Speed Multiplier", this.defaults.sprintSpeedModifier.doubleValue(), "How much faster this jetpack will fly forward when sprinting. Setting this to 1.0 will make sprinting have no effect apart from the added speed from vanilla.").setMinValue(0.0).getDouble(this.defaults.sprintSpeedModifier.doubleValue());
        }
        if (this.defaults.sprintFuelModifier != null) {
            this.sprintFuelModifier = config.get(this.defaults.section.name, "Sprint Fuel Usage Multiplier", this.defaults.sprintFuelModifier.doubleValue(), "How much more energy this jetpack will use when sprinting. Setting this to 1.0 will make sprinting have no effect on energy usage.").setMinValue(0.0).getDouble(this.defaults.sprintFuelModifier.doubleValue());
        }
        if (this.defaults.emergencyHoverMode != null) {
            this.emergencyHoverMode = config.get(this.defaults.section.name, "Emergency Hover Mode", this.defaults.emergencyHoverMode.booleanValue(), "When enabled, this jetpack will activate hover mode automatically when the wearer is about to die from a fall.").getBoolean(this.defaults.emergencyHoverMode.booleanValue());
        }
    }

    protected void writeConfigToNBT(NBTTagCompound tag) {
        if (this.defaults.fuelCapacity != null) {
            tag.func_74768_a("FuelCapacity", this.fuelCapacity);
        }
        if (this.defaults.fuelUsage != null) {
            tag.func_74768_a("FuelUsage", this.fuelUsage);
        }
        if (this.defaults.fuelPerTickIn != null) {
            tag.func_74768_a("FuelPerTickIn", this.fuelPerTickIn);
        }
        if (this.defaults.fuelPerTickOut != null) {
            tag.func_74768_a("FuelPerTickOut", this.fuelPerTickOut);
        }
        if (this.defaults.armorReduction != null) {
            tag.func_74768_a("ArmorReduction", this.armorReduction);
        }
        if (this.defaults.speedVertical != null) {
            tag.func_74780_a("SpeedVertical", this.speedVertical);
        }
        if (this.defaults.accelVertical != null) {
            tag.func_74780_a("AccelVertical", this.accelVertical);
        }
        if (this.defaults.speedVerticalHover != null) {
            tag.func_74780_a("SpeedVerticalHover", this.speedVerticalHover);
        }
        if (this.defaults.speedVerticalHoverSlow != null) {
            tag.func_74780_a("SpeedVerticalHoverSlow", this.speedVerticalHoverSlow);
        }
        if (this.defaults.speedSideways != null) {
            tag.func_74780_a("SpeedSideways", this.speedSideways);
        }
        if (this.defaults.sprintSpeedModifier != null) {
            tag.func_74780_a("SprintSpeedModifier", this.sprintSpeedModifier);
        }
        if (this.defaults.sprintFuelModifier != null) {
            tag.func_74780_a("SprintFuelModifier", this.sprintFuelModifier);
        }
        if (this.defaults.emergencyHoverMode != null) {
            tag.func_74757_a("EmergencyHoverMode", this.emergencyHoverMode);
        }
    }

    protected void readConfigFromNBT(NBTTagCompound tag) {
        if (this.defaults.fuelCapacity != null) {
            this.fuelCapacity = tag.func_74762_e("FuelCapacity");
        }
        if (this.defaults.fuelUsage != null) {
            this.fuelUsage = tag.func_74762_e("FuelUsage");
        }
        if (this.defaults.fuelPerTickIn != null) {
            this.fuelPerTickIn = tag.func_74762_e("FuelPerTickIn");
        }
        if (this.defaults.fuelPerTickOut != null) {
            this.fuelPerTickOut = tag.func_74762_e("FuelPerTickOut");
        }
        if (this.defaults.armorReduction != null) {
            this.armorReduction = tag.func_74762_e("ArmorReduction");
        }
        if (this.defaults.speedVertical != null) {
            this.speedVertical = tag.func_74769_h("SpeedVertical");
        }
        if (this.defaults.accelVertical != null) {
            this.accelVertical = tag.func_74769_h("AccelVertical");
        }
        if (this.defaults.speedVerticalHover != null) {
            this.speedVerticalHover = tag.func_74769_h("SpeedVerticalHover");
        }
        if (this.defaults.speedVerticalHoverSlow != null) {
            this.speedVerticalHoverSlow = tag.func_74769_h("SpeedVerticalHoverSlow");
        }
        if (this.defaults.speedSideways != null) {
            this.speedSideways = tag.func_74769_h("SpeedSideways");
        }
        if (this.defaults.sprintSpeedModifier != null) {
            this.sprintSpeedModifier = tag.func_74769_h("SprintSpeedModifier");
        }
        if (this.defaults.sprintFuelModifier != null) {
            this.sprintFuelModifier = tag.func_74769_h("SprintFuelModifier");
        }
        if (this.defaults.emergencyHoverMode != null) {
            this.emergencyHoverMode = tag.func_74767_n("EmergencyHoverMode");
        }
    }

    static {
        ALL_PACKS = EnumSet.allOf(Jetpack.class);
        PACKS_SJ = EnumSet.of(CREATIVE_JETPACK);
        PACKS_EIO = EnumSet.range(JETPACK_EIO_1, JETPLATE_EIO_5);
        PACKS_TE = EnumSet.range(JETPACK_TE_1, JETPLATE_TE_5);
        PACKS_VANILLA = EnumSet.range(JETPACK_VANILLA_1, JETPACK_VANILLA_3);
    }
}

