/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.oitsjustjose.geolosys.blocks.BlockOre;
import com.oitsjustjose.geolosys.blocks.BlockOreVanilla;
import com.oitsjustjose.geolosys.blocks.BlockSample;
import com.oitsjustjose.geolosys.blocks.BlockSampleVanilla;
import com.oitsjustjose.geolosys.items.ItemCluster;
import com.oitsjustjose.geolosys.items.ItemFieldManual;
import com.oitsjustjose.geolosys.items.ItemIngot;
import com.oitsjustjose.geolosys.items.ItemProPick;
import com.oitsjustjose.geolosys.util.ClientRegistry;
import com.oitsjustjose.geolosys.util.Config;
import com.oitsjustjose.geolosys.util.ConfigOres;
import com.oitsjustjose.geolosys.util.ConfigParser;
import com.oitsjustjose.geolosys.util.HelperFunctions;
import com.oitsjustjose.geolosys.world.ChunkData;
import com.oitsjustjose.geolosys.world.OreGenerator;
import com.oitsjustjose.geolosys.world.StoneGenerator;
import com.oitsjustjose.geolosys.world.VanillaWorldGenOverride;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStone;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Logger;

@Mod(modid="geolosys", name="Geolosys", version="1.8.4b", guiFactory="com.oitsjustjose.geolosys.util.ConfigGUI$GUIFactory", acceptedMinecraftVersions="1.12")
public class Geolosys {
    @Mod.Instance(value="geolosys")
    private static Geolosys instance;
    public Logger LOGGER;
    public ConfigOres configOres;
    public ClientRegistry clientRegistry;
    public ChunkData chunkOreGen;
    public ArrayList<IBlockState> userStates;
    public ConfigParser configParser;
    public Block ORE;
    public Block ORE_VANILLA;
    public Block ORE_SAMPLE;
    public Block ORE_SAMPLE_VANILLA;
    public Item CLUSTER;
    public Item INGOT;
    public Item PRO_PICK;
    public Item ALMANAC;

    public static Geolosys getInstance() {
        return instance;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.LOGGER = event.getModLog();
        MinecraftForge.EVENT_BUS.register((Object)new Config(event.getSuggestedConfigurationFile()));
        this.configOres = this.getOresConfig(event.getModConfigurationDirectory());
        this.clientRegistry = new ClientRegistry();
        MinecraftForge.EVENT_BUS.register((Object)this.clientRegistry);
        this.chunkOreGen = new ChunkData();
        this.userStates = new ArrayList();
        this.ORE = new BlockOre();
        this.ORE_VANILLA = new BlockOreVanilla();
        this.ORE_SAMPLE = new BlockSample();
        this.ORE_SAMPLE_VANILLA = new BlockSampleVanilla();
        this.CLUSTER = new ItemCluster();
        this.ALMANAC = new ItemFieldManual();
        if (Config.getInstance().enableIngots) {
            this.INGOT = new ItemIngot();
        }
        if (Config.getInstance().enableProPick) {
            this.PRO_PICK = new ItemProPick();
        }
        this.registerGeolosysOreGen();
        this.registerVanillaOreGen();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        MinecraftForge.ORE_GEN_BUS.register((Object)new VanillaWorldGenOverride());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (Config.getInstance().enableSmelting) {
            if (this.configOres.hematiteChance > 0 || this.configOres.limoniteChance > 0) {
                this.smeltSafely(new ItemStack(this.CLUSTER, 1, 0), "ingotIron");
            }
            if (this.configOres.goldChance > 0) {
                this.smeltSafely(new ItemStack(this.CLUSTER, 1, 1), "ingotGold");
            }
            if (this.configOres.malachiteChance > 0 || this.configOres.azuriteChance > 0) {
                this.smeltSafely(new ItemStack(this.CLUSTER, 1, 2), "ingotCopper");
            }
            if (this.configOres.cassiteriteChance > 0 || this.configOres.tealliteChance > 0) {
                this.smeltSafely(new ItemStack(this.CLUSTER, 1, 3), "ingotTin");
            }
            if (this.configOres.galenaChance > 0) {
                this.smeltSafely(new ItemStack(this.CLUSTER, 1, 4), "ingotSilver");
                this.smeltSafely(new ItemStack(this.CLUSTER, 1, 5), "ingotLead");
            }
            if (this.configOres.bauxiteChance > 0) {
                this.smeltSafely(new ItemStack(this.CLUSTER, 1, 6), "ingotAluminum");
            }
            if (this.configOres.limoniteChance > 0) {
                this.smeltSafely(new ItemStack(this.CLUSTER, 1, 7), "ingotNickel");
            }
            if (this.configOres.platinumChance > 0) {
                this.smeltSafely(new ItemStack(this.CLUSTER, 1, 8), "ingotPlatinum");
            }
            if (this.configOres.sphaleriteChance > 0) {
                this.smeltSafely(new ItemStack(this.CLUSTER, 1, 10), "ingotZinc");
            }
            if (Config.getInstance().enableYellorium) {
                this.smeltSafely(new ItemStack(this.CLUSTER, 1, 11), "ingotYellorium");
            }
            if (Config.getInstance().enableOsmium) {
                this.smeltSafely(new ItemStack(this.CLUSTER, 1, 12), "ingotOsmium");
            }
        }
        this.configParser = new ConfigParser();
        this.registerUserOreGen();
        this.registerUserStoneGen();
        GameRegistry.registerWorldGenerator((IWorldGenerator)new OreGenerator(), (int)0);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new StoneGenerator(), (int)100);
    }

    private void smeltSafely(ItemStack input, String oreDictName) {
        try {
            GameRegistry.addSmelting((ItemStack)input, (ItemStack)((ItemStack)OreDictionary.getOres((String)oreDictName).get(0)), (float)0.7f);
        }
        catch (IndexOutOfBoundsException | NullPointerException ex) {
            this.LOGGER.info(oreDictName + " has not been added already. Smelting has been skipped.");
        }
    }

    private void registerVanillaOreGen() {
        if (this.configOres.coalChance > 0) {
            OreGenerator.addOreGen(HelperFunctions.getStateFromMeta(this.ORE_VANILLA, 0), this.configOres.coalSize, 48, 70, this.configOres.coalChance, this.configOres.coalDimBlacklist);
        }
        if (this.configOres.cinnabarChance > 0) {
            OreGenerator.addOreGen(HelperFunctions.getStateFromMeta(this.ORE_VANILLA, 1), this.configOres.cinnabarSize, 5, 12, this.configOres.cinnabarChance, this.configOres.cinnabarDimBlacklist);
        }
        if (this.configOres.goldChance > 0) {
            OreGenerator.addOreGen(HelperFunctions.getStateFromMeta(this.ORE_VANILLA, 2), this.configOres.goldSize, 5, 30, this.configOres.goldChance, this.configOres.goldDimBlacklist);
        }
        if (this.configOres.lapisChance > 0) {
            OreGenerator.addOreGen(HelperFunctions.getStateFromMeta(this.ORE_VANILLA, 3), this.configOres.lapisSize, 10, 24, this.configOres.lapisChance, this.configOres.lapisDimBlacklist);
        }
        if (this.configOres.quartzChance > 0) {
            OreGenerator.addOreGen(HelperFunctions.getStateFromMeta(this.ORE_VANILLA, 4), this.configOres.quartzSize, 6, 29, this.configOres.quartzChance, this.configOres.quartzDimBlacklist);
        }
        if (this.configOres.kimberliteChance > 0) {
            OreGenerator.addOreGen(HelperFunctions.getStateFromMeta(this.ORE_VANILLA, 5), this.configOres.kimberliteSize, 2, 15, this.configOres.kimberliteChance, this.configOres.kimberliteDimBlacklist);
        }
        if (this.configOres.berylChance > 0) {
            OreGenerator.addOreGen(HelperFunctions.getStateFromMeta(this.ORE_VANILLA, 6), this.configOres.berylSize, 4, 32, this.configOres.berylChance, this.configOres.berylDimBlacklist);
        }
        if (Config.getInstance().modStones) {
            IBlockState diorite = Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.DIORITE);
            IBlockState andesite = Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.ANDESITE);
            IBlockState granite = Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.GRANITE);
            StoneGenerator.addStoneGen(andesite, 2, 70, 40);
            StoneGenerator.addStoneGen(diorite, 2, 70, 40);
            StoneGenerator.addStoneGen(granite, 2, 70, 40);
        }
    }

    private void registerGeolosysOreGen() {
        if (this.configOres.hematiteChance > 0) {
            OreGenerator.addOreGen(HelperFunctions.getStateFromMeta(this.ORE, 0), this.configOres.hematiteSize, 32, 60, this.configOres.hematiteChance, this.configOres.hematiteDimBlacklist);
        }
        if (this.configOres.limoniteChance > 0) {
            OreGenerator.addOreGen(HelperFunctions.getStateFromMeta(this.ORE, 1), this.configOres.limoniteSize, 6, 32, this.configOres.limoniteChance, this.configOres.limoniteDimBlacklist);
        }
        if (this.configOres.malachiteChance > 0) {
            OreGenerator.addOreGen(HelperFunctions.getStateFromMeta(this.ORE, 2), this.configOres.malachiteSize, 39, 44, this.configOres.malachiteChance, this.configOres.malachiteDimBlacklist);
        }
        if (this.configOres.azuriteChance > 0) {
            OreGenerator.addOreGen(HelperFunctions.getStateFromMeta(this.ORE, 3), this.configOres.azuriteSize, 12, 44, this.configOres.azuriteChance, this.configOres.azuriteDimBlacklist);
        }
        if (this.configOres.cassiteriteChance > 0) {
            OreGenerator.addOreGen(HelperFunctions.getStateFromMeta(this.ORE, 4), this.configOres.cassiteriteSize, 44, 68, this.configOres.cassiteriteChance, this.configOres.cassiteriteDimBlacklist);
        }
        if (this.configOres.tealliteChance > 0) {
            OreGenerator.addOreGen(HelperFunctions.getStateFromMeta(this.ORE, 5), this.configOres.tealliteSize, 8, 43, this.configOres.tealliteChance, this.configOres.tealliteDimBlacklist);
        }
        if (this.configOres.galenaChance > 0) {
            OreGenerator.addOreGen(HelperFunctions.getStateFromMeta(this.ORE, 6), this.configOres.galenaSize, 16, 50, this.configOres.galenaChance, this.configOres.galentaDimBlacklist);
        }
        if (this.configOres.bauxiteChance > 0) {
            OreGenerator.addOreGen(HelperFunctions.getStateFromMeta(this.ORE, 7), this.configOres.bauxiteSize, 45, 70, this.configOres.bauxiteChance, this.configOres.bauxiteDimBlacklist);
        }
        if (this.configOres.platinumChance > 0) {
            OreGenerator.addOreGen(HelperFunctions.getStateFromMeta(this.ORE, 8), this.configOres.platinumSize, 3, 25, this.configOres.platinumChance, this.configOres.platinumDimBlacklist);
        }
        if (this.configOres.autuniteChance > 0) {
            OreGenerator.addOreGen(HelperFunctions.getStateFromMeta(this.ORE, 9), this.configOres.autuniteSize, 8, 33, this.configOres.autuniteChance, this.configOres.autuniteDimBlacklist);
        }
        if (this.configOres.sphaleriteChance > 0) {
            OreGenerator.addOreGen(HelperFunctions.getStateFromMeta(this.ORE, 10), this.configOres.sphaleriteSize, 35, 55, this.configOres.sphaleriteChance, this.configOres.sphaleriteDimBlacklist);
        }
    }

    @Nonnull
    private ConfigOres getOresConfig(File configDir) {
        try {
            System.out.println(configDir.getAbsolutePath());
            FileReader fr = new FileReader(configDir.getAbsolutePath() + "/geolosys_ores.json".replace("/", File.separator));
            BufferedReader br = new BufferedReader(fr);
            String json = "";
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    json = json + line;
                }
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                return (ConfigOres)gson.fromJson(json, ConfigOres.class);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (FileNotFoundException e) {
            ConfigOres props = new ConfigOres();
            props.populateConfigs();
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String json = gson.toJson((Object)props);
            try {
                FileWriter fw = new FileWriter(configDir.getAbsolutePath() + "/geolosys_ores.json".replace("/", File.separator));
                fw.write(json);
                fw.close();
                return props;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return this.getOresConfig(configDir);
    }

    private void registerUserOreGen() {
        for (ConfigParser.Entry e : this.configParser.getUserOreEntries().keySet()) {
            OreGenerator.addOreGen(e.getState(), e.getSize(), e.getMinY(), e.getMaxY(), e.getChancePerChunk(), new int[]{-1, 1});
            this.userStates.add(e.getState());
        }
    }

    private void registerUserStoneGen() {
        for (ConfigParser.Entry e : this.configParser.getUserStoneEntries()) {
            StoneGenerator.addStoneGen(e.getState(), e.getMinY(), e.getMaxY(), e.getChancePerChunk());
        }
    }
}

