/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.blocks;

import com.oitsjustjose.geolosys.Geolosys;
import com.oitsjustjose.geolosys.blocks.Types;
import com.oitsjustjose.geolosys.util.Config;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockOre
extends Block {
    public static final PropertyEnum<Types.Modded> VARIANT = PropertyEnum.func_177709_a((String)"variant", Types.Modded.class);

    public BlockOre() {
        super(Material.field_151576_e);
        this.setRegistryName(new ResourceLocation("geolosys", "ore"));
        this.func_149711_c(7.5f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149647_a(CreativeTabs.field_78030_b);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)Types.Modded.HEMATITE)));
        this.func_149663_c(this.getRegistryName().toString().replaceAll(":", "."));
        this.setHarvestLevels();
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)this);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)new ItemBlockOre(this));
    }

    private void setHarvestLevels() {
        for (Types.Modded t : Types.Modded.values()) {
            this.setHarvestLevel("pickaxe", t.getToolLevel(), this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)t)));
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Geolosys.getInstance().CLUSTER;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Config config = Config.getInstance();
        Item CLUSTER = Geolosys.getInstance().CLUSTER;
        if (state.func_177230_c().func_176201_c(state) == 1) {
            Random rand = new Random();
            int rng = rand.nextInt(5);
            if (rng == 0) {
                drops.add((Object)new ItemStack(CLUSTER, 1, 7));
            } else {
                drops.add((Object)new ItemStack(CLUSTER, 1, 0));
            }
        } else if (state.func_177230_c().func_176201_c(state) == 6) {
            Random rand = new Random();
            int rng = rand.nextInt(2);
            if (rng == 0) {
                drops.add((Object)new ItemStack(CLUSTER, 1, 4));
                rng = rand.nextInt(2);
                if (rng == 0) {
                    drops.add((Object)new ItemStack(CLUSTER, 1, 5));
                }
            } else {
                drops.add((Object)new ItemStack(CLUSTER, 1, 5));
            }
        } else if (state.func_177230_c().func_176201_c(state) == 8) {
            if (config.enableOsmiumExclusively) {
                drops.add((Object)new ItemStack(CLUSTER, 1, 12));
            } else if (config.enableOsmium) {
                Random rand = new Random();
                int rng = rand.nextInt(2);
                if (rng == 0) {
                    drops.add((Object)new ItemStack(CLUSTER, 1, 8));
                } else {
                    drops.add((Object)new ItemStack(CLUSTER, 1, 12));
                }
            } else {
                drops.add((Object)new ItemStack(CLUSTER, 1, 8));
            }
        } else if (state.func_177230_c().func_176201_c(state) == 9) {
            if (config.enableYellorium) {
                Random rand = new Random();
                int rng = rand.nextInt(2);
                if (rng == 0) {
                    drops.add((Object)new ItemStack(CLUSTER, 1, 9));
                } else {
                    drops.add((Object)new ItemStack(CLUSTER, 1, 11));
                }
            } else {
                drops.add((Object)new ItemStack(CLUSTER, 1, 9));
            }
        } else {
            drops.add((Object)new ItemStack(CLUSTER, 1, this.func_180651_a(state)));
        }
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return state.func_177230_c().func_176201_c(state) == 0 || state.func_177230_c().func_176201_c(state) == 1;
    }

    protected ItemStack func_180643_i(IBlockState state) {
        switch (this.field_176227_L.func_177622_c().func_176201_c(state)) {
            case 0: {
                return new ItemStack(Blocks.field_150366_p);
            }
            case 1: {
                return new ItemStack(Blocks.field_150366_p);
            }
        }
        return new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
    }

    public int func_180651_a(IBlockState state) {
        int meta = state.func_177230_c().func_176201_c(state);
        switch (meta) {
            case 0: {
                return 0;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 3;
            }
            case 7: {
                return 6;
            }
            case 8: {
                return 8;
            }
            case 9: {
                return 9;
            }
            case 10: {
                return 10;
            }
        }
        return 0;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(state.func_177230_c(), 1, this.func_176201_c(state));
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Types.Modded.byMetadata(meta)));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Types.Modded.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((Types.Modded)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public class ItemBlockOre
    extends ItemBlock {
        ItemBlockOre(Block block) {
            super(block);
            this.func_77627_a(true);
            this.setRegistryName(block.getRegistryName());
            this.func_77656_e(0);
            this.registerModels();
        }

        public int func_77647_b(int damage) {
            return damage;
        }

        public String func_77667_c(ItemStack stack) {
            return stack.func_77973_b().getRegistryName().toString().replaceAll(":", ".") + "." + Types.Modded.byMetadata(stack.func_77960_j()).func_176610_l();
        }

        @SideOnly(value=Side.CLIENT)
        public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
            if (this.func_194125_a(tab)) {
                for (int i = 0; i < Types.Modded.values().length; ++i) {
                    list.add((Object)new ItemStack((Item)this, 1, i));
                }
            }
        }

        private void registerModels() {
            for (int i = 0; i < Types.Modded.values().length; ++i) {
                Geolosys.getInstance().clientRegistry.register(new ItemStack((Item)this, 1, i), VARIANT.func_177701_a() + "=" + Types.Modded.byMetadata(i).func_176610_l());
            }
        }
    }
}

