/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.blocks;

import com.oitsjustjose.geolosys.Geolosys;
import com.oitsjustjose.geolosys.blocks.Types;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockOreVanilla
extends Block {
    public static final PropertyEnum<Types.Vanilla> VARIANT = PropertyEnum.func_177709_a((String)"variant", Types.Vanilla.class);

    public BlockOreVanilla() {
        super(Material.field_151576_e);
        this.setRegistryName(new ResourceLocation("geolosys", "ore_vanilla"));
        this.func_149711_c(7.5f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149647_a(CreativeTabs.field_78030_b);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)Types.Vanilla.COAL)));
        this.func_149663_c(this.getRegistryName().toString().replaceAll(":", "."));
        this.setHarvestLevels();
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)this);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)new ItemBlockOre(this));
    }

    private void setHarvestLevels() {
        for (Types.Vanilla t : Types.Vanilla.values()) {
            this.setHarvestLevel("pickaxe", t.getToolLevel(), this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)t)));
        }
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return true;
    }

    protected ItemStack func_180643_i(IBlockState state) {
        switch (this.field_176227_L.func_177622_c().func_176201_c(state)) {
            case 0: {
                return new ItemStack(Blocks.field_150365_q);
            }
            case 1: {
                return new ItemStack(Blocks.field_150450_ax);
            }
            case 2: {
                return new ItemStack(Blocks.field_150352_o);
            }
            case 3: {
                return new ItemStack(Blocks.field_150369_x);
            }
            case 4: {
                return new ItemStack(Blocks.field_150449_bY);
            }
            case 5: {
                return new ItemStack(Blocks.field_150482_ag);
            }
            case 6: {
                return new ItemStack(Blocks.field_150412_bA);
            }
        }
        return new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Random random = new Random();
        int meta = state.func_177230_c().func_176201_c(state);
        if (meta == 0) {
            drops.add((Object)new ItemStack(Blocks.field_150365_q.func_180660_a(state, random, fortune), Blocks.field_150365_q.func_149679_a(fortune, random), Blocks.field_150365_q.func_180651_a(state)));
        } else if (meta == 1) {
            Item TE_MATERIAL;
            drops.add((Object)new ItemStack(Blocks.field_150450_ax.func_180660_a(state, random, fortune), Blocks.field_150450_ax.func_149679_a(fortune, random), Blocks.field_150450_ax.func_180651_a(state)));
            int RNG = random.nextInt(60);
            Item EXU_MATERIAL = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("extrautils2", "ingredients"));
            if (EXU_MATERIAL != null && RNG < 2) {
                drops.add((Object)new ItemStack(EXU_MATERIAL));
            }
            if ((TE_MATERIAL = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("thermalfoundation", "material"))) != null && RNG == 2) {
                drops.add((Object)new ItemStack(TE_MATERIAL, 1, 866));
            }
        } else if (meta == 2) {
            drops.add((Object)new ItemStack(Geolosys.getInstance().CLUSTER, 1, 1));
        } else if (meta == 3) {
            drops.add((Object)new ItemStack(Blocks.field_150369_x.func_180660_a(state, random, fortune), Blocks.field_150369_x.func_149679_a(fortune, random), Blocks.field_150369_x.func_180651_a(state)));
        } else if (meta == 4) {
            drops.add((Object)new ItemStack(Blocks.field_150449_bY.func_180660_a(state, random, fortune), Blocks.field_150449_bY.func_149679_a(fortune, random), Blocks.field_150449_bY.func_180651_a(state)));
            int fortuneDropCalc = 1 + random.nextInt(fortune + 1);
            for (int i = 0; i < fortuneDropCalc; ++i) {
                int rng = random.nextInt(25);
                Item certusQuartz = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("appliedenergistics2", "material"));
                Item blackQuartz = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("actuallyadditions", "item_misc"));
                if (certusQuartz != null) {
                    if (rng < 5) {
                        drops.add((Object)new ItemStack(certusQuartz, 1, 0));
                    } else if (rng > 5 && rng < 7) {
                        drops.add((Object)new ItemStack(certusQuartz, 1, 1));
                    }
                }
                if (blackQuartz == null || rng < 6 || rng >= 10) continue;
                drops.add((Object)new ItemStack(blackQuartz, 1, 5));
            }
        } else if (meta == 5) {
            drops.add((Object)new ItemStack(Blocks.field_150482_ag.func_180660_a(state, random, fortune), Blocks.field_150482_ag.func_149679_a(fortune, random), Blocks.field_150482_ag.func_180651_a(state)));
        } else if (meta == 6) {
            drops.add((Object)new ItemStack(Blocks.field_150412_bA.func_180660_a(state, random, fortune), Blocks.field_150412_bA.func_149679_a(fortune, random), Blocks.field_150412_bA.func_180651_a(state)));
        }
    }

    public int getExpDrop(IBlockState state, IBlockAccess world, BlockPos pos, int fortune) {
        switch (state.func_177230_c().func_176201_c(state)) {
            case 0: {
                return Blocks.field_150365_q.getExpDrop(state, world, pos, fortune);
            }
            case 1: {
                return Blocks.field_150450_ax.getExpDrop(state, world, pos, fortune);
            }
            case 3: {
                return Blocks.field_150369_x.getExpDrop(state, world, pos, fortune);
            }
            case 4: {
                return Blocks.field_150449_bY.getExpDrop(state, world, pos, fortune);
            }
            case 5: {
                return Blocks.field_150482_ag.getExpDrop(state, world, pos, fortune);
            }
            case 6: {
                return Blocks.field_150412_bA.getExpDrop(state, world, pos, fortune);
            }
        }
        return 0;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(state.func_177230_c(), 1, this.func_176201_c(state));
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Types.Vanilla.byMetadata(meta)));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Types.Vanilla.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((Types.Vanilla)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public class ItemBlockOre
    extends ItemBlock {
        ItemBlockOre(Block block) {
            super(block);
            this.func_77627_a(true);
            this.setRegistryName(block.getRegistryName());
            this.func_77656_e(0);
            this.registerModels();
        }

        public int func_77647_b(int damage) {
            return damage;
        }

        public String func_77667_c(ItemStack stack) {
            return stack.func_77973_b().getRegistryName().toString().replaceAll(":", ".") + "." + Types.Vanilla.byMetadata(stack.func_77960_j()).func_176610_l();
        }

        @SideOnly(value=Side.CLIENT)
        public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
            if (this.func_194125_a(tab)) {
                for (int i = 0; i < Types.Vanilla.values().length; ++i) {
                    list.add((Object)new ItemStack((Item)this, 1, i));
                }
            }
        }

        private void registerModels() {
            for (int i = 0; i < Types.Vanilla.values().length; ++i) {
                Geolosys.getInstance().clientRegistry.register(new ItemStack((Item)this, 1, i), VARIANT.func_177701_a() + "=" + Types.Vanilla.byMetadata(i).func_176610_l());
            }
        }
    }
}

