/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.items;

import com.google.common.collect.Lists;
import com.oitsjustjose.geolosys.Geolosys;
import com.oitsjustjose.geolosys.util.HelperFunctions;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenBook;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.io.IOUtils;
import org.lwjgl.input.Keyboard;

public class ItemFieldManual
extends Item {
    public ItemFieldManual() {
        this.func_77625_d(1);
        this.func_77637_a(CreativeTabs.field_78040_i);
        this.setRegistryName(new ResourceLocation("geolosys", "FIELD_MANUAL"));
        this.func_77655_b(this.getRegistryName().toString().replaceAll(":", "."));
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this);
        this.registerModel();
    }

    private void registerModel() {
        Geolosys.getInstance().clientRegistry.register(new ItemStack((Item)this), new ResourceLocation(this.getRegistryName().toString()), "inventory");
    }

    public String func_77667_c(ItemStack stack) {
        return stack.func_77973_b().getRegistryName().toString().replaceAll(":", ".");
    }

    @SideOnly(value=Side.CLIENT)
    public String func_77653_i(ItemStack stack) {
        return HelperFunctions.getTranslation(this.func_77667_c(stack));
    }

    @SideOnly(value=Side.CLIENT)
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiScreenBook(player, this.getBook(new Book(this.getNumEntries())), false));
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            tooltip.add(HelperFunctions.getTranslation(this.func_77667_c(stack) + ".tooltip"));
        } else {
            tooltip.add(HelperFunctions.getTranslation("shift.tooltip"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack getBook(Book book) {
        Object formattedString;
        NBTTagCompound tags = new NBTTagCompound();
        ArrayList pages = Lists.newArrayList();
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        TIntObjectHashMap contents = new TIntObjectHashMap();
        for (Page page : book.pages) {
            StringBuilder sb = new StringBuilder();
            String title = page.getTitle();
            String text = page.getText();
            if (title == null || text == null || title.isEmpty() || text.isEmpty()) {
                System.out.println("Well you succ");
                break;
            }
            contents.put(pages.size(), (Object)title);
            sb.append(TextFormatting.UNDERLINE).append(title).append(TextFormatting.RESET).append("\n\n").append(text);
            formattedString = sb.toString();
            List splitStrings = fontRenderer.func_78271_c((String)formattedString, 116);
            StringBuilder sb2 = new StringBuilder();
            int lineNumber = 0;
            for (String s : splitStrings) {
                sb2.append(s).append("\n");
                if (++lineNumber < 13) continue;
                pages.add(new NBTTagString(sb2.toString()));
                sb2 = new StringBuilder();
                lineNumber = 0;
            }
            if (lineNumber == 0) continue;
            pages.add(new NBTTagString(sb2.toString()));
        }
        NBTTagList pageList = new NBTTagList();
        pageList.func_74742_a((NBTBase)new NBTTagString(TextFormatting.BOLD + "\n\n\n\n      Geolosys\n    Field Manual"));
        int offset = 3 + contents.size() / 13;
        int[] keys = contents.keys();
        Arrays.sort(keys);
        StringBuilder builder3 = new StringBuilder("Contents:\n\n");
        int i = 2;
        for (int key : keys) {
            String line = (String)contents.get(key);
            int a = key + offset;
            while (fontRenderer.func_78271_c(line + " " + a, 116).size() > 1) {
                line = line.substring(0, line.length() - 1);
            }
            line = line + " ";
            while (fontRenderer.func_78271_c(line + " " + a, 116).size() == 1) {
                line = line + " ";
            }
            line = line + a;
            builder3.append(line).append('\n');
            if (++i < 13) continue;
            i = 0;
            pageList.func_74742_a((NBTBase)new NBTTagString(builder3.toString()));
            builder3 = new StringBuilder();
        }
        if (i != 0) {
            pageList.func_74742_a((NBTBase)new NBTTagString(builder3.toString()));
        }
        formattedString = pages.iterator();
        while (formattedString.hasNext()) {
            NBTTagString page2 = (NBTTagString)formattedString.next();
            pageList.func_74742_a((NBTBase)page2);
        }
        tags.func_74782_a("pages", (NBTBase)pageList);
        tags.func_74778_a("title", HelperFunctions.getTranslation("geolosys.field_manual.name"));
        tags.func_74778_a("author", "oitsjustjose");
        ItemStack stack = new ItemStack(Items.field_151164_bB);
        stack.func_77982_d(tags);
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    public String translatePageText(int pageNumber) {
        String langFile = Minecraft.func_71410_x().field_71474_y.field_74363_ab;
        langFile = langFile.substring(0, langFile.indexOf("_")) + langFile.substring(langFile.indexOf("_")).toUpperCase();
        InputStream in = Geolosys.class.getResourceAsStream("/assets/geolosys/book/" + langFile + ".lang");
        if (in == null) {
            langFile = "en_US";
            in = Geolosys.class.getResourceAsStream("/assets/geolosys/book/" + langFile + ".lang");
        }
        try {
            for (String s : IOUtils.readLines((InputStream)in, (String)"utf-8")) {
                if (s.indexOf("=") == -1 || !s.substring(0, s.indexOf("=")).equals("page_" + pageNumber + "_text")) continue;
                return s.substring(s.indexOf("=") + 1);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "ERROR READING PAGE " + pageNumber;
    }

    @SideOnly(value=Side.CLIENT)
    public String translateTitle(int pageNumber) {
        String langFile = Minecraft.func_71410_x().field_71474_y.field_74363_ab;
        langFile = langFile.substring(0, langFile.indexOf("_")) + langFile.substring(langFile.indexOf("_")).toUpperCase();
        InputStream in = Geolosys.class.getResourceAsStream("/assets/geolosys/book/" + langFile + ".lang");
        if (in == null) {
            langFile = "en_US";
            in = Geolosys.class.getResourceAsStream("/assets/geolosys/book/" + langFile + ".lang");
        }
        try {
            for (String s : IOUtils.readLines((InputStream)in, (String)"utf-8")) {
                if (s.indexOf("=") == -1 || !s.substring(0, s.indexOf("=")).equals("page_" + pageNumber + "_title")) continue;
                return s.substring(s.indexOf("=") + 1);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "ERROR READING PAGE " + pageNumber;
    }

    @SideOnly(value=Side.CLIENT)
    public int getNumEntries() {
        String langFile = Minecraft.func_71410_x().field_71474_y.field_74363_ab;
        langFile = langFile.substring(0, langFile.indexOf("_")) + langFile.substring(langFile.indexOf("_")).toUpperCase();
        InputStream in = Geolosys.class.getResourceAsStream("/assets/geolosys/book/" + langFile + ".lang");
        int numLines = 0;
        if (in == null) {
            langFile = "en_US";
            in = Geolosys.class.getResourceAsStream("/assets/geolosys/lang/" + langFile + ".lang");
        }
        try {
            for (String s : IOUtils.readLines((InputStream)in, (String)"utf-8")) {
                if (s.indexOf("=") == -1 || !s.contains("_title")) continue;
                ++numLines;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return numLines;
    }

    @SideOnly(value=Side.CLIENT)
    public class Page {
        private String title;
        private String text;

        public Page(int pageNumber) {
            this.title = ItemFieldManual.this.translateTitle(pageNumber);
            this.text = ItemFieldManual.this.translatePageText(pageNumber);
        }

        public String getTitle() {
            return this.title;
        }

        public String getText() {
            return this.text;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class Book {
        private List<Page> pages = Lists.newArrayList();

        public Book(int pageCount) {
            for (int i = 0; i < pageCount; ++i) {
                this.pages.add(new Page(i + 1));
            }
        }
    }
}

