/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.util;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class Config {
    public Configuration config;
    public ConfigCategory FeatureControl;
    public ConfigCategory Samples;
    public ConfigCategory UserEntries;
    public boolean modStones;
    public boolean enableOsmium;
    public boolean enableOsmiumExclusively;
    public boolean enableYellorium;
    public boolean enableIngots;
    public boolean enableProPick;
    public boolean enableSmelting;
    public boolean registerAsBauxite;
    public int maxSamples;
    public boolean generateSamplesInWater;
    public boolean boringSamples;
    public String[] userOreEntriesRaw;
    public String[] userStoneEntriesRaw;
    private static Config instance;

    public Config(File configFile) {
        if (this.config == null) {
            this.config = new Configuration(configFile, null, true);
            this.loadConfiguration();
        }
        instance = this;
    }

    void loadConfiguration() {
        String category = "Feature Control";
        ArrayList propertyOrder = Lists.newArrayList();
        this.FeatureControl = this.config.getCategory(category);
        this.FeatureControl.setComment("Control which features are enabled:");
        Property property = this.config.get(category, "Replace Stone Variant Deposits", true).setRequiresMcRestart(true);
        this.modStones = property.getBoolean();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Enable Yellorium", true);
        this.enableYellorium = property.getBoolean();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Enable Osmium", true);
        this.enableOsmium = property.getBoolean();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Enable Osmium Exclusively (without platinum)", false);
        this.enableOsmiumExclusively = property.getBoolean();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Enable Ingots", true).setRequiresMcRestart(true);
        this.enableIngots = property.getBoolean();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Enable Prospector's Pick", true).setRequiresMcRestart(true);
        this.enableProPick = property.getBoolean();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Enable Cluster Smelting", true).setRequiresMcRestart(true);
        this.enableSmelting = property.getBoolean();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Register Aluminum Cluster as oreBauxite", false).setRequiresMcRestart(true);
        this.registerAsBauxite = property.getBoolean();
        propertyOrder.add(property.getName());
        this.FeatureControl.setPropertyOrder((List)propertyOrder);
        category = "Ore Samples";
        propertyOrder = Lists.newArrayList();
        this.Samples = this.config.getCategory(category);
        this.Samples.setComment("Settings strictly regarding samples");
        property = this.config.get(category, "Maximum Number of Samples per Chunk", 10);
        property.setMinValue(1);
        property.setMaxValue(16);
        this.maxSamples = property.getInt();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Allow samples to spawn in water (shallow or deep)", false);
        this.generateSamplesInWater = property.getBoolean();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Samples drop nothing, instead reveal their contents via chat", false);
        this.boringSamples = property.getBoolean();
        propertyOrder.add(property.getName());
        this.Samples.setPropertyOrder((List)propertyOrder);
        category = "User Entries";
        propertyOrder = Lists.newArrayList();
        this.UserEntries = this.config.getCategory(category).setRequiresMcRestart(true);
        this.UserEntries.setComment("It is STRONGLY suggested you use the ConfigGUI for this.");
        property = this.config.get(category, "Custom Ore Entries", new String[0]);
        property.setComment("Format is:\nmodid:block:meta, clusterSize, min Y, max Y, chance to gen in chunk. Example:\nactuallyadditions:block_misc:3, 32, 13, 42, 20\nOptionally you can declare your own \"sample\" block by appending an extra modid:block:meta to the end. Example:\nactuallyadditions:block_misc:3, 32, 13, 42, 20, actuallyadditions:block_misc:1\nMETA, COLONS AND COMMAS ARE REQUIRED.");
        this.userOreEntriesRaw = property.getStringList();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Custom Stone Entries", new String[0]);
        property.setComment("Format is:\nmodid:block:meta, min Y, max Y, chance to gen in chunk\nALL CLUSTERS ARE APPROX. THE SAME SIZE & AREN'T CONFIGURABLE.\nMETA, COLONS AND COMMAS ARE REQUIRED. Example:\nrustic:slate:0, 27, 54, 10");
        this.userStoneEntriesRaw = property.getStringList();
        propertyOrder.add(property.getName());
        this.UserEntries.setPropertyOrder((List)propertyOrder);
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    @SubscribeEvent
    public void update(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("geolosys")) {
            this.loadConfiguration();
        }
    }

    public static Config getInstance() {
        return instance;
    }
}

