/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.world;

import com.oitsjustjose.geolosys.Geolosys;
import com.oitsjustjose.geolosys.blocks.BlockSample;
import com.oitsjustjose.geolosys.blocks.BlockSampleVanilla;
import com.oitsjustjose.geolosys.util.Config;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;

public class ChunkData {
    Random random = new Random();
    private HashSet<ChunkPos> populatedChunks = new HashSet();

    public void addChunk(ChunkPos pos, World world, IBlockState state) {
        this.populatedChunks.add(pos);
        if (world.func_175624_G() == WorldType.field_77138_c) {
            return;
        }
        int cap = this.getSampleCount(state);
        for (int i = 0; i < cap; ++i) {
            BlockPos p = this.getSamplePos(world, pos);
            if (world.func_180495_p(p.func_177977_b()).func_177230_c() instanceof BlockSample || world.func_180495_p(p.func_177977_b()).func_177230_c() instanceof BlockSampleVanilla || !Config.getInstance().generateSamplesInWater && this.isMoist(world, p)) continue;
            world.func_175656_a(p, state);
        }
    }

    public boolean canGenerateInChunk(ChunkPos pos) {
        return !this.populatedChunks.contains(pos);
    }

    private BlockPos getSamplePos(World world, ChunkPos chunkPos) {
        return world.func_175672_r(new BlockPos((chunkPos.field_77276_a << 4) + this.random.nextInt(16), 0, (chunkPos.field_77275_b << 4) + this.random.nextInt(16)));
    }

    private boolean isMoist(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177984_a()).func_185904_a().func_76224_d() || world.func_180495_p(pos.func_177974_f()).func_185904_a().func_76224_d() || world.func_180495_p(pos.func_177976_e()).func_185904_a().func_76224_d() || world.func_180495_p(pos.func_177978_c()).func_185904_a().func_76224_d() || world.func_180495_p(pos.func_177968_d()).func_185904_a().func_76224_d();
    }

    private int getSampleCount(IBlockState state) {
        int count = 0;
        if (state.func_177230_c() == Geolosys.getInstance().ORE_SAMPLE) {
            switch (state.func_177230_c().func_176201_c(state)) {
                case 0: {
                    count = Math.round((float)Geolosys.getInstance().configOres.hematiteSize / (float)Config.getInstance().maxSamples);
                    break;
                }
                case 1: {
                    count = Math.round((float)Geolosys.getInstance().configOres.limoniteSize / (float)Config.getInstance().maxSamples);
                    break;
                }
                case 2: {
                    count = Math.round((float)Geolosys.getInstance().configOres.malachiteSize / (float)Config.getInstance().maxSamples);
                    break;
                }
                case 3: {
                    count = Math.round((float)Geolosys.getInstance().configOres.azuriteSize / (float)Config.getInstance().maxSamples);
                    break;
                }
                case 4: {
                    count = Math.round((float)Geolosys.getInstance().configOres.cassiteriteSize / (float)Config.getInstance().maxSamples);
                    break;
                }
                case 5: {
                    count = Math.round((float)Geolosys.getInstance().configOres.tealliteSize / (float)Config.getInstance().maxSamples);
                    break;
                }
                case 6: {
                    count = Math.round((float)Geolosys.getInstance().configOres.galenaSize / (float)Config.getInstance().maxSamples);
                    break;
                }
                case 7: {
                    count = Math.round((float)Geolosys.getInstance().configOres.bauxiteSize / (float)Config.getInstance().maxSamples);
                    break;
                }
                case 8: {
                    count = Math.round((float)Geolosys.getInstance().configOres.platinumSize / (float)Config.getInstance().maxSamples);
                    break;
                }
                case 9: {
                    count = Math.round((float)Geolosys.getInstance().configOres.autuniteSize / (float)Config.getInstance().maxSamples);
                    break;
                }
                case 10: {
                    count = Math.round((float)Geolosys.getInstance().configOres.sphaleriteSize / (float)Config.getInstance().maxSamples);
                }
            }
        } else if (state.func_177230_c() == Geolosys.getInstance().ORE_SAMPLE_VANILLA) {
            switch (state.func_177230_c().func_176201_c(state)) {
                case 0: {
                    count = Math.round((float)Geolosys.getInstance().configOres.coalSize / (float)Config.getInstance().maxSamples);
                    break;
                }
                case 1: {
                    count = Math.round((float)Geolosys.getInstance().configOres.cinnabarSize / (float)Config.getInstance().maxSamples);
                    break;
                }
                case 2: {
                    count = Math.round((float)Geolosys.getInstance().configOres.goldSize / (float)Config.getInstance().maxSamples);
                    break;
                }
                case 3: {
                    count = Math.round((float)Geolosys.getInstance().configOres.lapisSize / (float)Config.getInstance().maxSamples);
                    break;
                }
                case 4: {
                    count = Math.round((float)Geolosys.getInstance().configOres.quartzSize / (float)Config.getInstance().maxSamples);
                    break;
                }
                case 5: {
                    count = Math.round((float)Geolosys.getInstance().configOres.kimberliteSize / (float)Config.getInstance().maxSamples);
                    break;
                }
                case 6: {
                    count = Math.round((float)Geolosys.getInstance().configOres.berylSize / (float)Config.getInstance().maxSamples);
                }
            }
        }
        if (count > Config.getInstance().maxSamples) {
            count = Config.getInstance().maxSamples;
        }
        return count;
    }
}

