/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.world;

import com.google.common.base.Predicate;
import com.oitsjustjose.geolosys.Geolosys;
import com.oitsjustjose.geolosys.world.WorldGenOrePluton;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class OreGenerator
implements IWorldGenerator {
    public static ArrayList<OreGen> oreSpawnList = new ArrayList();

    public static OreGen addOreGen(IBlockState state, int maxVeinSize, int minY, int maxY, int weight, int[] blacklist) {
        OreGen gen = new OreGen(state, maxVeinSize, Blocks.field_150348_b, minY, maxY, weight, blacklist);
        oreSpawnList.add(gen);
        return gen;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (oreSpawnList.size() > 0 && world.field_73011_w.getDimension() != -1 && world.field_73011_w.getDimension() != 1) {
            oreSpawnList.get(random.nextInt(oreSpawnList.size())).generate(world, random, chunkX * 16, chunkZ * 16);
        }
    }

    public static class OreGen {
        WorldGenOrePluton pluton;
        IBlockState state;
        int minY;
        int maxY;
        int weight;
        int[] blacklistedDims;

        public OreGen(IBlockState state, int maxVeinSize, Block replaceTarget, int minY, int maxY, int weight, int[] blacklist) {
            this.pluton = new WorldGenOrePluton(state, maxVeinSize, (Predicate<IBlockState>)BlockMatcher.func_177642_a((Block)replaceTarget));
            this.state = state;
            this.minY = minY;
            this.maxY = maxY;
            this.weight = weight;
            this.blacklistedDims = blacklist;
        }

        public void generate(World world, Random rand, int x, int z) {
            if (!Geolosys.getInstance().chunkOreGen.canGenerateInChunk(new ChunkPos(x / 16, z / 16))) {
                return;
            }
            if (this.blacklistedDims != null) {
                for (int i : this.blacklistedDims) {
                    if (i != world.field_73011_w.getDimension()) continue;
                    return;
                }
            } else if (world.field_73011_w.getDimension() == 1 || world.field_73011_w.getDimension() == -1) {
                return;
            }
            if (rand.nextInt(100) < this.weight) {
                BlockPos pos = new BlockPos(x + rand.nextInt(11) - 5, this.minY + rand.nextInt(this.maxY - this.minY), z + rand.nextInt(11) - 5);
                this.pluton.func_180709_b(world, rand, pos);
                Geolosys.getInstance().chunkOreGen.addChunk(new ChunkPos(x / 16, z / 16), world, this.getSampleForOre(this.state));
            }
        }

        private IBlockState getSampleForOre(IBlockState state) {
            if (state.func_177230_c() == Geolosys.getInstance().ORE) {
                return Geolosys.getInstance().ORE_SAMPLE.func_176203_a(state.func_177230_c().func_176201_c(state));
            }
            if (state.func_177230_c() == Geolosys.getInstance().ORE_VANILLA) {
                return Geolosys.getInstance().ORE_SAMPLE_VANILLA.func_176203_a(state.func_177230_c().func_176201_c(state));
            }
            if (Geolosys.getInstance().configParser.blockstateExistsInEntries(state)) {
                return Geolosys.getInstance().configParser.getSampleForState(state);
            }
            return state;
        }
    }
}

