/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import twilightforest.TFFeature;
import twilightforest.world.ChunkGeneratorTwilightForest;
import twilightforest.world.TFWorld;
import twilightforest.world.WorldProviderTwilightForest;

public class CommandTFFeature
extends CommandBase {
    public String func_71517_b() {
        return "tffeature";
    }

    public String func_71518_a(ICommandSender sender) {
        return "tffeature accepts the following arguments: info";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length <= 0) throw new WrongUsageException("commands.tffeature.usage", new Object[0]);
        if (args[0].equalsIgnoreCase("info")) {
            EntityPlayerMP player = CommandTFFeature.func_71521_c((ICommandSender)sender);
            int dx = MathHelper.func_76128_c((double)player.field_70165_t);
            int dy = MathHelper.func_76128_c((double)player.field_70163_u);
            int dz = MathHelper.func_76128_c((double)player.field_70161_v);
            if (!(player.field_70170_p.field_73011_w instanceof WorldProviderTwilightForest)) {
                throw new WrongUsageException("commands.tffeature.not_in_twilight_forest", new Object[0]);
            }
            TFFeature nearbyFeature = TFFeature.getFeatureAt(dx, dz, player.field_70170_p);
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("The nearest feature is %s", new Object[]{nearbyFeature.name}));
            ChunkGeneratorTwilightForest chunkProvider = (ChunkGeneratorTwilightForest)TFWorld.getChunkGenerator(player.field_70170_p);
            BlockPos pos = new BlockPos(dx, dy, dz);
            if (chunkProvider.isBlockInStructureBB(pos)) {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("You are in the structure for that feature.", new Object[0]));
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("Structure conquer flag = %s.", new Object[]{chunkProvider.isStructureConquered(pos)}));
                return;
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("You are not in the structure for that feature.", new Object[0]));
            }
            return;
        } else if (args[0].equalsIgnoreCase("reactivate")) {
            this.changeStructureActivity(sender, false);
            return;
        } else if (args[0].equalsIgnoreCase("conquer")) {
            this.changeStructureActivity(sender, true);
            return;
        } else {
            if (!args[0].equalsIgnoreCase("center")) throw new WrongUsageException("commands.tffeature.usage", new Object[0]);
            EntityPlayerMP player = CommandTFFeature.func_71521_c((ICommandSender)sender);
            int dx = MathHelper.func_76128_c((double)player.field_70165_t);
            int dz = MathHelper.func_76128_c((double)player.field_70161_v);
            BlockPos cc = TFFeature.getNearestCenterXYZ(dx >> 4, dz >> 4, player.field_70170_p);
            boolean fc = TFFeature.isInFeatureChunk(player.field_70170_p, dx, dz);
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("Center of feature = %s.", new Object[]{cc}));
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("Are in feature chunk = %s.", new Object[]{fc}));
        }
    }

    private void changeStructureActivity(ICommandSender sender, boolean flag) throws CommandException {
        BlockPos pos;
        EntityPlayerMP player = CommandTFFeature.func_71521_c((ICommandSender)sender);
        int dx = MathHelper.func_76128_c((double)player.field_70165_t);
        int dy = MathHelper.func_76128_c((double)player.field_70163_u);
        int dz = MathHelper.func_76128_c((double)player.field_70161_v);
        if (!(player.field_70170_p.field_73011_w instanceof WorldProviderTwilightForest)) {
            throw new WrongUsageException("commands.tffeature.not_in_twilight_forest", new Object[0]);
        }
        ChunkGeneratorTwilightForest chunkProvider = (ChunkGeneratorTwilightForest)TFWorld.getChunkGenerator(player.field_70170_p);
        if (chunkProvider.isBlockInStructureBB(pos = new BlockPos(dx, dy, dz))) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("Structure conquer flag was %s.  Changing to %s.", new Object[]{chunkProvider.isStructureConquered(pos), flag}));
            chunkProvider.setStructureConquered(dx, dy, dz, flag);
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("You are not in a structure.", new Object[0]));
        }
    }
}

