/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import team.chisel.api.ChiselAPIProps;
import team.chisel.api.IMC;
import twilightforest.TwilightForestMod;
import twilightforest.block.TFBlocks;
import twilightforest.block.enums.CastleBrickVariant;
import twilightforest.block.enums.DeadrockVariant;
import twilightforest.block.enums.MazestoneVariant;
import twilightforest.block.enums.TowerWoodVariant;
import twilightforest.block.enums.UnderBrickVariant;

public enum TFCompat {
    CHISEL{

        @Override
        public void init() {
            this.addBlockToCarvingGroup("stonebrick", new ItemStack(TFBlocks.spiral_bricks, 1, 0));
            for (MazestoneVariant mazestoneVariant : MazestoneVariant.values()) {
                this.addBlockToCarvingGroup("mazestone", new ItemStack(TFBlocks.mazestone, 1, mazestoneVariant.ordinal()));
            }
            for (Enum enum_ : UnderBrickVariant.values()) {
                this.addBlockToCarvingGroup("underbrick", new ItemStack(TFBlocks.underBrick, 1, enum_.ordinal()));
            }
            for (Enum enum_ : TowerWoodVariant.values()) {
                this.addBlockToCarvingGroup("towerwood", new ItemStack(TFBlocks.towerWood, 1, enum_.ordinal()));
            }
            for (Enum enum_ : DeadrockVariant.values()) {
                this.addBlockToCarvingGroup("deadrock", new ItemStack(TFBlocks.deadrock, 1, enum_.ordinal()));
            }
            for (Enum enum_ : CastleBrickVariant.values()) {
                this.addBlockToCarvingGroup("castlebrick", new ItemStack(TFBlocks.castleBlock, 1, enum_.ordinal()));
            }
            for (Enum enum_ : CastleBrickVariant.values()) {
                this.addBlockToCarvingGroup("castlebrick", new ItemStack(TFBlocks.castleBlock, 1, enum_.ordinal()));
            }
            for (int i = 0; i < 4; ++i) {
                this.addBlockToCarvingGroup("castlebrick", new ItemStack(TFBlocks.castlePillar, 1, i));
            }
            this.addBlockToCarvingGroup("castlebrickstairs", new ItemStack(TFBlocks.castleStairs, 1, 0));
            this.addBlockToCarvingGroup("castlebrickstairs", new ItemStack(TFBlocks.castleStairs, 1, 8));
        }

        private void addBlockToCarvingGroup(String group, ItemStack stack) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a("group", group);
            nbt.func_74782_a("stack", (NBTBase)stack.serializeNBT());
            FMLInterModComms.sendMessage((String)ChiselAPIProps.MOD_ID, (String)IMC.ADD_VARIATION_V2.toString(), (NBTTagCompound)nbt);
        }
    }
    ,
    THAUMCRAFT{

        @Override
        protected void init() {
        }
    };


    protected abstract void init();

    public static void initCompat() {
        for (TFCompat compat : TFCompat.values()) {
            if (Loader.isModLoaded((String)compat.name().toLowerCase())) {
                try {
                    compat.init();
                    TwilightForestMod.LOGGER.info("twilightforest has loaded compatibility for mod " + compat.name().toLowerCase() + "");
                }
                catch (Exception e) {
                    TwilightForestMod.LOGGER.info("twilightforest had an error loading " + compat.name().toLowerCase() + " compatibility!");
                    TwilightForestMod.LOGGER.catching(e.fillInStackTrace());
                }
                continue;
            }
            TwilightForestMod.LOGGER.info("twilightforest has skipped compatibility for mod " + compat.name().toLowerCase() + "");
        }
    }
}

