/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import twilightforest.TwilightForestMod;

@Config(modid="twilightforest")
@Mod.EventBusSubscriber(modid="twilightforest")
public class TFConfig {
    private static final String config = "twilightforest.config.";
    @Config.LangKey(value="twilightforest.config.dimension")
    public static final Dimension dimension = new Dimension();
    @Config.LangKey(value="twilightforest.config.tree_tweaks")
    public static final Performance performance = new Performance();
    @Config.LangKey(value="twilightforest.config.silent_cicadas")
    public static boolean silentCicadas = false;
    @Config.LangKey(value="twilightforest.config.portals_in_other_dimensions")
    public static boolean allowPortalsInOtherDimensions = false;
    @Config.LangKey(value="twilightforest.config.admin_portals")
    public static boolean adminOnlyPortals = false;
    @Config.LangKey(value="twilightforest.config.portals")
    public static boolean disablePortalCreation = false;
    @Config.LangKey(value="twilightforest.config.portal_creator")
    public static String portalCreationItem = "minecraft:diamond";
    @Config.LangKey(value="twilightforest.config.portal_creator_meta")
    @Config.RangeInt(min=-1)
    public static int portalCreationMeta = -1;
    @Config.LangKey(value="twilightforest.config.uncrafting")
    public static boolean disableUncrafting = false;
    @Config.LangKey(value="twilightforest.config.antibuilder_blacklist")
    public static String[] antibuilderBlacklist = new String[]{"minecraft:bedrock", "tombmanygraves:grave_block"};
    @Config.LangKey(value="twilightforest.config.animate_trophyitem")
    public static boolean rotateTrophyHeadsGui = true;
    @Config.LangKey(value="twilightforest.config.loading_screen")
    public static final loadingScreen loadingScreen = new loadingScreen();
    private static List<IBlockState> antibuilderStateBlacklist;

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("twilightforest")) {
            ConfigManager.sync((String)"twilightforest", (Config.Type)Config.Type.INSTANCE);
            TFConfig.loadAntiBuilderBlacklist();
            loadingScreen.loadLoadingScreenIcons();
        }
    }

    private static void loadAntiBuilderBlacklist() {
        ArrayList blacklist = Lists.newArrayList();
        for (String s : antibuilderBlacklist) {
            Block block;
            String[] data = s.split(":");
            if (data.length < 2 || (block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(data[0], data[1]))) == Blocks.field_150350_a) continue;
            int meta = 0;
            if (data.length >= 3) {
                try {
                    meta = Integer.parseInt(data[2]);
                }
                catch (NumberFormatException e) {
                    TwilightForestMod.LOGGER.warn("Had a slight hiccup processing \"" + s + "\" as part of the antibuilder blacklist.");
                    meta = 0;
                }
            }
            blacklist.add(block.func_176203_a(meta));
        }
        antibuilderStateBlacklist = blacklist;
    }

    public static List<IBlockState> getAntiBuilderBlacklist() {
        if (antibuilderStateBlacklist == null || antibuilderStateBlacklist.isEmpty()) {
            TFConfig.loadAntiBuilderBlacklist();
        }
        return antibuilderStateBlacklist;
    }

    public static class loadingScreen {
        @Config.LangKey(value="twilightforest.config.loading_icon_enable")
        public boolean enable = true;
        @Config.LangKey(value="twilightforest.config.loading_screen_swap_frequency")
        @Config.RangeInt(min=0)
        public int cycleLoadingScreenFrequency = 0;
        @Config.LangKey(value="twilightforest.config.loading_icon_wobble_bounce_frequency")
        @Config.RangeDouble(min=0.0)
        public float frequency = 5.0f;
        @Config.LangKey(value="twilightforest.config.loading_icon_scale")
        @Config.RangeDouble(min=0.0)
        public float scale = 3.0f;
        @Config.LangKey(value="twilightforest.config.loading_icon_bounciness")
        @Config.RangeDouble(min=0.0)
        public float scaleDeviation = 5.25f;
        @Config.LangKey(value="twilightforest.config.loading_icon_tilting")
        @Config.RangeDouble(min=0.0, max=360.0)
        public float tiltRange = 11.25f;
        @Config.LangKey(value="twilightforest.config.loading_icon_tilt_pushback")
        @Config.RangeDouble(min=0.0, max=360.0)
        public float tiltConstant = 22.5f;
        @Config.LangKey(value="twilightforest.config.loading_icon_stacks")
        public String[] loadingIconStacks = new String[]{"twilightforest:experiment_115", "twilightforest:magic_map", "twilightforest:charm_of_life_2", "twilightforest:charm_of_keeping_3", "twilightforest:phantom_helmet", "twilightforest:lamp_of_cinders", "twilightforest:carminite", "twilightforest:block_and_chain", "twilightforest:yeti_helmet", "twilightforest:hydra_chop", "twilightforest:magic_beans", "twilightforest:ironwood_raw", "twilightforest:naga_scale", "twilightforest:experiment_115:2", "twilightforest:miniature_structure", "twilightforest:miniature_structure:6", "twilightforest:knightmetal_block", "twilightforest:tower_device:10", "twilightforest:twilight_sapling:5", "twilightforest:twilight_sapling:6", "twilightforest:twilight_sapling:7", "twilightforest:twilight_sapling:8", "twilightforest:twilight_sapling:9", "twilightforest:borer_essence"};
        private List<ItemStack> loadingScreenIcons;

        public List<ItemStack> getLoadingScreenIcons() {
            if (this.loadingScreenIcons == null || this.loadingScreenIcons.isEmpty()) {
                this.loadLoadingScreenIcons();
            }
            return this.loadingScreenIcons;
        }

        void loadLoadingScreenIcons() {
            ArrayList iconList = Lists.newArrayList();
            for (String s : this.loadingIconStacks) {
                int meta;
                String[] data = s.split(":");
                Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(data[0], data[1]));
                if (item == null) continue;
                try {
                    meta = Integer.parseInt(data[2]);
                }
                catch (Exception e) {
                    meta = 0;
                }
                iconList.add(new ItemStack(item, 1, meta));
            }
            this.loadingScreenIcons = iconList;
        }
    }

    public static class Performance {
        @Config.LangKey(value="twilightforest.config.canopy_coverage")
        @Config.RangeDouble(min=0.0)
        public float canopyCoverage = 1.7f;
        @Config.LangKey(value="twilightforest.config.twilight_oaks")
        @Config.RangeInt(min=0)
        public int twilightOakChance = 48;
    }

    public static class Dimension {
        @Config.LangKey(value="twilightforest.config.dimension_id")
        @Config.RequiresMcRestart
        public int dimensionID = 7;
        @Config.LangKey(value="twilightforest.config.dimension_seed")
        @Config.RequiresWorldRestart
        public String twilightForestSeed = "";
    }
}

