/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.biomes;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenShrub;
import twilightforest.TFFeature;
import twilightforest.biomes.TFBiomeBase;
import twilightforest.biomes.TFDarkForestBiomeDecorator;
import twilightforest.entity.EntityTFKingSpider;
import twilightforest.entity.EntityTFKobold;
import twilightforest.entity.EntityTFMistWolf;
import twilightforest.entity.EntityTFSkeletonDruid;

public class TFBiomeDarkForest
extends TFBiomeBase {
    private static final int MONSTER_SPAWN_RATE = 20;
    private Random monsterRNG;

    public TFBiomeDarkForest(Biome.BiomeProperties props) {
        super(props);
        this.getTFBiomeDecorator().canopyPerChunk = 5.5f;
        this.getTFBiomeDecorator().setTreesPerChunk(10);
        this.getTFBiomeDecorator().setGrassPerChunk(-99);
        this.getTFBiomeDecorator().setFlowersPerChunk(-99);
        this.getTFBiomeDecorator().setMushroomsPerChunk(2);
        this.getTFBiomeDecorator().setDeadBushPerChunk(10);
        this.monsterRNG = new Random();
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityEnderman.class, 1, 1, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityZombie.class, 5, 1, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntitySkeleton.class, 5, 1, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityTFMistWolf.class, 10, 1, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityTFSkeletonDruid.class, 10, 1, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityTFKingSpider.class, 10, 1, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityTFKobold.class, 10, 4, 8));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityWitch.class, 1, 1, 1));
        this.field_76760_I.field_76808_K = false;
    }

    @Override
    public BiomeDecorator func_76729_a() {
        return new TFDarkForestBiomeDecorator();
    }

    @Override
    public WorldGenAbstractTree func_150567_a(Random random) {
        if (random.nextInt(5) == 0) {
            return new WorldGenShrub(Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE), Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.OAK));
        }
        if (random.nextInt(8) == 0) {
            return this.birchGen;
        }
        return field_76757_N;
    }

    public int func_180627_b(BlockPos pos) {
        double var1 = MathHelper.func_76131_a((float)this.func_180626_a(pos), (float)0.0f, (float)1.0f);
        double var3 = MathHelper.func_76131_a((float)this.func_76727_i(), (float)0.0f, (float)1.0f);
        return ((ColorizerGrass.func_77480_a((double)var1, (double)var3) & 0xFEFEFE) + 1969742) / 2;
    }

    public int func_180625_c(BlockPos pos) {
        double var1 = MathHelper.func_76131_a((float)this.func_180626_a(pos), (float)0.0f, (float)1.0f);
        double var3 = MathHelper.func_76131_a((float)this.func_76727_i(), (float)0.0f, (float)1.0f);
        return ((ColorizerFoliage.func_77470_a((double)var1, (double)var3) & 0xFEFEFE) + 1969742) / 2;
    }

    public List<Biome.SpawnListEntry> func_76747_a(EnumCreatureType par1EnumCreatureType) {
        if (par1EnumCreatureType == EnumCreatureType.MONSTER) {
            return this.monsterRNG.nextInt(20) == 0 ? this.field_76761_J : Lists.newArrayList();
        }
        return par1EnumCreatureType == EnumCreatureType.CREATURE ? this.field_76762_K : (par1EnumCreatureType == EnumCreatureType.WATER_CREATURE ? this.field_76755_L : (par1EnumCreatureType == EnumCreatureType.AMBIENT ? this.field_82914_M : null));
    }

    public boolean func_76736_e() {
        return true;
    }

    @Override
    protected ResourceLocation getRequiredAchievement() {
        return new ResourceLocation("twilightforest", "progress_hydra");
    }

    @Override
    public void enforceProgession(EntityPlayer player, World world) {
        if (!world.field_72995_K && player.field_70173_aa % 60 == 0) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 100, 0));
            if (world.field_73012_v.nextInt(4) == 0) {
                TFFeature.tfStronghold.trySpawnHintMonster(world, player);
            }
        }
    }
}

