/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.biomes;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeForest;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.feature.WorldGenPumpkin;
import twilightforest.biomes.TFBiomeBase;
import twilightforest.block.BlockTFPlant;
import twilightforest.block.TFBlocks;
import twilightforest.block.enums.PlantVariant;
import twilightforest.world.TFGenHangingLamps;
import twilightforest.world.TFGenLampposts;
import twilightforest.world.TFGenTallGrass;
import twilightforest.world.TFWorld;

public class TFBiomeFireflyForest
extends TFBiomeBase {
    private static final int LAMPPOST_CHANCE = 4;
    private TFGenHangingLamps tfGenHangingLamps;
    private TFGenLampposts tfGenLampposts;
    private TFGenTallGrass worldGenMushgloom = new TFGenTallGrass(TFBlocks.plant.func_176223_P().func_177226_a(BlockTFPlant.VARIANT, (Comparable)((Object)PlantVariant.MUSHGLOOM)));

    public TFBiomeFireflyForest(Biome.BiomeProperties props) {
        super(props);
        this.tfGenHangingLamps = new TFGenHangingLamps();
        this.tfGenLampposts = new TFGenLampposts();
        this.field_76760_I.field_76802_A = 4;
        this.field_76760_I.field_76803_B = 1;
        this.getTFBiomeDecorator().setTreesPerChunk(2);
    }

    public void func_180624_a(World world, Random rand, BlockPos pos) {
        int ry;
        int rz;
        int rx;
        int flowerCycles = rand.nextInt(3) - 1;
        ((BiomeForest)Biomes.field_185444_T).func_185378_a(world, rand, pos, flowerCycles);
        super.func_180624_a(world, rand, pos);
        if (rand.nextInt(24) == 0) {
            rx = pos.func_177958_n() + rand.nextInt(16) + 8;
            rz = pos.func_177952_p() + rand.nextInt(16) + 8;
            ry = this.getGroundLevel(world, new BlockPos(rx, 0, rz));
            this.worldGenMushgloom.func_180709_b(world, rand, new BlockPos(rx, ry, rz));
        }
        for (int i = 0; i < 30; ++i) {
            int rx2 = pos.func_177958_n() + rand.nextInt(16) + 8;
            int rz2 = pos.func_177952_p() + rand.nextInt(16) + 8;
            int ry2 = TFWorld.SEALEVEL + rand.nextInt(TFWorld.CHUNKHEIGHT - TFWorld.SEALEVEL);
            this.tfGenHangingLamps.func_180709_b(world, rand, new BlockPos(rx2, ry2, rz2));
        }
        if (rand.nextInt(4) == 0) {
            rx = pos.func_177958_n() + rand.nextInt(16) + 8;
            rz = pos.func_177952_p() + rand.nextInt(16) + 8;
            ry = this.getGroundLevel(world, new BlockPos(rx, 0, rz));
            this.tfGenLampposts.func_180709_b(world, rand, new BlockPos(rx, ry, rz));
        }
        if (rand.nextInt(32) == 0) {
            rx = pos.func_177958_n() + rand.nextInt(16) + 8;
            rz = pos.func_177952_p() + rand.nextInt(16) + 8;
            ry = this.getGroundLevel(world, new BlockPos(rx, 0, rz));
            new WorldGenPumpkin().func_180709_b(world, rand, new BlockPos(rx, ry, rz));
        }
    }

    private int getGroundLevel(World world, BlockPos pos) {
        Chunk chunk = world.func_175726_f(pos);
        int lastDirt = TFWorld.SEALEVEL;
        for (int y = TFWorld.SEALEVEL; y < TFWorld.CHUNKHEIGHT - 1; ++y) {
            Block block = chunk.func_177435_g(new BlockPos(pos.func_177958_n(), y, pos.func_177952_p())).func_177230_c();
            if (block == Blocks.field_150349_c) {
                return y + 1;
            }
            if (block != Blocks.field_150346_d && block != Blocks.field_150348_b && block != Blocks.field_150351_n) continue;
            lastDirt = y + 1;
        }
        return lastDirt;
    }
}

