/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import twilightforest.TFPacketHandler;
import twilightforest.biomes.TFBiomes;
import twilightforest.block.BlockTFMagicLog;
import twilightforest.block.TFBlocks;
import twilightforest.block.enums.MagicWoodVariant;
import twilightforest.item.ItemTFOreMagnet;
import twilightforest.item.TFItems;
import twilightforest.network.PacketChangeBiome;

public class BlockTFMagicLogSpecial
extends BlockTFMagicLog {
    protected BlockTFMagicLogSpecial() {
        this.func_149647_a(TFItems.creativeTab);
    }

    public int func_149738_a(World par1World) {
        return 20;
    }

    public void func_176213_c(World par1World, BlockPos pos, IBlockState state) {
        par1World.func_175684_a(pos, (Block)this, this.func_149738_a(par1World));
    }

    public Item func_180660_a(IBlockState state, Random par2Random, int par3) {
        return Item.func_150898_a((Block)TFBlocks.magicLog);
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return ((MagicWoodVariant)((Object)state.func_177229_b((IProperty)VARIANT))).ordinal();
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (state.func_177229_b((IProperty)field_176299_a) != BlockLog.EnumAxis.NONE) {
            return;
        }
        if (!world.field_72995_K && state.func_177229_b((IProperty)VARIANT) == MagicWoodVariant.TIME) {
            world.func_184133_a(null, pos, SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.1f, 0.5f);
            this.doTreeOfTimeEffect(world, pos, rand);
        } else if (!world.field_72995_K && state.func_177229_b((IProperty)VARIANT) == MagicWoodVariant.TRANS) {
            this.doTreeOfTransformationEffect(world, pos, rand);
        } else if (!world.field_72995_K && state.func_177229_b((IProperty)VARIANT) == MagicWoodVariant.MINE) {
            this.doMinersTreeEffect(world, pos, rand);
        } else if (!world.field_72995_K && state.func_177229_b((IProperty)VARIANT) == MagicWoodVariant.SORT) {
            this.doSortingTreeEffect(world, pos, rand);
        }
        world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer par5EntityPlayer, EnumHand hand, EnumFacing side, float par7, float par8, float par9) {
        if (state.func_177229_b((IProperty)field_176299_a) == BlockLog.EnumAxis.Y) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)field_176299_a, (Comparable)BlockLog.EnumAxis.NONE));
            world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
            return true;
        }
        if (state.func_177229_b((IProperty)field_176299_a) == BlockLog.EnumAxis.NONE) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)field_176299_a, (Comparable)BlockLog.EnumAxis.Y));
            return true;
        }
        return false;
    }

    private void doTreeOfTimeEffect(World world, BlockPos pos, Random rand) {
        int numticks = 24 * this.func_149738_a(world);
        for (int i = 0; i < numticks; ++i) {
            BlockPos dPos = pos.func_177982_a(rand.nextInt(32) - 16, rand.nextInt(32) - 16, rand.nextInt(32) - 16);
            IBlockState thereState = world.func_180495_p(dPos);
            Block thereID = thereState.func_177230_c();
            if (thereID == Blocks.field_150350_a || !thereID.func_149653_t()) continue;
            thereID.func_180650_b(world, dPos, thereState, rand);
        }
    }

    private void doTreeOfTransformationEffect(World world, BlockPos pos, Random rand) {
        for (int i = 0; i < 1; ++i) {
            Biome biomeAt;
            BlockPos dPos = pos.func_177982_a(rand.nextInt(32) - 16, 0, rand.nextInt(32) - 16);
            world.func_184133_a(null, pos, SoundEvents.field_187682_dG, SoundCategory.BLOCKS, 0.1f, rand.nextFloat() * 2.0f);
            if (!(dPos.func_177951_i((Vec3i)pos) < 256.0) || (biomeAt = world.func_180494_b(dPos)) == TFBiomes.enchantedForest) continue;
            Chunk chunkAt = world.func_175726_f(dPos);
            chunkAt.func_76605_m()[(dPos.func_177952_p() & 0xF) << 4 | dPos.func_177958_n() & 0xF] = (byte)Biome.func_185362_a((Biome)TFBiomes.enchantedForest);
            if (!(world instanceof WorldServer)) continue;
            this.sendChangedBiome(world, dPos);
        }
    }

    private void sendChangedBiome(World world, BlockPos pos) {
        PacketChangeBiome message = new PacketChangeBiome(pos, (byte)Biome.func_185362_a((Biome)TFBiomes.enchantedForest));
        NetworkRegistry.TargetPoint targetPoint = new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), 128.0, (double)pos.func_177952_p(), 128.0);
        TFPacketHandler.CHANNEL.sendToAllAround((IMessage)message, targetPoint);
    }

    private void doMinersTreeEffect(World world, BlockPos pos, Random rand) {
        BlockPos dPos = pos.func_177982_a(rand.nextInt(64) - 32, rand.nextInt(64) - 32, rand.nextInt(64) - 32);
        int moved = ItemTFOreMagnet.doMagnet(world, pos, dPos);
        if (moved > 0) {
            world.func_184133_a(null, pos, SoundEvents.field_187534_aX, SoundCategory.BLOCKS, 0.1f, 1.0f);
        }
    }

    private void doSortingTreeEffect(World world, BlockPos pos, Random rand) {
        int slotNum;
        int XSEARCH = 16;
        int YSEARCH = 16;
        int ZSEARCH = 16;
        ArrayList<IInventory> chests = new ArrayList<IInventory>();
        int itemCount = 0;
        for (int sx = pos.func_177958_n() - XSEARCH; sx < pos.func_177958_n() + XSEARCH; ++sx) {
            for (int sy = pos.func_177956_o() - YSEARCH; sy < pos.func_177956_o() + YSEARCH; ++sy) {
                for (int sz = pos.func_177952_p() - ZSEARCH; sz < pos.func_177952_p() + ZSEARCH; ++sz) {
                    ILockableContainer thisChest;
                    BlockPos iterPos = new BlockPos(sx, sy, sz);
                    if (world.func_180495_p(iterPos).func_177230_c() != Blocks.field_150486_ae || (thisChest = Blocks.field_150486_ae.func_180676_d(world, iterPos)) == null || this.checkIfChestsContains(chests, (IInventory)world.func_175625_s(iterPos))) continue;
                    int itemsInChest = 0;
                    for (int i = 0; i < thisChest.func_70302_i_(); ++i) {
                        if (thisChest.func_70301_a(i).func_190926_b()) continue;
                        ++itemsInChest;
                        ++itemCount;
                    }
                    if (itemsInChest <= 0) continue;
                    chests.add((IInventory)thisChest);
                }
            }
        }
        ItemStack beingSorted = ItemStack.field_190927_a;
        int sortedChestNum = -1;
        int sortedSlotNum = -1;
        if (itemCount > 0) {
            int itemNumber = rand.nextInt(itemCount);
            int currentNumber = 0;
            for (int i = 0; i < chests.size(); ++i) {
                IInventory chest = (IInventory)chests.get(i);
                for (slotNum = 0; slotNum < chest.func_70302_i_(); ++slotNum) {
                    ItemStack currentItem = chest.func_70301_a(slotNum);
                    if (currentItem.func_190926_b() || currentNumber++ != itemNumber) continue;
                    beingSorted = currentItem;
                    sortedChestNum = i;
                    sortedSlotNum = slotNum;
                }
            }
        }
        if (!beingSorted.func_190926_b()) {
            int matchChestNum = -1;
            int matchCount = 0;
            for (int chestNum = 0; chestNum < chests.size(); ++chestNum) {
                IInventory chest = (IInventory)chests.get(chestNum);
                int currentChestMatches = 0;
                for (int slotNum2 = 0; slotNum2 < chest.func_70302_i_(); ++slotNum2) {
                    ItemStack currentItem = chest.func_70301_a(slotNum2);
                    if (currentItem.func_190926_b() || !this.isSortingMatch(beingSorted, currentItem)) continue;
                    currentChestMatches += currentItem.func_190916_E();
                }
                if (currentChestMatches <= matchCount) continue;
                matchCount = currentChestMatches;
                matchChestNum = chestNum;
            }
            if (matchChestNum >= 0 && matchChestNum != sortedChestNum) {
                IInventory moveChest = (IInventory)chests.get(matchChestNum);
                IInventory oldChest = (IInventory)chests.get(sortedChestNum);
                int moveSlot = this.getEmptySlotIn(moveChest);
                if (moveSlot >= 0) {
                    oldChest.func_70299_a(sortedSlotNum, ItemStack.field_190927_a);
                    moveChest.func_70299_a(moveSlot, beingSorted);
                }
            }
            if (beingSorted.func_190916_E() < beingSorted.func_77976_d()) {
                for (IInventory chest : chests) {
                    for (slotNum = 0; slotNum < chest.func_70302_i_(); ++slotNum) {
                        ItemStack currentItem = chest.func_70301_a(slotNum);
                        if (currentItem.func_190926_b() || currentItem == beingSorted || !beingSorted.func_77969_a(currentItem) || currentItem.func_190916_E() > beingSorted.func_77976_d() - beingSorted.func_190916_E()) continue;
                        chest.func_70299_a(slotNum, ItemStack.field_190927_a);
                        beingSorted.func_190917_f(currentItem.func_190916_E());
                        currentItem.func_190920_e(0);
                    }
                }
            }
        }
    }

    private boolean isSortingMatch(ItemStack beingSorted, ItemStack currentItem) {
        return beingSorted.func_77973_b().func_77640_w() == currentItem.func_77973_b().func_77640_w();
    }

    private boolean checkIfChestsContains(ArrayList<IInventory> chests, IInventory testChest) {
        for (IInventory chest : chests) {
            if (chest == testChest) {
                return true;
            }
            if (!(chest instanceof InventoryLargeChest) || !((InventoryLargeChest)chest).func_90010_a(testChest)) continue;
            return true;
        }
        return false;
    }

    private int getEmptySlotIn(IInventory chest) {
        for (int i = 0; i < chest.func_70302_i_(); ++i) {
            if (!chest.func_70301_a(i).func_190926_b()) continue;
            return i;
        }
        return -1;
    }

    @Deprecated
    public int func_149750_m(IBlockState state) {
        return 15;
    }

    @Override
    public void func_149666_a(CreativeTabs par2CreativeTabs, NonNullList<ItemStack> par3List) {
        par3List.add((Object)new ItemStack((Block)this, 1, 0));
        par3List.add((Object)new ItemStack((Block)this, 1, 1));
        par3List.add((Object)new ItemStack((Block)this, 1, 2));
        par3List.add((Object)new ItemStack((Block)this, 1, 3));
    }

    protected boolean func_149700_E() {
        return false;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }
}

