/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBreakable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import twilightforest.TFConfig;
import twilightforest.TFTeleporter;
import twilightforest.TwilightForestMod;
import twilightforest.block.TFBlocks;

public class BlockTFPortal
extends BlockBreakable {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.8125, 1.0);

    public BlockTFPortal() {
        super(Material.field_151567_E, false);
        this.func_149711_c(-1.0f);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149715_a(0.75f);
    }

    @Deprecated
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return AABB;
    }

    @Deprecated
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean tryToCreatePortal(World world, BlockPos pos, EntityItem activationItem) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == Blocks.field_150355_j) {
            HashMap<BlockPos, Boolean> blocksChecked = new HashMap<BlockPos, Boolean>();
            blocksChecked.put(pos, true);
            PassableNumber number = new PassableNumber(64);
            if (BlockTFPortal.recursivelyValidatePortal(world, pos, blocksChecked, number) && number.getNumber() > 3) {
                activationItem.func_92059_d().func_190918_g(1);
                world.func_72942_c((Entity)new EntityLightningBolt(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), false));
                for (Map.Entry<BlockPos, Boolean> checkedPos : blocksChecked.entrySet()) {
                    if (!checkedPos.getValue().booleanValue()) continue;
                    world.func_180501_a(checkedPos.getKey(), TFBlocks.portal.func_176223_P(), 2);
                }
                return true;
            }
        }
        return false;
    }

    private static boolean recursivelyValidatePortal(World world, BlockPos pos, HashMap<BlockPos, Boolean> blocksChecked, PassableNumber waterLimit) {
        boolean isPoolProbablyEnclosed = true;
        waterLimit.decrement();
        if (waterLimit.getNumber() < 0) {
            return false;
        }
        for (int i = 0; i < EnumFacing.field_176754_o.length && waterLimit.getNumber() >= 0; ++i) {
            BlockPos positionCheck = pos.func_177972_a(EnumFacing.field_176754_o[i]);
            if (blocksChecked.containsKey(positionCheck)) continue;
            IBlockState state = world.func_180495_p(positionCheck);
            if (state == Blocks.field_150355_j.func_176223_P() && world.func_180495_p(positionCheck.func_177977_b()).func_185904_a().func_76220_a()) {
                blocksChecked.put(positionCheck, true);
                isPoolProbablyEnclosed = isPoolProbablyEnclosed && BlockTFPortal.recursivelyValidatePortal(world, positionCheck, blocksChecked, waterLimit);
                continue;
            }
            if (BlockTFPortal.isGrassOrDirt(state) && BlockTFPortal.isNatureBlock(world.func_180495_p(positionCheck.func_177984_a()))) {
                blocksChecked.put(positionCheck, false);
                continue;
            }
            return false;
        }
        return isPoolProbablyEnclosed;
    }

    private static boolean isNatureBlock(IBlockState state) {
        Material mat = state.func_185904_a();
        return mat == Material.field_151585_k || mat == Material.field_151582_l || mat == Material.field_151584_j;
    }

    @Deprecated
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block notUsed, BlockPos fromPos) {
        boolean good = world.func_180495_p(pos.func_177977_b()).func_185904_a().func_76220_a();
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            if (!good) break;
            IBlockState neighboringState = world.func_180495_p(pos.func_177972_a(facing));
            good = BlockTFPortal.isGrassOrDirt(neighboringState) || neighboringState.func_177230_c() == TFBlocks.portal;
        }
        if (!good) {
            world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
            world.func_180501_a(pos, Blocks.field_150355_j.func_176223_P(), 3);
        }
    }

    private static boolean isGrassOrDirt(IBlockState state) {
        return state.func_185904_a() == Material.field_151577_b || state.func_185904_a() == Material.field_151578_c;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!entity.func_184218_aH() && entity.func_184188_bt().isEmpty() && entity.field_71088_bW <= 0) {
            if (entity instanceof EntityPlayerMP) {
                EntityPlayerMP playerMP = (EntityPlayerMP)entity;
                if (playerMP.field_71088_bW > 0) {
                    playerMP.field_71088_bW = 10;
                } else if (playerMP.field_71093_bK != TFConfig.dimension.dimensionID) {
                    if (!ForgeHooks.onTravelToDimension((Entity)playerMP, (int)TFConfig.dimension.dimensionID)) {
                        return;
                    }
                    TwilightForestMod.LOGGER.debug("Player touched the portal block.  Sending the player to dimension {}", (Object)TFConfig.dimension.dimensionID);
                    playerMP.field_71133_b.func_184103_al().transferPlayerToDimension(playerMP, TFConfig.dimension.dimensionID, (Teleporter)TFTeleporter.getTeleporterForDim(playerMP.field_71133_b, TFConfig.dimension.dimensionID));
                    playerMP.setSpawnChunk(new BlockPos((Entity)playerMP), true, TFConfig.dimension.dimensionID);
                } else {
                    if (!ForgeHooks.onTravelToDimension((Entity)playerMP, (int)0)) {
                        return;
                    }
                    playerMP.field_71133_b.func_184103_al().transferPlayerToDimension(playerMP, 0, (Teleporter)TFTeleporter.getTeleporterForDim(playerMP.field_71133_b, 0));
                }
            } else if (entity.field_71093_bK != TFConfig.dimension.dimensionID) {
                this.changeDimension(entity, TFConfig.dimension.dimensionID);
            } else {
                this.changeDimension(entity, 0);
            }
        }
    }

    private void changeDimension(Entity toTeleport, int dimensionIn) {
        if (!toTeleport.field_70170_p.field_72995_K && !toTeleport.field_70128_L) {
            BlockPos blockpos;
            if (!ForgeHooks.onTravelToDimension((Entity)toTeleport, (int)dimensionIn)) {
                return;
            }
            toTeleport.field_70170_p.field_72984_F.func_76320_a("changeDimension");
            MinecraftServer minecraftserver = toTeleport.func_184102_h();
            int i = toTeleport.field_71093_bK;
            WorldServer worldserver = minecraftserver.func_71218_a(i);
            WorldServer worldserver1 = minecraftserver.func_71218_a(dimensionIn);
            toTeleport.field_71093_bK = dimensionIn;
            if (i == 1 && dimensionIn == 1) {
                worldserver1 = minecraftserver.func_71218_a(0);
                toTeleport.field_71093_bK = 0;
            }
            toTeleport.field_70170_p.func_72900_e(toTeleport);
            toTeleport.field_70128_L = false;
            toTeleport.field_70170_p.field_72984_F.func_76320_a("reposition");
            if (dimensionIn == 1) {
                blockpos = worldserver1.func_180504_m();
            } else {
                double d0 = toTeleport.field_70165_t;
                double d1 = toTeleport.field_70161_v;
                double d2 = 8.0;
                d0 = MathHelper.func_151237_a((double)d0, (double)(worldserver1.func_175723_af().func_177726_b() + 16.0), (double)(worldserver1.func_175723_af().func_177728_d() - 16.0));
                d1 = MathHelper.func_151237_a((double)d1, (double)(worldserver1.func_175723_af().func_177736_c() + 16.0), (double)(worldserver1.func_175723_af().func_177733_e() - 16.0));
                d0 = MathHelper.func_76125_a((int)((int)d0), (int)-29999872, (int)29999872);
                d1 = MathHelper.func_76125_a((int)((int)d1), (int)-29999872, (int)29999872);
                float f = toTeleport.field_70177_z;
                toTeleport.func_70012_b(d0, toTeleport.field_70163_u, d1, 90.0f, 0.0f);
                TFTeleporter teleporter = TFTeleporter.getTeleporterForDim(minecraftserver, dimensionIn);
                teleporter.func_180620_b(toTeleport, f);
                blockpos = new BlockPos(toTeleport);
            }
            worldserver.func_72866_a(toTeleport, false);
            toTeleport.field_70170_p.field_72984_F.func_76318_c("reloading");
            Entity entity = EntityList.func_191304_a(toTeleport.getClass(), (World)worldserver1);
            if (entity != null) {
                entity.func_180432_n(toTeleport);
                if (i == 1 && dimensionIn == 1) {
                    BlockPos blockpos1 = worldserver1.func_175672_r(worldserver1.func_175694_M());
                    entity.func_174828_a(blockpos1, entity.field_70177_z, entity.field_70125_A);
                } else {
                    entity.func_70012_b((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), entity.field_70177_z, entity.field_70125_A);
                }
                boolean flag = entity.field_98038_p;
                entity.field_98038_p = true;
                worldserver1.func_72838_d(entity);
                entity.field_98038_p = flag;
                worldserver1.func_72866_a(entity, false);
            }
            toTeleport.field_70128_L = true;
            toTeleport.field_70170_p.field_72984_F.func_76319_b();
            worldserver.func_82742_i();
            worldserver1.func_82742_i();
            toTeleport.field_70170_p.field_72984_F.func_76319_b();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (rand.nextInt(100) == 0) {
            worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187810_eg, SoundCategory.BLOCKS, 0.5f, rand.nextFloat() * 0.4f + 0.8f, false);
        }
        for (int i = 0; i < 4; ++i) {
            double d0 = (float)pos.func_177958_n() + rand.nextFloat();
            double d1 = (float)pos.func_177956_o() + rand.nextFloat();
            double d2 = (float)pos.func_177952_p() + rand.nextFloat();
            double d3 = ((double)rand.nextFloat() - 0.5) * 0.5;
            double d4 = ((double)rand.nextFloat() - 0.5) * 0.5;
            double d5 = ((double)rand.nextFloat() - 0.5) * 0.5;
            int j = rand.nextInt(2) * 2 - 1;
            if (worldIn.func_180495_p(pos.func_177976_e()).func_177230_c() != this && worldIn.func_180495_p(pos.func_177974_f()).func_177230_c() != this) {
                d0 = (double)pos.func_177958_n() + 0.5 + 0.25 * (double)j;
                d3 = rand.nextFloat() * 2.0f * (float)j;
            } else {
                d2 = (double)pos.func_177952_p() + 0.5 + 0.25 * (double)j;
                d5 = rand.nextFloat() * 2.0f * (float)j;
            }
            worldIn.func_175688_a(EnumParticleTypes.PORTAL, d0, d1, d2, d3, d4, d5, new int[0]);
        }
    }

    private static class PassableNumber {
        private int number;

        PassableNumber(int number) {
            this.number = number;
        }

        int getNumber() {
            return this.number;
        }

        void decrement() {
            --this.number;
        }

        void setNumber(int number) {
            this.number = number;
        }
    }
}

