/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSkull;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import twilightforest.TFSounds;
import twilightforest.block.enums.BossVariant;
import twilightforest.client.ModelRegisterCallback;
import twilightforest.item.TFItems;
import twilightforest.tileentity.TileEntityTFTrophy;

public class BlockTFTrophy
extends BlockSkull
implements ModelRegisterCallback {
    private static final AxisAlignedBB HYDRA_Y_BB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.5, 0.75);
    private static final AxisAlignedBB HYDRA_EAST_BB = new AxisAlignedBB(0.0, 0.25, 0.25, 0.5, 0.75, 0.75);
    private static final AxisAlignedBB HYDRA_WEST_BB = new AxisAlignedBB(0.5, 0.25, 0.25, 1.0, 0.75, 0.75);
    private static final AxisAlignedBB HYDRA_SOUTH_BB = new AxisAlignedBB(0.25, 0.25, 0.0, 0.75, 0.75, 0.5);
    private static final AxisAlignedBB HYDRA_NORTH_BB = new AxisAlignedBB(0.25, 0.25, 0.5, 0.75, 0.75, 1.0);
    private static final AxisAlignedBB URGHAST_BB = new AxisAlignedBB(0.25, 0.5, 0.25, 0.75, 1.0, 0.75);

    public BlockTFTrophy() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BlockSkull.field_176417_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockSkull.field_176418_a, (Comparable)EnumFacing.UP));
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess par1IBlockAccess, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockSkull.field_176418_a);
        TileEntityTFTrophy trophy = (TileEntityTFTrophy)par1IBlockAccess.func_175625_s(pos);
        if (trophy != null && trophy.func_145904_a() == 0) {
            switch (facing) {
                default: {
                    return HYDRA_Y_BB;
                }
                case NORTH: {
                    return HYDRA_NORTH_BB;
                }
                case SOUTH: {
                    return HYDRA_SOUTH_BB;
                }
                case WEST: {
                    return HYDRA_WEST_BB;
                }
                case EAST: 
            }
            return HYDRA_EAST_BB;
        }
        if (trophy != null && trophy.func_145904_a() == 3) {
            return URGHAST_BB;
        }
        return super.func_185496_a(state, par1IBlockAccess, pos);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityTFTrophy) {
            SoundEvent sound = null;
            float volume = 1.0f;
            switch (BossVariant.getVariant(((TileEntityTFTrophy)te).func_145904_a())) {
                case NAGA: {
                    sound = TFSounds.NAGA_RATTLE;
                    volume = 1.25f;
                    break;
                }
                case LICH: {
                    sound = SoundEvents.field_187594_A;
                    volume = 0.35f;
                    break;
                }
                case HYDRA: {
                    sound = TFSounds.HYDRA_GROWL;
                    break;
                }
                case UR_GHAST: {
                    sound = SoundEvents.field_187551_bH;
                    break;
                }
                case SNOW_QUEEN: {
                    sound = TFSounds.ICE_AMBIENT;
                    break;
                }
                case KNIGHT_PHANTOM: {
                    sound = TFSounds.WRAITH;
                    break;
                }
                case MINOSHROOM: {
                    sound = SoundEvents.field_187558_ak;
                    volume = 0.5f;
                    break;
                }
                case QUEST_RAM: {
                    sound = SoundEvents.field_187757_eG;
                }
            }
            if (sound != null) {
                worldIn.func_184133_a(playerIn, pos, sound, SoundCategory.BLOCKS, volume, 16.0f);
            }
        }
        return true;
    }

    public TileEntity createTileEntity(World var1, IBlockState state) {
        return new TileEntityTFTrophy();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityTFTrophy) {
            return new ItemStack(TFItems.trophy, 1, ((TileEntityTFTrophy)te).func_145904_a());
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityTFTrophy) {
            return new ItemStack(TFItems.trophy, 1, ((TileEntityTFTrophy)te).func_145904_a());
        }
        return ItemStack.field_190927_a;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return TFItems.trophy;
    }

    public List<ItemStack> getDrops(IBlockAccess worldIn, BlockPos pos, IBlockState state, int fortune) {
        TileEntity tileentity;
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (!((Boolean)state.func_177229_b((IProperty)field_176417_b)).booleanValue() && (tileentity = worldIn.func_175625_s(pos)) instanceof TileEntitySkull) {
            TileEntitySkull tileentityskull = (TileEntitySkull)tileentity;
            ItemStack itemstack = new ItemStack(TFItems.trophy, 1, tileentityskull.func_145904_a());
            ret.add(itemstack);
        }
        return ret;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel() {
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{field_176417_b}).func_178442_a(new IProperty[]{field_176418_a}).func_178441_a());
    }
}

