/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block.enums;

import java.util.Locale;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.util.IStringSerializable;
import twilightforest.tileentity.TileEntityTFAlphaYetiSpawner;
import twilightforest.tileentity.TileEntityTFBossSpawner;
import twilightforest.tileentity.TileEntityTFHydraSpawner;
import twilightforest.tileentity.TileEntityTFKnightPhantomsSpawner;
import twilightforest.tileentity.TileEntityTFLichSpawner;
import twilightforest.tileentity.TileEntityTFMinoshroomSpawner;
import twilightforest.tileentity.TileEntityTFNagaSpawner;
import twilightforest.tileentity.TileEntityTFSnowQueenSpawner;
import twilightforest.tileentity.TileEntityTFTowerBossSpawner;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public enum BossVariant implements IStringSerializable
{
    NAGA(true, TrophyType.GOLD, TileEntityTFNagaSpawner.class),
    LICH(true, TrophyType.GOLD, TileEntityTFLichSpawner.class),
    HYDRA(true, TrophyType.GOLD, TileEntityTFHydraSpawner.class),
    UR_GHAST(true, TrophyType.GOLD, TileEntityTFTowerBossSpawner.class),
    KNIGHT_PHANTOM(false, TrophyType.IRON, TileEntityTFKnightPhantomsSpawner.class),
    SNOW_QUEEN(true, TrophyType.GOLD, TileEntityTFSnowQueenSpawner.class),
    MINOSHROOM(false, TrophyType.IRON, TileEntityTFMinoshroomSpawner.class),
    ALPHA_YETI(false, TrophyType.IRON, TileEntityTFAlphaYetiSpawner.class),
    QUEST_RAM(false, TrophyType.IRONWOOD, null);

    private final boolean isMajorBoss;
    private final Class<? extends TileEntityTFBossSpawner> spawnerClass;
    private final TrophyType trophyType;
    public static final BossVariant[] VARIANTS;

    private BossVariant(@Nullable boolean isMajorBoss, TrophyType trophyType, Class<? extends TileEntityTFBossSpawner> spawnerClass) {
        this.isMajorBoss = isMajorBoss;
        this.spawnerClass = spawnerClass;
        this.trophyType = trophyType;
    }

    public String func_176610_l() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public TrophyType getTrophyType() {
        return this.trophyType;
    }

    public boolean usesGoldBackground() {
        return this.isMajorBoss;
    }

    @Nullable
    public Class<? extends TileEntityTFBossSpawner> getSpawnerClass() {
        return this.spawnerClass;
    }

    public static BossVariant getVariant(int id) {
        return id >= 0 && id < VARIANTS.length ? VARIANTS[id] : NAGA;
    }

    static {
        VARIANTS = BossVariant.values();
    }

    public static enum TrophyType {
        GOLD("trophy"),
        IRON("trophy_minor"),
        IRONWOOD("trophy_quest");

        private final String modelName;

        private TrophyType(String modelName) {
            this.modelName = modelName;
        }

        public String getModelName() {
            return this.modelName;
        }
    }
}

