/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import twilightforest.entity.ITFCharger;

public class EntityAITFChargeAttack
extends EntityAIBase {
    private static final double MIN_RANGE_SQ = 16.0;
    private static final double MAX_RANGE_SQ = 64.0;
    private static final int FREQ = 1;
    private EntityCreature charger;
    private EntityLivingBase chargeTarget;
    private double chargeX;
    private double chargeY;
    private double chargeZ;
    protected float speed;
    private int windup;
    private boolean hasAttacked;

    public EntityAITFChargeAttack(EntityCreature entityLiving, float f) {
        this.charger = entityLiving;
        this.speed = f;
        this.windup = 0;
        this.hasAttacked = false;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        this.chargeTarget = this.charger.func_70638_az();
        if (this.chargeTarget == null) {
            return false;
        }
        double distance = this.charger.func_70068_e((Entity)this.chargeTarget);
        if (distance < 16.0 || distance > 64.0) {
            return false;
        }
        if (!this.charger.field_70122_E) {
            return false;
        }
        Vec3d chargePos = this.findChargePoint((Entity)this.charger, (Entity)this.chargeTarget, 2.1);
        boolean canSeeTargetFromDest = this.charger.func_70635_at().func_75522_a((Entity)this.chargeTarget);
        if (!canSeeTargetFromDest) {
            return false;
        }
        this.chargeX = chargePos.field_72450_a;
        this.chargeY = chargePos.field_72448_b;
        this.chargeZ = chargePos.field_72449_c;
        return this.charger.func_70681_au().nextInt(1) == 0;
    }

    public void func_75249_e() {
        this.windup = 15 + this.charger.func_70681_au().nextInt(30);
    }

    public boolean func_75253_b() {
        return this.windup > 0 || !this.charger.func_70661_as().func_75500_f();
    }

    public void func_75246_d() {
        this.charger.func_70671_ap().func_75650_a(this.chargeX, this.chargeY - 1.0, this.chargeZ, 10.0f, (float)this.charger.func_70646_bf());
        if (this.windup > 0) {
            if (--this.windup == 0) {
                this.charger.func_70661_as().func_75492_a(this.chargeX, this.chargeY, this.chargeZ, (double)this.speed);
            } else {
                this.charger.field_70721_aZ = (float)((double)this.charger.field_70721_aZ + 0.8);
                if (this.charger instanceof ITFCharger) {
                    ((ITFCharger)this.charger).setCharging(true);
                }
            }
        }
        double var1 = this.charger.field_70130_N * 2.1f * this.charger.field_70130_N * 2.1f;
        if (this.charger.func_70092_e(this.chargeTarget.field_70165_t, this.chargeTarget.func_174813_aQ().field_72338_b, this.chargeTarget.field_70161_v) <= var1 && !this.hasAttacked) {
            this.hasAttacked = true;
            this.charger.func_70652_k((Entity)this.chargeTarget);
        }
    }

    public void func_75251_c() {
        this.windup = 0;
        this.chargeTarget = null;
        this.hasAttacked = false;
        if (this.charger instanceof ITFCharger) {
            ((ITFCharger)this.charger).setCharging(false);
        }
    }

    protected Vec3d findChargePoint(Entity attacker, Entity target, double overshoot) {
        double vecx = target.field_70165_t - attacker.field_70165_t;
        double vecz = target.field_70161_v - attacker.field_70161_v;
        float rangle = (float)Math.atan2(vecz, vecx);
        double distance = MathHelper.func_76133_a((double)(vecx * vecx + vecz * vecz));
        double dx = (double)MathHelper.func_76134_b((float)rangle) * (distance + overshoot);
        double dz = (double)MathHelper.func_76126_a((float)rangle) * (distance + overshoot);
        return new Vec3d(attacker.field_70165_t + dx, target.field_70163_u, attacker.field_70161_v + dz);
    }
}

