/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import twilightforest.block.TFBlocks;
import twilightforest.entity.EntityTFMoonwormShot;
import twilightforest.item.ItemTF;
import twilightforest.item.TFItems;

public class ItemTFMoonwormQueen
extends ItemTF {
    private static final int FIRING_TIME = 12;

    protected ItemTFMoonwormQueen() {
        this.func_77637_a(TFItems.creativeTab);
        this.field_77777_bU = 1;
        this.func_77656_e(256);
        this.func_185043_a(new ResourceLocation("twilightforest", "alt"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                int useTime;
                if (entityIn != null && entityIn.func_184607_cu().func_77973_b() == TFItems.moonwormQueen && (useTime = stack.func_77988_m() - entityIn.func_184605_cv()) >= 12 && (useTime >>> 1) % 2 == 0) {
                    return 1.0f;
                }
                return 0.0f;
            }
        });
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77952_i() == stack.func_77958_k()) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
        }
        player.func_184598_c(hand);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack itemstack;
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if (!block.func_176200_f((IBlockAccess)worldIn, pos)) {
            pos = pos.func_177972_a(facing);
        }
        if (!(itemstack = player.func_184586_b(hand)).func_190926_b() && player.func_175151_a(pos, facing, itemstack) && worldIn.func_190527_a(TFBlocks.moonworm, pos, false, facing, (Entity)null)) {
            int i = this.func_77647_b(itemstack.func_77960_j());
            IBlockState iblockstate1 = TFBlocks.moonworm.getStateForPlacement(worldIn, pos, facing, hitX, hitY, hitZ, i, (EntityLivingBase)player, hand);
            if (this.placeMoonwormAt(itemstack, player, worldIn, pos, facing, hitX, hitY, hitZ, iblockstate1)) {
                SoundType soundtype = worldIn.func_180495_p(pos).func_177230_c().getSoundType(worldIn.func_180495_p(pos), worldIn, pos, (Entity)player);
                worldIn.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                itemstack.func_77972_a(1, (EntityLivingBase)player);
                player.func_184602_cy();
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    private boolean placeMoonwormAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState state) {
        if (!world.func_180501_a(pos, state, 11)) {
            return false;
        }
        IBlockState real = world.func_180495_p(pos);
        if (real.func_177230_c() == TFBlocks.moonworm) {
            TFBlocks.moonworm.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
        }
        return true;
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase living, int useRemaining) {
        boolean fired;
        int useTime = this.func_77626_a(stack) - useRemaining;
        if (!world.field_72995_K && useTime > 12 && stack.func_77952_i() + 1 < stack.func_77958_k() && (fired = world.func_72838_d((Entity)new EntityTFMoonwormShot(world, living)))) {
            stack.func_77972_a(2, living);
            world.func_184148_a(null, living.field_70165_t, living.field_70163_u, living.field_70161_v, SoundEvents.field_187878_fo, living instanceof EntityPlayer ? SoundCategory.PLAYERS : SoundCategory.NEUTRAL, 1.0f, 1.0f);
        }
    }

    @Nonnull
    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 72000;
    }
}

