/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import twilightforest.item.ItemTF;
import twilightforest.item.TFItems;

public class ItemTFScepterLifeDrain
extends ItemTF {
    protected ItemTFScepterLifeDrain() {
        this.field_77777_bU = 1;
        this.func_77656_e(99);
        this.func_77637_a(TFItems.creativeTab);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        player.func_184598_c(hand);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    private static void animateTargetShatter(World world, EntityLivingBase target) {
        for (int var1 = 0; var1 < 50; ++var1) {
            double gaussX = field_77697_d.nextGaussian() * 0.02;
            double gaussY = field_77697_d.nextGaussian() * 0.02;
            double gaussZ = field_77697_d.nextGaussian() * 0.02;
            double gaussFactor = 10.0;
            Item popItem = ItemTFScepterLifeDrain.getTargetDropItemId(target) != null ? ItemTFScepterLifeDrain.getTargetDropItemId(target) : Items.field_151078_bh;
            world.func_175688_a(EnumParticleTypes.ITEM_CRACK, target.field_70165_t + (double)(field_77697_d.nextFloat() * target.field_70130_N * 2.0f) - (double)target.field_70130_N - gaussX * gaussFactor, target.field_70163_u + (double)(field_77697_d.nextFloat() * target.field_70131_O) - gaussY * gaussFactor, target.field_70161_v + (double)(field_77697_d.nextFloat() * target.field_70130_N * 2.0f) - (double)target.field_70130_N - gaussZ * gaussFactor, gaussX, gaussY, gaussZ, new int[]{Item.func_150891_b((Item)popItem)});
        }
    }

    private static Item getTargetDropItemId(EntityLivingBase target) {
        return Items.field_151078_bh;
    }

    private Entity getPlayerLookTarget(World world, EntityLivingBase living) {
        Entity pointedEntity = null;
        double range = 20.0;
        Vec3d srcVec = new Vec3d(living.field_70165_t, living.field_70163_u + (double)living.func_70047_e(), living.field_70161_v);
        Vec3d lookVec = living.func_70676_i(1.0f);
        Vec3d destVec = srcVec.func_72441_c(lookVec.field_72450_a * range, lookVec.field_72448_b * range, lookVec.field_72449_c * range);
        float var9 = 1.0f;
        List possibleList = world.func_72839_b((Entity)living, living.func_174813_aQ().func_72321_a(lookVec.field_72450_a * range, lookVec.field_72448_b * range, lookVec.field_72449_c * range).func_72314_b((double)var9, (double)var9, (double)var9));
        double hitDist = 0.0;
        for (Entity possibleEntity : possibleList) {
            double possibleDist;
            if (!possibleEntity.func_70067_L()) continue;
            float borderSize = possibleEntity.func_70111_Y();
            AxisAlignedBB collisionBB = possibleEntity.func_174813_aQ().func_72314_b((double)borderSize, (double)borderSize, (double)borderSize);
            RayTraceResult interceptPos = collisionBB.func_72327_a(srcVec, destVec);
            if (collisionBB.func_72318_a(srcVec)) {
                if (!(0.0 < hitDist) && hitDist != 0.0) continue;
                pointedEntity = possibleEntity;
                hitDist = 0.0;
                continue;
            }
            if (interceptPos == null || !((possibleDist = srcVec.func_72438_d(interceptPos.field_72307_f)) < hitDist) && hitDist != 0.0) continue;
            pointedEntity = possibleEntity;
            hitDist = possibleDist;
        }
        return pointedEntity;
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase living, int count) {
        Entity pointedEntity;
        World world = living.field_70170_p;
        if (stack.func_77952_i() >= this.getMaxDamage(stack)) {
            living.func_184602_cy();
            return;
        }
        if (count % 5 == 0 && (pointedEntity = this.getPlayerLookTarget(world, living)) != null && pointedEntity instanceof EntityLivingBase) {
            EntityLivingBase target = (EntityLivingBase)pointedEntity;
            if (target.func_70660_b(MobEffects.field_76421_d) != null || target.func_110143_aJ() < 1.0f) {
                if (target.func_110143_aJ() <= 3.0f) {
                    this.makeRedMagicTrail(world, living.field_70165_t, living.field_70163_u + (double)living.func_70047_e(), living.field_70161_v, target.field_70165_t, target.field_70163_u + (double)target.func_70047_e(), target.field_70161_v);
                    if (target instanceof EntityLiving) {
                        ((EntityLiving)target).func_70656_aK();
                    }
                    target.func_184185_a(SoundEvents.field_187655_bw, 1.0f, ((field_77697_d.nextFloat() - field_77697_d.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                    ItemTFScepterLifeDrain.animateTargetShatter(world, target);
                    if (!world.field_72995_K) {
                        target.func_70106_y();
                        target.func_70645_a(DamageSource.func_76354_b((Entity)living, (Entity)living));
                    }
                    living.func_184602_cy();
                } else if (!world.field_72995_K) {
                    target.func_70097_a(DamageSource.func_76354_b((Entity)living, (Entity)living), 3.0f);
                    if (this.getMaxHealth(target) <= this.getMaxHealth(living)) {
                        target.field_70159_w = 0.0;
                        target.field_70181_x = 0.2;
                        target.field_70179_y = 0.0;
                    }
                    target.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 20, 2));
                    if (count % 10 == 0) {
                        living.func_70691_i(1.0f);
                        if (living instanceof EntityPlayer) {
                            ((EntityPlayer)living).func_71024_bL().func_75122_a(1, 0.1f);
                        }
                    }
                }
            } else {
                this.makeRedMagicTrail(world, living.field_70165_t, living.field_70163_u + (double)living.func_70047_e(), living.field_70161_v, target.field_70165_t, target.field_70163_u + (double)target.func_70047_e(), target.field_70161_v);
                living.func_184185_a(SoundEvents.field_187649_bu, 1.0f, (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f + 1.0f);
                if (!world.field_72995_K) {
                    target.func_70097_a(DamageSource.func_76354_b((Entity)living, (Entity)living), 1.0f);
                    if (this.getMaxHealth(target) <= this.getMaxHealth(living)) {
                        target.field_70159_w = 0.0;
                        target.field_70181_x = 0.2;
                        target.field_70179_y = 0.0;
                    }
                    target.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 20, 2));
                }
            }
            if (!world.field_72995_K) {
                stack.func_77972_a(1, living);
            }
        }
    }

    private float getMaxHealth(EntityLivingBase target) {
        return (float)target.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b();
    }

    private void makeRedMagicTrail(World world, double srcX, double srcY, double srcZ, double destX, double destY, double destZ) {
        int particles = 32;
        for (int i = 0; i < particles; ++i) {
            double trailFactor = (double)i / ((double)particles - 1.0);
            float f = 1.0f;
            float f1 = 0.5f;
            float f2 = 0.5f;
            double tx = srcX + (destX - srcX) * trailFactor + world.field_73012_v.nextGaussian() * 0.005;
            double ty = srcY + (destY - srcY) * trailFactor + world.field_73012_v.nextGaussian() * 0.005;
            double tz = srcZ + (destZ - srcZ) * trailFactor + world.field_73012_v.nextGaussian() * 0.005;
            world.func_175688_a(EnumParticleTypes.SPELL_MOB, tx, ty, tz, (double)f, (double)f1, (double)f2, new int[0]);
        }
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 72000;
    }

    @Nonnull
    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.BOW;
    }

    @Override
    @Nonnull
    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        return EnumRarity.RARE;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flags) {
        super.func_77624_a(stack, world, tooltip, flags);
        tooltip.add(I18n.func_135052_a((String)"twilightforest.scepter_charges", (Object[])new Object[]{stack.func_77958_k() - stack.func_77952_i()}));
    }
}

