/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraft.world.gen.structure.StructureStrongholdPieces;
import twilightforest.TFFeature;
import twilightforest.TwilightForestMod;
import twilightforest.biomes.TFBiomes;
import twilightforest.block.TFBlockProperties;
import twilightforest.block.TFBlocks;
import twilightforest.structures.ComponentTFHedgeMaze;
import twilightforest.structures.ComponentTFHollowHill;
import twilightforest.structures.ComponentTFHydraLair;
import twilightforest.structures.ComponentTFNagaCourtyard;
import twilightforest.structures.ComponentTFQuestGrove;
import twilightforest.structures.ComponentTFYetiCave;
import twilightforest.structures.darktower.ComponentTFDarkTowerMain;
import twilightforest.structures.darktower.TFDarkTowerPieces;
import twilightforest.structures.finalcastle.ComponentTFFinalCastleMain;
import twilightforest.structures.finalcastle.TFFinalCastlePieces;
import twilightforest.structures.hollowtree.StructureTFHollowTreeStart;
import twilightforest.structures.hollowtree.TFHollowTreePieces;
import twilightforest.structures.icetower.ComponentTFIceTowerMain;
import twilightforest.structures.icetower.TFIceTowerPieces;
import twilightforest.structures.lichtower.ComponentTFTowerMain;
import twilightforest.structures.lichtower.TFLichTowerPieces;
import twilightforest.structures.minotaurmaze.ComponentTFMazeRuins;
import twilightforest.structures.minotaurmaze.TFMinotaurMazePieces;
import twilightforest.structures.mushroomtower.ComponentTFMushroomTowerMain;
import twilightforest.structures.mushroomtower.TFMushroomTowerPieces;
import twilightforest.structures.stronghold.ComponentTFStrongholdEntrance;
import twilightforest.structures.stronghold.TFStrongholdPieces;
import twilightforest.structures.trollcave.ComponentTFTrollCaveMain;
import twilightforest.structures.trollcave.TFTrollCavePieces;
import twilightforest.world.TFBiomeProvider;
import twilightforest.world.TFWorld;

public class StructureTFMajorFeatureStart
extends StructureStart {
    public static int NUM_LOCKS = 4;
    public TFFeature feature;
    public boolean isConquered;
    public byte[] lockBytes = new byte[NUM_LOCKS];

    public StructureTFMajorFeatureStart() {
    }

    public StructureTFMajorFeatureStart(World world, Random rand, int chunkX, int chunkZ) {
        StructureStrongholdPieces.func_75198_a();
        int x = (chunkX << 4) + 8;
        int z = (chunkZ << 4) + 8;
        int y = TFWorld.SEALEVEL + 1;
        this.feature = TFFeature.getFeatureDirectlyAt(chunkX, chunkZ, world);
        this.isConquered = false;
        StructureComponent firstComponent = this.makeFirstComponent(world, rand, this.feature, x, y, z);
        if (firstComponent != null) {
            this.field_75075_a.add(firstComponent);
            firstComponent.func_74861_a(firstComponent, this.field_75075_a, rand);
        }
        this.func_75072_c();
        if (firstComponent instanceof StructureStrongholdPieces.Stairs2) {
            List var6 = ((StructureStrongholdPieces.Stairs2)firstComponent).field_75026_c;
            while (!var6.isEmpty()) {
                int var7 = rand.nextInt(var6.size());
                StructureComponent var8 = (StructureComponent)var6.remove(var7);
                var8.func_74861_a(firstComponent, this.field_75075_a, rand);
            }
            this.func_75072_c();
            int offY = -33;
            this.field_75074_b.func_78886_a(0, offY, 0);
            for (StructureComponent com : this.func_186161_c()) {
                com.func_74874_b().func_78886_a(0, offY, 0);
            }
        }
        if (firstComponent instanceof ComponentTFTowerMain || firstComponent instanceof ComponentTFDarkTowerMain) {
            this.moveToAvgGroundLevel(world, x, z);
        }
    }

    public StructureComponent makeFirstComponent(World world, Random rand, TFFeature feature, int x, int y, int z) {
        if (feature == TFFeature.nagaCourtyard) {
            TwilightForestMod.LOGGER.info("Naga Courtyard @ {} {} {}", (Object)x, (Object)y, (Object)z);
            return new ComponentTFNagaCourtyard(feature, world, rand, 0, x, y, z);
        }
        if (feature == TFFeature.hedgeMaze) {
            TwilightForestMod.LOGGER.info("Hedge Maze @ {} {} {}", (Object)x, (Object)y, (Object)z);
            return new ComponentTFHedgeMaze(feature, world, rand, 0, x, y, z);
        }
        if (feature == TFFeature.hill1) {
            TwilightForestMod.LOGGER.info("Hill 1 @ {} {} {}", (Object)x, (Object)y, (Object)z);
            return new ComponentTFHollowHill(feature, world, rand, 0, 1, x, y, z);
        }
        if (feature == TFFeature.hill2) {
            TwilightForestMod.LOGGER.info("Hill 2 @ {} {} {}", (Object)x, (Object)y, (Object)z);
            return new ComponentTFHollowHill(feature, world, rand, 0, 2, x, y, z);
        }
        if (feature == TFFeature.hill3) {
            TwilightForestMod.LOGGER.info("Hill 3 @ {} {} {}", (Object)x, (Object)y, (Object)z);
            return new ComponentTFHollowHill(feature, world, rand, 0, 3, x, y, z);
        }
        if (feature == TFFeature.questGrove) {
            TwilightForestMod.LOGGER.info("Quest Grove @ {} {} {}", (Object)x, (Object)y, (Object)z);
            return new ComponentTFQuestGrove(feature, world, rand, 0, x, y, z);
        }
        if (feature == TFFeature.hydraLair) {
            TwilightForestMod.LOGGER.info("Hydra Lair @ {} {} {}", (Object)x, (Object)y, (Object)z);
            return new ComponentTFHydraLair(feature, world, rand, 0, x, y, z);
        }
        if (feature == TFFeature.yetiCave) {
            TwilightForestMod.LOGGER.info("Yeti Cave @ {} {} {}", (Object)x, (Object)y, (Object)z);
            return new ComponentTFYetiCave(feature, world, rand, 0, x, y, z);
        }
        if (feature == TFFeature.lichTower) {
            TwilightForestMod.LOGGER.info("Lich Tower @ {} {} {}", (Object)x, (Object)y, (Object)z);
            return new ComponentTFTowerMain(feature, world, rand, 0, x, y, z);
        }
        if (feature == TFFeature.trollCave) {
            TwilightForestMod.LOGGER.info("Troll Cave @ {} {} {}", (Object)x, (Object)y, (Object)z);
            return new ComponentTFTrollCaveMain(feature, world, rand, 0, x, y, z);
        }
        if (feature == TFFeature.iceTower) {
            TwilightForestMod.LOGGER.info("Ice Tower @ {} {} {}", (Object)x, (Object)y, (Object)z);
            return new ComponentTFIceTowerMain(feature, world, rand, 0, x, y, z);
        }
        if (feature == TFFeature.darkTower) {
            return new ComponentTFDarkTowerMain(feature, world, rand, 0, x, y - 1, z);
        }
        if (feature == TFFeature.labyrinth) {
            return new ComponentTFMazeRuins(feature, world, rand, 0, x, y, z);
        }
        if (feature == TFFeature.mushroomTower) {
            return new ComponentTFMushroomTowerMain(feature, world, rand, 0, x, y, z);
        }
        if (feature == TFFeature.tfStronghold) {
            return new ComponentTFStrongholdEntrance(feature, world, rand, 0, x, y, z);
        }
        if (feature == TFFeature.finalCastle) {
            return new ComponentTFFinalCastleMain(feature, world, rand, 0, x, y, z);
        }
        return null;
    }

    public boolean func_75069_d() {
        return this.feature.isStructureEnabled;
    }

    protected void moveToAvgGroundLevel(World world, int x, int z) {
        if (world.func_72959_q() instanceof TFBiomeProvider) {
            Biome biomeAt = world.func_180494_b(new BlockPos(x, 0, z));
            int offY = (int)((biomeAt.func_185355_j() + biomeAt.func_185360_m()) * 8.0f);
            if (biomeAt == TFBiomes.darkForest) {
                offY += 4;
            }
            if (offY > 0) {
                this.field_75074_b.func_78886_a(0, offY, 0);
                for (StructureComponent com : this.func_186161_c()) {
                    com.func_74874_b().func_78886_a(0, offY, 0);
                }
            }
        }
    }

    private boolean isIntersectingLarger(StructureBoundingBox chunkBB, StructureComponent component) {
        StructureBoundingBox compBB = component.func_74874_b();
        return compBB.field_78893_d + 1 >= chunkBB.field_78897_a && compBB.field_78897_a - 1 <= chunkBB.field_78893_d && compBB.field_78892_f + 1 >= chunkBB.field_78896_c && compBB.field_78896_c - 1 <= chunkBB.field_78892_f;
    }

    private boolean isShieldable(StructureComponent component) {
        return component.func_74874_b().field_78894_e <= 32;
    }

    private void addShieldFor(World world, StructureComponent component, List<StructureComponent> otherComponents, StructureBoundingBox chunkBox) {
        StructureBoundingBox shieldBox = new StructureBoundingBox(component.func_74874_b());
        --shieldBox.field_78897_a;
        --shieldBox.field_78895_b;
        --shieldBox.field_78896_c;
        ++shieldBox.field_78893_d;
        ++shieldBox.field_78894_e;
        ++shieldBox.field_78892_f;
        ArrayList<StructureComponent> intersecting = new ArrayList<StructureComponent>();
        for (StructureComponent other : otherComponents) {
            if (other == component || !shieldBox.func_78884_a(other.func_74874_b())) continue;
            intersecting.add(other);
        }
        for (int x = shieldBox.field_78897_a; x <= shieldBox.field_78893_d; ++x) {
            for (int y = shieldBox.field_78895_b; y <= shieldBox.field_78894_e; ++y) {
                for (int z = shieldBox.field_78896_c; z <= shieldBox.field_78892_f; ++z) {
                    BlockPos pos;
                    if (x != shieldBox.field_78897_a && x != shieldBox.field_78893_d && y != shieldBox.field_78895_b && y != shieldBox.field_78894_e && z != shieldBox.field_78896_c && z != shieldBox.field_78892_f || !chunkBox.func_175898_b((Vec3i)(pos = new BlockPos(x, y, z)))) continue;
                    boolean notIntersecting = true;
                    for (StructureComponent other : intersecting) {
                        if (!other.func_74874_b().func_175898_b((Vec3i)pos)) continue;
                        notIntersecting = false;
                    }
                    if (!notIntersecting) continue;
                    world.func_180501_a(pos, TFBlocks.shield.func_176223_P().func_177226_a((IProperty)TFBlockProperties.FACING, (Comparable)this.calculateShieldFacing(shieldBox, x, y, z)), 2);
                }
            }
        }
    }

    private EnumFacing calculateShieldFacing(StructureBoundingBox shieldBox, int x, int y, int z) {
        EnumFacing facing = EnumFacing.DOWN;
        if (x == shieldBox.field_78897_a) {
            facing = EnumFacing.EAST;
        }
        if (x == shieldBox.field_78893_d) {
            facing = EnumFacing.WEST;
        }
        if (z == shieldBox.field_78896_c) {
            facing = EnumFacing.SOUTH;
        }
        if (z == shieldBox.field_78892_f) {
            facing = EnumFacing.NORTH;
        }
        if (y == shieldBox.field_78895_b) {
            facing = EnumFacing.UP;
        }
        if (y == shieldBox.field_78894_e) {
            facing = EnumFacing.DOWN;
        }
        return facing;
    }

    public void func_143022_a(NBTTagCompound par1NBTTagCompound) {
        super.func_143022_a(par1NBTTagCompound);
        par1NBTTagCompound.func_74757_a("Conquered", this.isConquered);
        par1NBTTagCompound.func_74768_a("FeatureID", this.feature.featureID);
        par1NBTTagCompound.func_74773_a("Locks", this.lockBytes);
    }

    public void func_143017_b(NBTTagCompound nbttagcompound) {
        super.func_143017_b(nbttagcompound);
        this.isConquered = nbttagcompound.func_74767_n("Conquered");
        this.feature = TFFeature.featureList[nbttagcompound.func_74762_e("FeatureID")];
        this.lockBytes = nbttagcompound.func_74770_j("Locks");
    }

    public boolean isLocked(int lockIndex) {
        if (lockIndex < this.lockBytes.length) {
            TwilightForestMod.LOGGER.info("Checking locks for lockIndex " + lockIndex);
            for (int i = 0; i < this.lockBytes.length; ++i) {
                TwilightForestMod.LOGGER.info("Lock " + i + " = " + this.lockBytes[i]);
            }
            return this.lockBytes[lockIndex] != 0;
        }
        TwilightForestMod.LOGGER.info("Current lock index, " + lockIndex + " is beyond array bounds " + this.lockBytes.length);
        return false;
    }

    static {
        MapGenStructureIO.func_143034_b(StructureTFMajorFeatureStart.class, (String)"TFFeature");
        MapGenStructureIO.func_143034_b(StructureTFHollowTreeStart.class, (String)"TFHollowTree");
        TFFinalCastlePieces.registerFinalCastlePieces();
        TFStrongholdPieces.registerPieces();
        TFMushroomTowerPieces.registerPieces();
        TFMinotaurMazePieces.registerPieces();
        TFDarkTowerPieces.registerPieces();
        TFIceTowerPieces.registerPieces();
        TFTrollCavePieces.registerPieces();
        TFHollowTreePieces.registerPieces();
        TFLichTowerPieces.registerPieces();
        MapGenStructureIO.func_143031_a(ComponentTFHedgeMaze.class, (String)"TFHedge");
        MapGenStructureIO.func_143031_a(ComponentTFHollowHill.class, (String)"TFHill");
        MapGenStructureIO.func_143031_a(ComponentTFHydraLair.class, (String)"TFHydra");
        MapGenStructureIO.func_143031_a(ComponentTFNagaCourtyard.class, (String)"TFNaga");
        MapGenStructureIO.func_143031_a(ComponentTFQuestGrove.class, (String)"TFQuest1");
        MapGenStructureIO.func_143031_a(ComponentTFYetiCave.class, (String)"TFYeti");
    }
}

